/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.mediasource.dam.impl;

import com.day.cq.dam.api.Rendition;
import com.day.image.Layer;
import io.wcm.handler.media.CropDimension;
import io.wcm.handler.media.impl.ImageFileServlet;
import io.wcm.handler.mediasource.dam.impl.DamContext;
import io.wcm.handler.mediasource.dam.impl.RenditionMetadata;
import io.wcm.handler.mediasource.dam.impl.dynamicmedia.DynamicMediaPath;
import java.io.InputStream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VirtualTransformedRenditionMetadata
extends RenditionMetadata {
    private final long width;
    private final long height;
    private final CropDimension cropDimension;
    private final Integer rotation;

    VirtualTransformedRenditionMetadata(Rendition rendition, long width, long height, CropDimension cropDimension, Integer rotation) {
        super(rendition);
        this.width = width;
        this.height = height;
        this.cropDimension = cropDimension;
        this.rotation = rotation;
    }

    @Override
    public String getFileName(boolean contentDispositionAttachment) {
        return ImageFileServlet.getImageFileName(super.getFileName(contentDispositionAttachment));
    }

    @Override
    public long getFileSize() {
        return 0L;
    }

    @Override
    public long getWidth() {
        return this.width;
    }

    @Override
    public long getHeight() {
        return this.height;
    }

    public CropDimension getCropDimension() {
        return this.cropDimension;
    }

    public Integer getRotation() {
        return this.rotation;
    }

    @Override
    @NotNull
    public String getMediaPath(boolean contentDispositionAttachment) {
        return RenditionMetadata.buildMediaPath(this.getRendition().getPath() + "." + ImageFileServlet.buildSelectorString(this.getWidth(), this.getHeight(), this.cropDimension, this.rotation, contentDispositionAttachment) + "." + "file", this.getFileName(contentDispositionAttachment));
    }

    @Override
    @Nullable
    public String getDynamicMediaPath(boolean contentDispositionAttachment, DamContext damContext) {
        if (contentDispositionAttachment) {
            return null;
        }
        return DynamicMediaPath.buildImage(damContext, this.getWidth(), this.getHeight(), this.cropDimension, this.rotation);
    }

    @Override
    protected Layer getLayer() {
        Layer layer = super.getLayer();
        if (layer != null) {
            if (this.cropDimension != null) {
                layer.crop(this.cropDimension.getRectangle());
                if (this.width <= (long)layer.getWidth() && this.height <= (long)layer.getHeight()) {
                    layer.resize((int)this.width, (int)this.height);
                }
            }
            if (this.rotation != null) {
                layer.rotate((double)this.rotation.intValue());
            }
        }
        return layer;
    }

    @Override
    protected InputStream getInputStream() {
        return null;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getRendition().getPath()).append(this.width).append(this.height).append((Object)this.cropDimension).append((Object)this.rotation).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        VirtualTransformedRenditionMetadata other = (VirtualTransformedRenditionMetadata)obj;
        return new EqualsBuilder().append((Object)this.getRendition().getPath(), (Object)other.getRendition().getPath()).append(this.width, other.width).append(this.height, other.height).append((Object)this.cropDimension, (Object)other.cropDimension).append((Object)this.rotation, (Object)other.rotation).build();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(" -> ").append(Long.toString(this.width)).append("x").append(Long.toString(this.height));
        if (this.cropDimension != null) {
            sb.append(", ").append(this.cropDimension.toString());
        }
        if (this.rotation != null) {
            sb.append(", rotation:").append(Integer.toString(this.rotation));
        }
        return sb.toString();
    }
}

