/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.accesscontrol.SystemUser;
import org.apache.sling.feature.cpconverter.accesscontrol.User;
import org.apache.sling.feature.cpconverter.handlers.AbstractUserEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.AbstractUserParser;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.shared.RepoPath;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.Attributes;

public final class UsersEntryHandler
extends AbstractUserEntryHandler {
    public UsersEntryHandler() {
        this("/jcr_root(/home/users/.*/)\\.content.xml");
    }

    public UsersEntryHandler(@NotNull String regex) {
        super(regex);
    }

    @Override
    public EntryHandler withConfig(@NotNull String config) {
        return new UsersEntryHandler(config);
    }

    @Override
    AbstractUserParser createParser(@NotNull ContentPackage2FeatureModelConverter converter, @NotNull RepoPath originalPath, @NotNull RepoPath intermediatePath) {
        return new UserParser(converter, originalPath, intermediatePath);
    }

    private static final class UserParser
    extends AbstractUserParser {
        private static final String REP_SYSTEM_USER = "rep:SystemUser";
        private static final String REP_USER = "rep:User";
        private boolean isSystemUser = false;

        public UserParser(@NotNull ContentPackage2FeatureModelConverter converter, @NotNull RepoPath path, @NotNull RepoPath intermediatePath) {
            super(converter, path, intermediatePath, REP_SYSTEM_USER, REP_USER);
        }

        @Override
        void handleUser(@NotNull String id, @NotNull Attributes attributes) {
            String disabledReason = attributes.getValue("rep:disabled");
            if (REP_USER.equals(this.detectedPrimaryType)) {
                this.converter.getAclManager().addUser(new User(id, this.path, this.intermediatePath, disabledReason));
            } else {
                this.converter.getAclManager().addSystemUser(new SystemUser(id, this.path, this.intermediatePath, disabledReason));
                this.isSystemUser = true;
            }
        }

        @Override
        protected Boolean getParsingResult() {
            return this.isSystemUser;
        }
    }
}

