/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.felix.framework.Logger;
import org.apache.sling.launchpad.api.StartupHandler;
import org.apache.sling.launchpad.api.StartupListener;
import org.apache.sling.launchpad.api.StartupMode;
import org.apache.sling.launchpad.api.StartupService;
import org.apache.sling.launchpad.base.impl.MBeanStartupListener;
import org.apache.sling.launchpad.base.impl.StartupManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DefaultStartupHandler
implements StartupHandler,
BundleListener,
FrameworkListener,
Runnable {
    private final Logger logger;
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final AtomicInteger startupShouldWait = new AtomicInteger(0);
    private final BlockingQueue<Boolean> queue = new LinkedBlockingQueue<Boolean>();
    private final StartLevel startLevelService;
    private final long targetStartLevel;
    private final StartupMode startupMode;
    private final ServiceTracker<StartupListener, StartupListener> listenerTracker;
    private final int expectedBundlesCount;
    private final Set<String> activeBundles = new HashSet<String>();
    private final BundleContext bundleContext;
    private final boolean useIncremental;
    private final StartupListener mbeanStartupListener;
    private final long startedAt;
    private final StartupManager startupManager;
    private volatile Object[] logService;

    public DefaultStartupHandler(final BundleContext context, final Logger logger, StartupManager manager, long startedAt) {
        this.logger = logger;
        this.bundleContext = context;
        this.startedAt = startedAt;
        this.startupMode = manager.getMode();
        this.targetStartLevel = manager.getTargetStartLevel();
        this.startupManager = manager;
        MBeanStartupListener listener = null;
        try {
            listener = new MBeanStartupListener();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mbeanStartupListener = listener;
        this.listenerTracker = new ServiceTracker<StartupListener, StartupListener>(context, StartupListener.class, new ServiceTrackerCustomizer<StartupListener, StartupListener>(){

            @Override
            public void removedService(ServiceReference<StartupListener> reference, StartupListener service) {
                context.ungetService(reference);
            }

            @Override
            public void modifiedService(ServiceReference<StartupListener> reference, StartupListener service) {
            }

            @Override
            public StartupListener addingService(ServiceReference<StartupListener> reference) {
                StartupListener listener = context.getService(reference);
                if (listener != null) {
                    try {
                        listener.inform(DefaultStartupHandler.this.startupMode, DefaultStartupHandler.this.finished.get());
                    }
                    catch (Throwable t) {
                        logger.log(1, "Error calling StartupListener " + listener, t);
                    }
                }
                return listener;
            }
        });
        this.listenerTracker.open();
        this.startLevelService = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
        context.addFrameworkListener(this);
        boolean bl = this.useIncremental = this.startupMode != StartupMode.RESTART && manager.isIncrementalStartupEnabled();
        if (!this.useIncremental) {
            Bundle[] bundles = context.getBundles();
            this.expectedBundlesCount = bundles != null && bundles.length > 0 ? bundles.length : 10;
            context.addBundleListener(this);
        } else {
            this.expectedBundlesCount = 10;
        }
        this.bundleContext.registerService(StartupHandler.class.getName(), (Object)this, null);
        this.log(3, "Started startup handler with target start level=" + String.valueOf(this.targetStartLevel) + ", and expected bundle count=" + String.valueOf(this.expectedBundlesCount));
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public StartupMode getMode() {
        return this.startupMode;
    }

    @Override
    public boolean isFinished() {
        return this.finished.get();
    }

    @Override
    public void run() {
        while (!this.finished.get()) {
            Boolean doInc = null;
            try {
                doInc = this.queue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (doInc == null || !doInc.booleanValue()) continue;
            if (this.startupShouldWait.get() == 0) {
                this.sleep(2000L);
            }
            while (this.startupShouldWait.get() != 0) {
                this.sleep(50L);
            }
            this.incStartLevel();
        }
    }

    private void incStartLevel() {
        int newLevel = this.startLevelService.getStartLevel() + 1;
        this.log(4, "Increasing start level to " + String.valueOf(newLevel));
        this.startLevelService.setStartLevel(newLevel);
    }

    @Override
    public void waitWithStartup(boolean flag) {
        this.log(4, "Wait with startup " + flag);
        if (flag) {
            this.startupShouldWait.incrementAndGet();
        } else {
            this.startupShouldWait.decrementAndGet();
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void enqueue(boolean info) {
        try {
            this.queue.put(info);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void frameworkEvent(FrameworkEvent event) {
        if (this.finished.get()) {
            return;
        }
        this.log(4, "Received framework event " + event);
        if (!this.useIncremental) {
            if (event.getType() == 1) {
                this.startupFinished();
            }
        } else if (event.getType() == 1) {
            this.enqueue(true);
        } else if (event.getType() == 8) {
            if ((long)this.startLevelService.getStartLevel() >= this.targetStartLevel) {
                this.startupFinished();
            } else {
                this.enqueue(true);
                int startLevel = this.startLevelService.getStartLevel();
                this.log(4, "Startup progress " + String.valueOf(startLevel) + '/' + String.valueOf(this.targetStartLevel));
                float ratio = (float)startLevel / (float)this.targetStartLevel;
                this.startupProgress(ratio);
            }
        }
    }

    private void log(int level, String msg) {
        this.log(null, level, msg, null);
    }

    private void log(int level, String msg, Throwable t) {
        this.log(null, level, msg, t);
    }

    private void log(ServiceReference<?> sRef, int level, String msg, Throwable t) {
        Object ls;
        ServiceReference<?> ref;
        boolean loggedWithService = false;
        if (this.logService == null && (ref = this.bundleContext.getServiceReference("org.osgi.service.log.LogService")) != null && (ls = this.bundleContext.getService(ref)) != null) {
            Class[] formalParams = new Class[]{ServiceReference.class, Integer.TYPE, String.class, Throwable.class};
            try {
                Method logMethod = ls.getClass().getMethod("log", formalParams);
                logMethod.setAccessible(true);
                this.logService = new Object[]{ls, logMethod};
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.logService != null) {
            Object[] params = new Object[]{sRef, new Integer(level), msg, t};
            try {
                ((Method)this.logService[1]).invoke(this.logService[0], params);
                loggedWithService = true;
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (!loggedWithService) {
            this.logger.log(level, msg);
        }
    }

    private void startupFinished() {
        this.log(3, "Startup finished in " + String.valueOf(System.currentTimeMillis() - this.startedAt) + "ms");
        this.finished.set(true);
        for (StartupListener listener : this.listenerTracker.getServices((StartupListener[])new StartupListener[0])) {
            try {
                listener.startupFinished(this.startupMode);
            }
            catch (Throwable t) {
                this.log(1, "Error calling StartupListener " + listener, t);
            }
        }
        if (this.mbeanStartupListener != null) {
            this.mbeanStartupListener.startupFinished(this.startupMode);
        }
        this.enqueue(false);
        this.activeBundles.clear();
        if (!this.useIncremental) {
            this.bundleContext.removeBundleListener(this);
        }
        this.bundleContext.removeFrameworkListener(this);
        Hashtable<String, String> serviceProps = new Hashtable<String, String>();
        ((Dictionary)serviceProps).put(StartupMode.class.getName(), this.startupMode.name());
        ((Dictionary)serviceProps).put("service.description", "Apache Sling Startup Service");
        ((Dictionary)serviceProps).put("service.vendor", "The Apache Software Foundation");
        this.bundleContext.registerService(StartupService.class, new StartupService(){

            @Override
            public StartupMode getStartupMode() {
                return DefaultStartupHandler.this.startupMode;
            }
        }, serviceProps);
        this.startupManager.markInstalled();
    }

    private void startupProgress(float ratio) {
        for (StartupListener listener : this.listenerTracker.getServices((StartupListener[])new StartupListener[0])) {
            try {
                listener.startupProgress(ratio);
            }
            catch (Throwable t) {
                this.log(1, "Error calling StartupListener " + listener, t);
            }
        }
        if (this.mbeanStartupListener != null) {
            this.mbeanStartupListener.startupProgress(ratio);
        }
    }

    @Override
    public void bundleChanged(BundleEvent event) {
        if (!this.finished.get()) {
            this.log(4, "Received bundle event " + event);
            if (event.getType() == 32 || event.getType() == 2) {
                this.activeBundles.add(event.getBundle().getSymbolicName());
                this.log(4, "Startup progress " + String.valueOf(this.activeBundles.size()) + '/' + String.valueOf(this.expectedBundlesCount));
                float ratio = (float)this.activeBundles.size() / (float)this.expectedBundlesCount;
                this.startupProgress(ratio);
            } else if (event.getType() == 4) {
                this.activeBundles.remove(event.getBundle().getSymbolicName());
            }
        }
    }
}

