/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Collections;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.injectors.ValueMapInjector;
import org.apache.sling.models.testmodels.interfaces.ModelWithDefaultMethods;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultInterfaceMethodTest {
    private ModelAdapterFactory factory;

    DefaultInterfaceMethodTest() {
    }

    @BeforeEach
    void setup() {
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Collections.singletonList(new ValueMapInjector());
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{ModelWithDefaultMethods.class});
    }

    @Test
    void testDefaultInterfaceMethodsCanBeInjected() {
        ValueMapDecorator vm = new ValueMapDecorator(Collections.singletonMap("prop", "the prop"));
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        ModelWithDefaultMethods model = (ModelWithDefaultMethods)this.factory.getAdapter((Object)res, ModelWithDefaultMethods.class);
        Assertions.assertEquals((Object)"the prop", (Object)model.getProp());
    }

    @Test
    void testDefaultInterfaceMethodsDefaultImplementationsAreIgnored() {
        ValueMapDecorator vm = new ValueMapDecorator(Collections.emptyMap());
        Resource res = (Resource)Mockito.mock(Resource.class);
        Mockito.lenient().when((Object)((ValueMap)res.adaptTo(ValueMap.class))).thenReturn((Object)vm);
        ModelWithDefaultMethods model = (ModelWithDefaultMethods)this.factory.getAdapter((Object)res, ModelWithDefaultMethods.class);
        Assertions.assertNull((Object)model.getProp());
    }
}

