/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.couchbase.client.impl;

import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.nosql.couchbase.client.CouchbaseClient;
import org.apache.sling.nosql.couchbase.client.impl.CouchbaseEnvironmentSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true, name="org.apache.sling.nosql.couchbase.client.CouchbaseClient.factory.config", label="Apache Sling NoSQL Couchbase Client", description="Provides access to a preconfigured couchbase client.", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE)
@Service(value={CouchbaseClient.class})
@Property(name="webconsole.configurationFactory.nameHint", value={"{clientId}: {bucketName}"})
public class CouchbaseClientImpl
implements CouchbaseClient {
    @Property(label="Client ID", description="ID to uniquely identify the couchbase client if multiple are defined.")
    static final String CLIENT_ID_PROPERTY = "clientId";
    @Property(label="Enabled", description="Enable or disable couchbase caching.", boolValue={true})
    static final String ENABLED_PROPERTY = "enabled";
    private static final boolean ENABLED_PROPERTY_DEFAULT = true;
    @Property(label="Couchbase Hosts", description="Couchbase cluster host list.", cardinality=0x7FFFFFFF)
    static final String COUCHBASE_HOSTS_PROPERTY = "couchbaseHosts";
    @Property(label="Bucket Name", description="Couchbase bucket name")
    static final String CACHE_BUCKET_NAME_PROPERTY = "bucketName";
    @Property(label="Bucket Password", description="Couchbase bucket password")
    static final String CACHE_BUCKET_PASSWORD_PROPERTY = "bucketPassword";
    private static final Logger log = LoggerFactory.getLogger(CouchbaseClientImpl.class);
    private String clientId;
    private boolean enabled;
    private String[] couchbaseHosts;
    private String bucketName;
    private String bucketPassword;
    private volatile boolean initialized;
    private Cluster cluster;
    private Bucket bucket;

    @Activate
    private void activate(Map<String, Object> config) {
        this.clientId = PropertiesUtil.toString((Object)config.get(CLIENT_ID_PROPERTY), null);
        this.enabled = PropertiesUtil.toBoolean((Object)config.get(ENABLED_PROPERTY), (boolean)true);
        this.couchbaseHosts = PropertiesUtil.toStringArray((Object)config.get(COUCHBASE_HOSTS_PROPERTY));
        this.bucketName = PropertiesUtil.toString((Object)config.get(CACHE_BUCKET_NAME_PROPERTY), null);
        this.bucketPassword = PropertiesUtil.toString((Object)config.get(CACHE_BUCKET_PASSWORD_PROPERTY), null);
        if (!this.enabled) {
            log.info("Couchbase caching for client '{}' is disabled by configuration.", (Object)this.clientId);
            return;
        }
        if (this.couchbaseHosts == null || this.couchbaseHosts.length == 0) {
            this.enabled = false;
            log.warn("No couchbase host configured, client '{}' is disabled.", (Object)this.clientId);
            return;
        }
        if (this.bucketName == null) {
            this.enabled = false;
            log.warn("No couchbase bucket name configured, client '{}' is disabled.", (Object)this.clientId);
            return;
        }
    }

    @Deactivate
    private void deactivate() {
        if (this.bucket != null) {
            this.bucket.close();
            this.bucket = null;
        }
        if (this.cluster != null) {
            this.cluster.disconnect();
            this.cluster = null;
        }
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getBucketName() {
        return this.bucketName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bucket getBucket() {
        if (!this.initialized) {
            CouchbaseClientImpl couchbaseClientImpl = this;
            synchronized (couchbaseClientImpl) {
                if (!this.initialized) {
                    try {
                        this.cluster = CouchbaseEnvironmentSingleton.createCluster(this.couchbaseHosts);
                        this.bucket = CouchbaseEnvironmentSingleton.openBucket(this.cluster, this.bucketName, this.bucketPassword);
                        this.initialized = true;
                    }
                    catch (Throwable ex) {
                        throw new RuntimeException("Unable to connect to couchbase cluster or open couchbase bucket, client '" + this.clientId + "'.", ex);
                    }
                }
            }
        }
        return this.bucket;
    }

    @Override
    public AsyncBucket getAsyncBucket() {
        return this.getBucket().async();
    }
}

