/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.nosql.generic.resource.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.nosql.generic.resource.impl.NoSqlResourceProvider;

class NoSqlValueMap
extends ValueMapDecorator
implements ModifiableValueMap {
    private final Resource resource;
    private final NoSqlResourceProvider resourceProvider;

    public NoSqlValueMap(Map<String, Object> map, Resource resource, NoSqlResourceProvider resourceProvider) {
        super(NoSqlValueMap.convertForWriteAll(map));
        this.resource = resource;
        this.resourceProvider = resourceProvider;
    }

    public <T> T get(String name, Class<T> type) {
        if (type == Date.class) {
            Calendar value = this.get(name, Calendar.class);
            if (value != null) {
                return (T)value.getTime();
            }
        } else {
            if (type == InputStream.class) {
                byte[] data = this.get(name, byte[].class);
                if (data != null) {
                    return (T)new ByteArrayInputStream(data);
                }
                return null;
            }
            if (type == null) {
                return (T)super.get((Object)name);
            }
        }
        return (T)super.get(name, type);
    }

    public Object put(String key, Object value) {
        Object result = super.put(key, NoSqlValueMap.convertForWrite(value));
        this.resourceProvider.markAsChanged(this.resource);
        return result;
    }

    public void putAll(Map<? extends String, ?> map) {
        super.putAll(NoSqlValueMap.convertForWriteAll(map));
        this.resourceProvider.markAsChanged(this.resource);
    }

    public Object remove(Object key) {
        Object result = super.remove(key);
        this.resourceProvider.markAsChanged(this.resource);
        return result;
    }

    public void clear() {
        super.clear();
        this.resourceProvider.markAsChanged(this.resource);
    }

    private static Object convertForWrite(Object value) {
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            value = calendar;
        } else if (value instanceof InputStream) {
            try {
                value = NoSqlValueMap.convertForWrite(IOUtils.toByteArray((InputStream)((InputStream)value)));
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to convert input stream to byte array.");
            }
        } else if (value != null && !NoSqlValueMap.isValidType(value.getClass())) {
            throw new IllegalArgumentException("Data type not supported for NoSqlValueMap: " + value.getClass());
        }
        return value;
    }

    static boolean isValidType(Class clazz) {
        if (clazz.isArray()) {
            if (clazz.getComponentType() == Byte.TYPE) {
                return true;
            }
            return NoSqlValueMap.isValidType(clazz.getComponentType());
        }
        return clazz == String.class || clazz == Integer.class || clazz == Long.class || clazz == Double.class || clazz == Boolean.class || Calendar.class.isAssignableFrom(clazz);
    }

    public static Map<String, Object> convertForWriteAll(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            map.put(entry.getKey(), NoSqlValueMap.convertForWrite(entry.getValue()));
        }
        return map;
    }
}

