/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.post.JakartaPostResponse;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.impl.helper.StreamedChunk;
import org.apache.sling.servlets.post.impl.jackrabbit.Text;
import org.apache.sling.servlets.post.impl.operations.AbstractPostOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamedUploadOperation
extends AbstractPostOperation {
    private static final Logger LOG = LoggerFactory.getLogger(StreamedUploadOperation.class);
    public static final String NT_FILE = "nt:file";
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public boolean isRequestStreamed(SlingJakartaHttpServletRequest request) {
        return request.getAttribute("request-parts-iterator") != null;
    }

    @Override
    protected void doRun(SlingJakartaHttpServletRequest request, JakartaPostResponse response, List<Modification> changes) throws PersistenceException {
        Iterator partsIterator = (Iterator)request.getAttribute("request-parts-iterator");
        HashMap<String, List<String>> formFields = new HashMap<String, List<String>>();
        boolean streamingBodies = false;
        while (partsIterator.hasNext()) {
            Part part = (Part)partsIterator.next();
            String name = part.getName();
            if (this.isFormField(part)) {
                this.addField(formFields, name, part);
                if (!streamingBodies) continue;
                LOG.warn("Form field {} was sent after the bodies started to be streamed. Will not have been available to all streamed bodies. It is recommended to send all form fields before streamed bodies in the POST ", (Object)name);
                continue;
            }
            streamingBodies = true;
            this.writeContent(request.getResourceResolver(), part, formFields, response, changes);
        }
    }

    private void addField(Map<String, List<String>> formFields, String name, Part part) {
        List<String> values = formFields.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            formFields.put(name, values);
        }
        try {
            values.add(IOUtils.toString((InputStream)part.getInputStream(), (String)"UTF-8"));
        }
        catch (IOException e) {
            LOG.error("Failed to read form field " + name, (Throwable)e);
        }
    }

    private void writeContent(ResourceResolver resolver, Part part, Map<String, List<String>> formFields, JakartaPostResponse response, List<Modification> changes) throws PersistenceException {
        String path = response.getPath();
        Resource parentResource = resolver.getResource(path);
        if (!this.resourceExists(parentResource)) {
            throw new IllegalArgumentException("Parent resource must already exist to be able to stream upload content. Please create first ");
        }
        String name = this.getUploadName(part);
        Resource fileResource = parentResource.getChild(name);
        HashMap<String, String> fileProps = new HashMap<String, String>();
        if (fileResource == null) {
            fileProps.put("jcr:primaryType", NT_FILE);
            fileResource = parentResource.getResourceResolver().create(parentResource, name, fileProps);
        }
        StreamedChunk chunk = new StreamedChunk(part, formFields, this.servletContext);
        Resource result = chunk.store(fileResource, changes);
        result.getResourceResolver().commit();
    }

    private boolean isFormField(Part part) {
        return part.getSubmittedFileName() == null;
    }

    private String getUploadName(Part part) {
        String name = part.getName();
        String fileName = part.getSubmittedFileName();
        if ("*".equals(name)) {
            name = fileName;
        }
        name = name.substring(name.lastIndexOf(47) + 1);
        name = name.substring(name.lastIndexOf(92) + 1);
        return Text.escapeIllegalJcrChars(name);
    }

    private boolean resourceExists(Resource resource) {
        return resource != null && !ResourceUtil.isSyntheticResource((Resource)resource);
    }
}

