/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.wiser;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.mail.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageListener;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.auth.LoginAuthenticationHandler;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.PlainAuthenticationHandler;
import org.subethamail.smtp.auth.PluginAuthenticationHandler;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.server.MessageListenerAdapter;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.wiser.WiserMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wiser
implements MessageListener {
    private static Log log = LogFactory.getLog(Wiser.class);
    SMTPServer server;
    List<WiserMessage> messages = Collections.synchronizedList(new ArrayList());

    public Wiser() {
        ArrayList<MessageListener> listeners = new ArrayList<MessageListener>(1);
        listeners.add(this);
        this.server = new SMTPServer(listeners);
        this.server.setPort(25);
        ((MessageListenerAdapter)this.server.getMessageHandlerFactory()).setAuthenticationHandlerFactory(new AuthHandlerFactory());
    }

    public void setPort(int port) {
        this.server.setPort(port);
    }

    public void setHostname(String hostname) {
        this.server.setHostName(hostname);
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }

    public static void main(String[] args) throws Exception {
        Wiser wiser = new Wiser();
        wiser.start();
    }

    @Override
    public boolean accept(String from, String recipient) {
        return true;
    }

    @Override
    public void deliver(String from, String recipient, InputStream data) throws TooMuchDataException, IOException {
        int current;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        data = new BufferedInputStream(data);
        while ((current = data.read()) >= 0) {
            out.write(current);
        }
        this.messages.add(new WiserMessage(this, from, recipient, out.toByteArray()));
    }

    protected Session getSession() {
        return Session.getDefaultInstance((Properties)new Properties());
    }

    public List<WiserMessage> getMessages() {
        return this.messages;
    }

    public SMTPServer getServer() {
        return this.server;
    }

    public class AuthHandlerFactory
    implements AuthenticationHandlerFactory {
        public AuthenticationHandler create() {
            PluginAuthenticationHandler ret = new PluginAuthenticationHandler();
            UsernamePasswordValidator validator = new UsernamePasswordValidator(){

                public void login(String username, String password) throws LoginFailedException {
                    log.info((Object)("Username=" + username));
                    log.info((Object)("Password=" + password));
                }
            };
            ret.addPlugin(new PlainAuthenticationHandler(validator));
            ret.addPlugin(new LoginAuthenticationHandler(validator));
            return ret;
        }
    }
}

