/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.stream.Stream;
import org.apache.sling.testing.mock.osgi.config.ConfigAnnotationUtil;
import org.apache.sling.testing.mock.osgi.config.ConfigTypeContext;
import org.apache.sling.testing.mock.osgi.config.annotations.ConfigCollection;
import org.apache.sling.testing.mock.osgi.config.annotations.TypedConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;

final class ConfigCollectionImpl
implements ConfigCollection {
    private final ExtensionContext extensionContext;
    private final ConfigTypeContext configTypeContext;
    private final ConfigAnnotationUtil.ConfigTypePredicate configTypePredicate;
    private final String applyPid;

    ConfigCollectionImpl(@NotNull ExtensionContext extensionContext, @NotNull ConfigTypeContext configTypeContext, @Nullable ConfigAnnotationUtil.ConfigTypePredicate configTypePredicate, @Nullable String applyPid) {
        this.extensionContext = extensionContext;
        this.configTypeContext = configTypeContext;
        this.configTypePredicate = configTypePredicate;
        this.applyPid = applyPid;
    }

    public Stream<TypedConfig> stream() {
        return this.streamConfigTypeAnnotations().map(annotation -> this.configTypeContext.newTypedConfig(annotation, this.applyPid));
    }

    Stream<Annotation> streamConfigTypeAnnotations() {
        return Stream.concat(this.extensionContext.getElement().stream().flatMap(element -> ConfigAnnotationUtil.findConfigTypeAnnotations((AnnotatedElement)element, (ConfigAnnotationUtil.ConfigTypePredicate)this.configTypePredicate)), this.extensionContext.getParent().stream().flatMap(parentContext -> ConfigCollectionImpl.collect(parentContext, this.configTypeContext, this.configTypePredicate, this.applyPid).streamConfigTypeAnnotations()));
    }

    static ConfigCollectionImpl collect(@NotNull ExtensionContext extensionContext, @NotNull ConfigTypeContext configTypeContext) {
        return ConfigCollectionImpl.collect(extensionContext, configTypeContext, null, null);
    }

    static ConfigCollectionImpl collect(@NotNull ExtensionContext extensionContext, @NotNull ConfigTypeContext configTypeContext, @Nullable ConfigAnnotationUtil.ConfigTypePredicate configTypePredicate, @Nullable String applyPid) {
        return new ConfigCollectionImpl(extensionContext, configTypeContext, configTypePredicate, applyPid);
    }
}

