/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.epub;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.config.Field;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.WriteLimitReachedException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.FilenameUtils;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.epub.EpubContentParser;
import org.apache.tika.parser.epub.OPFParser;
import org.apache.tika.parser.xml.DcXMLParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.ParserUtils;
import org.apache.tika.utils.XMLReaderUtils;
import org.apache.tika.zip.utils.ZipSalvager;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class EpubParser
implements Parser {
    private static final long serialVersionUID = 215176772484050550L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("epub+zip"), MediaType.application("x-ibooks+zip"))));
    private static final String META_INF_ENCRYPTION = "META-INF/encryption.xml";
    @Field
    boolean streaming = false;
    private Parser meta = new DcXMLParser();
    private Parser opf = new OPFParser();
    private Parser content = new EpubContentParser();

    public Parser getMetaParser() {
        return this.meta;
    }

    public void setMetaParser(Parser meta) {
        this.meta = meta;
    }

    public Parser getContentParser() {
        return this.content;
    }

    public void setContentParser(Parser content) {
        this.content = content;
    }

    @Field
    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        IOException caughtException = null;
        EmbeddedContentHandler childHandler = new EmbeddedContentHandler(new EpubNormalizingHandler(new BodyContentHandler(xhtml)));
        Set<String> encryptedItems = Collections.EMPTY_SET;
        if (this.streaming) {
            try {
                this.streamingParse(stream, childHandler, metadata, context);
            }
            catch (IOException e) {
                caughtException = e;
            }
        } else {
            try {
                encryptedItems = this.bufferedParse(stream, childHandler, xhtml, metadata, context);
            }
            catch (IOException e) {
                caughtException = e;
            }
        }
        xhtml.endDocument();
        if (caughtException != null) {
            throw caughtException;
        }
        this.maybeThrowEncryptedException(encryptedItems);
    }

    private Set<String> streamingParse(InputStream stream, ContentHandler bodyHandler, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        ZipArchiveInputStream zip = new ZipArchiveInputStream(stream, "UTF-8", false, true, false);
        ZipArchiveEntry entry = zip.getNextEntry();
        SAXException sax = null;
        while (entry != null) {
            block14: {
                if (entry.getName().equals("mimetype")) {
                    this.updateMimeType(zip, metadata);
                } else if (entry.getName().equals(META_INF_ENCRYPTION)) {
                    this.checkForDRM(zip, context);
                } else if (entry.getName().equals("metadata.xml")) {
                    this.meta.parse(zip, new DefaultHandler(), metadata, context);
                } else if (entry.getName().endsWith(".opf")) {
                    this.opf.parse(zip, new DefaultHandler(), metadata, context);
                } else if (entry.getName().endsWith(".htm") || entry.getName().endsWith(".html") || entry.getName().endsWith(".xhtml") || entry.getName().endsWith(".xml")) {
                    try {
                        this.content.parse(zip, bodyHandler, metadata, context);
                    }
                    catch (SAXException e) {
                        if (WriteLimitReachedException.isWriteLimitReached(e)) {
                            throw e;
                        }
                        if (sax != null) break block14;
                        sax = e;
                    }
                }
            }
            entry = zip.getNextEntry();
        }
        if (sax != null) {
            throw sax;
        }
        return Collections.EMPTY_SET;
    }

    private void updateMimeType(InputStream is, Metadata metadata) throws IOException {
        String type = IOUtils.toString(is, StandardCharsets.UTF_8);
        if (type != null) {
            type = type.trim();
        }
        metadata.set("Content-Type", type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> bufferedParse(InputStream stream, ContentHandler bodyHandler, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        TikaInputStream tis;
        TemporaryResources temporaryResources = null;
        if (TikaInputStream.isTikaInputStream(stream)) {
            tis = TikaInputStream.cast(stream);
            if (tis.getOpenContainer() instanceof ZipFile) {
                return this.bufferedParseZipFile((ZipFile)tis.getOpenContainer(), bodyHandler, xhtml, metadata, context, true);
            }
        } else {
            temporaryResources = new TemporaryResources();
            tis = TikaInputStream.get(CloseShieldInputStream.wrap(stream), temporaryResources, metadata);
        }
        ZipFile zipFile = null;
        try {
            zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(tis.getPath().toFile())).get();
        }
        catch (IOException e) {
            ParserUtils.recordParserFailure(this, e, metadata);
            Set<String> set = this.trySalvage(tis.getPath(), bodyHandler, xhtml, metadata, context);
            return set;
        }
        finally {
            if (temporaryResources != null) {
                tis.close();
            }
        }
        try {
            Set<String> set = this.bufferedParseZipFile(zipFile, bodyHandler, xhtml, metadata, context, true);
            return set;
        }
        finally {
            zipFile.close();
        }
    }

    private Set<String> trySalvage(Path brokenZip, ContentHandler bodyHandler, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        try (TemporaryResources resources = new TemporaryResources();){
            Set<String> set;
            block20: {
                Path salvaged = resources.createTempFile(FilenameUtils.getSuffixFromPath(brokenZip.getFileName().toString()));
                ZipSalvager.salvageCopy(brokenZip.toFile(), salvaged.toFile());
                ZipFile zipFile = ((ZipFile.Builder)ZipFile.builder().setFile(salvaged.toFile())).get();
                try {
                    set = this.bufferedParseZipFile(zipFile, bodyHandler, xhtml, metadata, context, false);
                    if (zipFile == null) break block20;
                }
                catch (Throwable throwable) {
                    try {
                        if (zipFile != null) {
                            try {
                                zipFile.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (EpubZipException e) {
                        Set<String> set2;
                        block21: {
                            TikaInputStream is = TikaInputStream.get(salvaged);
                            try {
                                set2 = this.streamingParse(is, xhtml, metadata, context);
                                if (is == null) break block21;
                            }
                            catch (Throwable throwable3) {
                                if (is != null) {
                                    try {
                                        ((InputStream)is).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                }
                                throw throwable3;
                            }
                            ((InputStream)is).close();
                        }
                        resources.close();
                        return set2;
                    }
                }
                zipFile.close();
            }
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> bufferedParseZipFile(ZipFile zipFile, ContentHandler bodyHandler, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context, boolean isStrict) throws IOException, TikaException, SAXException, EpubZipException {
        String rootOPF = this.getRoot(zipFile, context);
        if (rootOPF == null) {
            throw new EpubZipException();
        }
        ZipArchiveEntry zae = zipFile.getEntry(rootOPF);
        if (zae == null || !zipFile.canReadEntryData(zae)) {
            throw new EpubZipException();
        }
        this.opf.parse(zipFile.getInputStream(zae), new DefaultHandler(), metadata, context);
        ContentOrderScraper contentOrderScraper = new ContentOrderScraper();
        try (InputStream is = zipFile.getInputStream(zae);){
            XMLReaderUtils.parseSAX(is, (ContentHandler)contentOrderScraper, context);
        }
        if (contentOrderScraper.contentItems.size() == 0) {
            throw new EpubZipException();
        }
        String relativePath = "";
        if (rootOPF.lastIndexOf("/") > -1) {
            relativePath = rootOPF.substring(0, rootOPF.lastIndexOf("/") + 1);
        }
        if (isStrict) {
            int found = 0;
            for (String id : contentOrderScraper.contentItems) {
                HRefMediaPair hRefMediaPair = contentOrderScraper.locationMap.get(id);
                if (hRefMediaPair == null || hRefMediaPair.href == null || (zae = zipFile.getEntry(relativePath + hRefMediaPair.href)) == null || !zipFile.canReadEntryData(zae)) continue;
                ++found;
            }
            if (found != contentOrderScraper.contentItems.size()) {
                throw new EpubZipException();
            }
        }
        this.extractMetadata(zipFile, metadata, context);
        Set<String> encryptedItems = this.checkForDRM(zipFile);
        HashSet<String> processed = new HashSet<String>();
        HashSet<SAXException> saxExceptions = new HashSet<SAXException>();
        for (String id : contentOrderScraper.contentItems) {
            HRefMediaPair hRefMediaPair = contentOrderScraper.locationMap.get(id);
            if (hRefMediaPair == null || hRefMediaPair.href == null) continue;
            boolean shouldParse = false;
            String href = hRefMediaPair.href.toLowerCase(Locale.US);
            if (hRefMediaPair.media != null) {
                String mediaType = hRefMediaPair.media.toLowerCase(Locale.US);
                if (mediaType.contains("html")) {
                    shouldParse = true;
                }
            } else if (href.endsWith("htm") || href.endsWith("html") || href.endsWith(".xml")) {
                shouldParse = true;
            }
            if (!shouldParse) continue;
            String path = relativePath + hRefMediaPair.href;
            if (encryptedItems.contains(path)) {
                this.maybeThrowEncryptedException(encryptedItems);
            }
            if ((zae = zipFile.getEntry(relativePath + hRefMediaPair.href)) == null) continue;
            try {
                InputStream is = zipFile.getInputStream(zae);
                try {
                    this.content.parse(is, bodyHandler, metadata, context);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (SAXException e) {
                if (WriteLimitReachedException.isWriteLimitReached(e)) {
                    throw e;
                }
                saxExceptions.add(e);
            }
            finally {
                processed.add(id);
            }
        }
        EmbeddedDocumentExtractor embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        for (String id : contentOrderScraper.locationMap.keySet()) {
            if (processed.contains(id)) continue;
            HRefMediaPair hRefMediaPair = contentOrderScraper.locationMap.get(id);
            String fullPath = relativePath + hRefMediaPair.href;
            if (encryptedItems.contains(fullPath) || !this.shouldHandleEmbedded(hRefMediaPair.media)) continue;
            this.handleEmbedded(zipFile, relativePath, hRefMediaPair, embeddedDocumentExtractor, xhtml, metadata);
        }
        Iterator<String> iterator = saxExceptions.iterator();
        if (iterator.hasNext()) {
            SAXException e = (SAXException)((Object)iterator.next());
            throw e;
        }
        return encryptedItems;
    }

    private Set<String> checkForDRM(ZipFile zipFile) throws IOException, TikaException, SAXException {
        ZipArchiveEntry zae = zipFile.getEntry(META_INF_ENCRYPTION);
        if (zae == null) {
            return Collections.EMPTY_SET;
        }
        try (InputStream is = zipFile.getInputStream(zae);){
            Set<String> set = EncryptionHandler.parse(is, new ParseContext());
            return set;
        }
    }

    private void checkForDRM(InputStream is, ParseContext parseContext) throws IOException, TikaException, SAXException {
        Set<String> encryptedItems = EncryptionHandler.parse(is, parseContext);
        this.maybeThrowEncryptedException(encryptedItems);
    }

    private void maybeThrowEncryptedException(Set<String> encryptedItems) throws EncryptedDocumentException {
        if (encryptedItems.size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("EPUB contains encrypted items: ");
        int added = 0;
        for (String u : encryptedItems) {
            if (sb.length() > 500) {
                sb.append(" and others...");
                break;
            }
            if (added++ > 0) {
                sb.append(", ");
            }
            sb.append(u);
        }
        throw new EncryptedDocumentException(sb.toString());
    }

    private boolean shouldHandleEmbedded(String media) {
        if (media == null) {
            return true;
        }
        String lc = media.toLowerCase(Locale.US);
        if (lc.contains("css")) {
            return false;
        }
        if (lc.contains("svg")) {
            return false;
        }
        if (lc.endsWith("/xml")) {
            return false;
        }
        if (lc.contains("x-ibooks")) {
            return false;
        }
        return !lc.equals("application/x-dtbncx+xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEmbedded(ZipFile zipFile, String relativePath, HRefMediaPair hRefMediaPair, EmbeddedDocumentExtractor embeddedDocumentExtractor, XHTMLContentHandler xhtml, Metadata parentMetadata) throws IOException, SAXException {
        if (hRefMediaPair.href == null) {
            return;
        }
        String fullPath = relativePath + hRefMediaPair.href;
        ZipArchiveEntry ze = zipFile.getEntry(fullPath);
        if (ze == null || !zipFile.canReadEntryData(ze)) {
            return;
        }
        Metadata embeddedMetadata = new Metadata();
        if (!StringUtils.isBlank(hRefMediaPair.media)) {
            embeddedMetadata.set("Content-Type", hRefMediaPair.media);
        }
        embeddedMetadata.set("resourceName", fullPath);
        if (!embeddedDocumentExtractor.shouldParseEmbedded(embeddedMetadata)) {
            return;
        }
        TikaInputStream stream = null;
        try {
            stream = TikaInputStream.get(zipFile.getInputStream(ze));
        }
        catch (IOException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException(e, parentMetadata);
            return;
        }
        xhtml.startElement("div", "class", "embedded");
        try {
            boolean outputHtml = true;
            if (hRefMediaPair.media.contains("font") || hRefMediaPair.href.startsWith("fonts")) {
                outputHtml = false;
            }
            embeddedDocumentExtractor.parseEmbedded(stream, new EmbeddedContentHandler(xhtml), embeddedMetadata, outputHtml);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
        xhtml.endElement("div");
    }

    private void extractMetadata(ZipFile zipFile, Metadata metadata, ParseContext context) throws IOException, TikaException, SAXException {
        InputStream is;
        ZipArchiveEntry zae = zipFile.getEntry("mimetype");
        if (zae != null && zipFile.canReadEntryData(zae)) {
            is = zipFile.getInputStream(zae);
            try {
                this.updateMimeType(is, metadata);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        if ((zae = zipFile.getEntry("metadata.xml")) != null && zipFile.canReadEntryData(zae)) {
            is = zipFile.getInputStream(zae);
            try {
                this.meta.parse(is, new DefaultHandler(), metadata, context);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
    }

    private String getRoot(ZipFile zipFile, ParseContext context) throws IOException, TikaException, SAXException {
        ZipArchiveEntry container = zipFile.getEntry("META-INF/container.xml");
        if (container != null) {
            RootFinder rootFinder = new RootFinder();
            try (InputStream is = zipFile.getInputStream(container);){
                XMLReaderUtils.parseSAX(is, (ContentHandler)rootFinder, context);
            }
            return rootFinder.root;
        }
        Enumeration<ZipArchiveEntry> entryEnum = zipFile.getEntries();
        while (entryEnum.hasMoreElements()) {
            ZipArchiveEntry ze = entryEnum.nextElement();
            if (!ze.getName().toLowerCase(Locale.US).endsWith(".opf") || !zipFile.canReadEntryData(ze)) continue;
            return ze.getName();
        }
        return null;
    }

    private static class EpubNormalizingHandler
    extends ContentHandlerDecorator {
        public EpubNormalizingHandler(ContentHandler contentHandler) {
            super(contentHandler);
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            boolean needToRewrite = false;
            for (int i = 0; i < atts.getLength(); ++i) {
                if (atts.getQName(i) == null || atts.getQName(i).equals(atts.getLocalName(i))) continue;
                needToRewrite = true;
                break;
            }
            if (needToRewrite) {
                AttributesImpl simplifiedAtts = new AttributesImpl();
                for (int i = 0; i < atts.getLength(); ++i) {
                    simplifiedAtts.addAttribute("", atts.getLocalName(i), atts.getLocalName(i), atts.getType(i), atts.getValue(i));
                }
                super.startElement(uri, localName, localName, simplifiedAtts);
            } else {
                super.startElement(uri, localName, localName, atts);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            super.endElement(uri, localName, localName);
        }
    }

    private static class EpubZipException
    extends IOException {
        private EpubZipException() {
        }
    }

    private static class EncryptionHandler
    extends DefaultHandler {
        Set<String> encryptedItems = new HashSet<String>();

        private EncryptionHandler() {
        }

        private static Set<String> parse(InputStream is, ParseContext parseContext) throws TikaException, IOException, SAXException {
            EncryptionHandler handler = new EncryptionHandler();
            XMLReaderUtils.parseSAX(is, (ContentHandler)handler, parseContext);
            return handler.getEncryptedItems();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("CipherReference".equals(localName)) {
                String encryptedUri = XMLReaderUtils.getAttrValue("URI", attributes);
                this.encryptedItems.add(encryptedUri);
            }
        }

        public Set<String> getEncryptedItems() {
            return this.encryptedItems;
        }
    }

    private static class HRefMediaPair {
        private final String href;
        private final String media;

        HRefMediaPair(String href, String media) {
            this.href = href;
            this.media = media;
        }

        public String toString() {
            return "HRefMediaPair{href='" + this.href + "', media='" + this.media + "'}";
        }
    }

    private static class ContentOrderScraper
    extends DefaultHandler {
        Map<String, HRefMediaPair> locationMap = new HashMap<String, HRefMediaPair>();
        List<String> contentItems = new ArrayList<String>();
        boolean inManifest = false;
        boolean inSpine = false;

        private ContentOrderScraper() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            String id;
            if ("manifest".equalsIgnoreCase(localName)) {
                this.inManifest = true;
            } else if ("spine".equalsIgnoreCase(localName)) {
                this.inSpine = true;
            }
            if (this.inManifest && "item".equalsIgnoreCase(localName)) {
                id = XMLReaderUtils.getAttrValue("id", atts);
                String href = XMLReaderUtils.getAttrValue("href", atts);
                String mime = XMLReaderUtils.getAttrValue("media-type", atts);
                if (id != null && href != null) {
                    try {
                        href = URLDecoder.decode(href, StandardCharsets.UTF_8.name());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    this.locationMap.put(id, new HRefMediaPair(href, mime));
                }
            }
            if (this.inSpine && "itemRef".equalsIgnoreCase(localName) && (id = XMLReaderUtils.getAttrValue("idref", atts)) != null) {
                this.contentItems.add(id);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("manifest".equalsIgnoreCase(localName)) {
                this.inManifest = false;
            } else if ("spine".equalsIgnoreCase(localName)) {
                this.inSpine = false;
            }
        }
    }

    private static class RootFinder
    extends DefaultHandler {
        String root = null;

        private RootFinder() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            if ("rootfile".equalsIgnoreCase(localName)) {
                this.root = XMLReaderUtils.getAttrValue("full-path", atts);
            }
        }
    }
}

