/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.wordperfect;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.tika.parser.wordperfect.WP5Charsets;
import org.apache.tika.parser.wordperfect.WPDocumentAreaExtractor;
import org.apache.tika.parser.wordperfect.WPInputStream;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class WP5DocumentAreaExtractor
extends WPDocumentAreaExtractor {
    private static final Map<Integer, Integer> FIXED_LENGTH_FUNCTION_SIZES = MapUtils.putAll(new HashMap(), new Integer[]{192, 4, 193, 9, 194, 11, 195, 3, 196, 3, 197, 5, 198, 6, 199, 7, 200, 4, 201, 5, 202, 6, 203, 6, 204, 8, 205, 10, 206, 10, 207, 12});

    WP5DocumentAreaExtractor() {
    }

    @Override
    protected void extract(int c, WPInputStream in, StringBuilder out, XHTMLContentHandler xhtml) throws IOException, SAXException {
        if (c == 10) {
            this.endParagraph(out, xhtml);
        } else if (c == 11) {
            out.append(' ');
        } else if (c == 12) {
            this.endParagraph(out, xhtml);
        } else if (c == 13) {
            out.append(' ');
        } else if (c >= 32 && c <= 126) {
            out.append((char)c);
        } else if (c == 140) {
            this.endParagraph(out, xhtml);
        } else if (c >= 144 && c <= 149) {
            out.append(' ');
        } else if (c == 153) {
            this.endParagraph(out, xhtml);
        } else if (c == 160) {
            out.append('\u00a0');
        } else if (c >= 169 && c <= 171) {
            out.append('-');
        } else if (c == 192) {
            int charval = in.readWP();
            int charset = in.readWP();
            in.readWP();
            WP5Charsets.append(out, charset, charval);
        } else if (c >= 193 && c <= 207) {
            in.skipWPByte(FIXED_LENGTH_FUNCTION_SIZES.get(c) - 1);
        } else if (c >= 208 && c <= 255) {
            in.readWP();
            int functionSize = in.readWPShort();
            for (int i = 0; i < functionSize; ++i) {
                in.readWP();
            }
        }
    }
}

