/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.LogicalFilter;
import org.apache.sis.filter.internal.Node;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.pending.geoapi.filter.Literal;
import org.apache.sis.pending.geoapi.filter.LogicalOperator;
import org.apache.sis.pending.geoapi.filter.LogicalOperatorName;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.resources.Errors;

public class Optimization {
    private static final Object COMPUTING = Void.TYPE;
    private DefaultFeatureType featureType;
    private Map<Object, Object> done;

    public DefaultFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(DefaultFeatureType type) {
        this.featureType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> Filter<R> apply(Filter<R> filter) {
        boolean isFirstCall;
        if (!(filter instanceof OnFilter)) {
            return filter;
        }
        boolean bl = isFirstCall = this.done == null;
        if (isFirstCall) {
            this.done = new IdentityHashMap<Object, Object>();
        }
        try {
            Object previous = this.done.putIfAbsent(filter, COMPUTING);
            if (previous == COMPUTING) {
                throw new IllegalArgumentException(Errors.format((short)123, filter.getOperatorType()));
            }
            Filter result = (Filter)previous;
            if (result == null && this.done.put(filter, result = ((OnFilter)filter).optimize(this)) != COMPUTING) {
                throw new ConcurrentModificationException();
            }
            Filter filter2 = result;
            return filter2;
        }
        finally {
            if (isFirstCall) {
                this.done = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R, V> Expression<R, ? extends V> apply(Expression<R, V> expression) {
        boolean isFirstCall;
        if (!(expression instanceof OnExpression)) {
            return expression;
        }
        boolean bl = isFirstCall = this.done == null;
        if (isFirstCall) {
            this.done = new IdentityHashMap<Object, Object>();
        }
        try {
            Object previous = this.done.putIfAbsent(expression, COMPUTING);
            if (previous == COMPUTING) {
                throw new IllegalArgumentException(Errors.format((short)123, expression.getFunctionName()));
            }
            Expression result = (Expression)previous;
            if (result == null && this.done.put(expression, result = ((OnExpression)expression).optimize(this)) != COMPUTING) {
                throw new ConcurrentModificationException();
            }
            Expression expression2 = result;
            return expression2;
        }
        finally {
            if (isFirstCall) {
                this.done = null;
            }
        }
    }

    public <R> List<Filter<R>> applyAndDecompose(Filter<R> filter) {
        return Optimization.toAndOperands(this.apply(filter));
    }

    private static <R> List<Filter<R>> toAndOperands(Filter<R> filter) {
        Filter<R> nop;
        if (filter == null) {
            return List.of();
        }
        Enum<?> type = filter.getOperatorType();
        if (type == LogicalOperatorName.AND) {
            return ((LogicalOperator)filter).getOperands();
        }
        if (type == LogicalOperatorName.NOT && (nop = Optimization.getNotOperand(filter)).getOperatorType() == LogicalOperatorName.OR) {
            List operands = ((LogicalOperator)nop).getOperands();
            ArrayList<Filter<R>> result = new ArrayList<Filter<R>>(operands.size());
            for (Filter operand : operands) {
                operand = operand.getOperatorType() == LogicalOperatorName.NOT ? Optimization.getNotOperand(operand) : new LogicalFilter.Not(operand);
                result.add(operand);
            }
            return result;
        }
        return List.of(filter);
    }

    private static <R> Filter<R> getNotOperand(Filter<R> filter) {
        Filter operand = CollectionsExt.singletonOrNull(((LogicalOperator)filter).getOperands());
        if (operand != null) {
            return operand;
        }
        throw new IllegalArgumentException();
    }

    public static Set<FunctionProperty> properties(Filter<?> filter) {
        return Node.transitiveProperties(filter.getExpressions());
    }

    public static Set<FunctionProperty> properties(Expression<?, ?> expression) {
        return Node.properties(expression);
    }

    public static <R, V> Expression<R, V> literal(V value) {
        return new LeafExpression.Literal(value);
    }

    public static interface OnFilter<R>
    extends Filter<R> {
        default public Filter<R> optimize(Optimization optimization) {
            List expressions = this.getExpressions();
            Expression[] effective = new Expression[expressions.size()];
            boolean unchanged = true;
            boolean immediate = true;
            for (int i = 0; i < effective.length; ++i) {
                Expression e = expressions.get(i);
                unchanged &= e == (e = optimization.apply(e));
                immediate &= e instanceof Literal;
                effective[i] = e;
            }
            if (immediate) {
                return this.test(null) ? Filter.include() : Filter.exclude();
            }
            if (unchanged) {
                return this;
            }
            return this.recreate(effective);
        }

        default public Filter<R> recreate(Expression<R, ?>[] effective) {
            return this;
        }

        private Filter<R> castOrNull(Predicate<? super R> other) {
            Class to;
            Class type;
            if (other instanceof Filter && (type = this.getResourceClass()) != null && (to = ((Filter)other).getResourceClass()) != null && type.isAssignableFrom(to)) {
                return (Filter)other;
            }
            return null;
        }

        @Override
        default public Predicate<R> and(Predicate<? super R> other) {
            Filter<? super R> filter = this.castOrNull(other);
            if (filter != null) {
                return new LogicalFilter.And<R>(this, filter);
            }
            return Filter.super.and(other);
        }

        @Override
        default public Predicate<R> or(Predicate<? super R> other) {
            Filter<? super R> filter = this.castOrNull(other);
            if (filter != null) {
                return new LogicalFilter.Or<R>(this, filter);
            }
            return Filter.super.and(other);
        }

        @Override
        default public Predicate<R> negate() {
            return new LogicalFilter.Not(this);
        }
    }

    public static interface OnExpression<R, V>
    extends Expression<R, V> {
        default public Expression<R, ? extends V> optimize(Optimization optimization) {
            List parameters = this.getParameters();
            Expression[] effective = new Expression[parameters.size()];
            boolean unchanged = true;
            boolean immediate = true;
            for (int i = 0; i < effective.length; ++i) {
                Expression e = parameters.get(i);
                unchanged &= e == (e = optimization.apply(e));
                immediate &= e instanceof Literal;
                effective[i] = e;
            }
            if (immediate && !Optimization.properties(this).contains((Object)FunctionProperty.VOLATILE)) {
                return Optimization.literal(this.apply(null));
            }
            if (unchanged) {
                return this;
            }
            return this.recreate(effective);
        }

        default public Expression<R, V> recreate(Expression<R, ?>[] effective) {
            return this;
        }
    }
}

