﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock/Bedrock_EXPORTS.h>
#include <aws/bedrock/model/AutomatedReasoningPolicyBuildLog.h>
#include <aws/bedrock/model/AutomatedReasoningPolicyDefinition.h>
#include <aws/bedrock/model/AutomatedReasoningPolicyDefinitionQualityReport.h>
#include <aws/bedrock/model/AutomatedReasoningPolicyGeneratedTestCases.h>
#include <aws/bedrock/model/AutomatedReasoningPolicyScenarios.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Bedrock {
namespace Model {

/**
 * <p>Contains the various assets generated during a policy build workflow,
 * including logs, quality reports, test cases, and the final policy
 * definition.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/bedrock-2023-04-20/AutomatedReasoningPolicyBuildResultAssets">AWS
 * API Reference</a></p>
 */
class AutomatedReasoningPolicyBuildResultAssets {
 public:
  AWS_BEDROCK_API AutomatedReasoningPolicyBuildResultAssets() = default;
  AWS_BEDROCK_API AutomatedReasoningPolicyBuildResultAssets(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCK_API AutomatedReasoningPolicyBuildResultAssets& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BEDROCK_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The complete policy definition generated by the build workflow, containing
   * all rules, variables, and custom types extracted from the source documents.</p>
   */
  inline const AutomatedReasoningPolicyDefinition& GetPolicyDefinition() const { return m_policyDefinition; }
  inline bool PolicyDefinitionHasBeenSet() const { return m_policyDefinitionHasBeenSet; }
  template <typename PolicyDefinitionT = AutomatedReasoningPolicyDefinition>
  void SetPolicyDefinition(PolicyDefinitionT&& value) {
    m_policyDefinitionHasBeenSet = true;
    m_policyDefinition = std::forward<PolicyDefinitionT>(value);
  }
  template <typename PolicyDefinitionT = AutomatedReasoningPolicyDefinition>
  AutomatedReasoningPolicyBuildResultAssets& WithPolicyDefinition(PolicyDefinitionT&& value) {
    SetPolicyDefinition(std::forward<PolicyDefinitionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A comprehensive report analyzing the quality of the generated policy,
   * including metrics about rule coverage, potential conflicts, and unused
   * elements.</p>
   */
  inline const AutomatedReasoningPolicyDefinitionQualityReport& GetQualityReport() const { return m_qualityReport; }
  inline bool QualityReportHasBeenSet() const { return m_qualityReportHasBeenSet; }
  template <typename QualityReportT = AutomatedReasoningPolicyDefinitionQualityReport>
  void SetQualityReport(QualityReportT&& value) {
    m_qualityReportHasBeenSet = true;
    m_qualityReport = std::forward<QualityReportT>(value);
  }
  template <typename QualityReportT = AutomatedReasoningPolicyDefinitionQualityReport>
  AutomatedReasoningPolicyBuildResultAssets& WithQualityReport(QualityReportT&& value) {
    SetQualityReport(std::forward<QualityReportT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The complete build log containing detailed information about each step in the
   * policy generation process.</p>
   */
  inline const AutomatedReasoningPolicyBuildLog& GetBuildLog() const { return m_buildLog; }
  inline bool BuildLogHasBeenSet() const { return m_buildLogHasBeenSet; }
  template <typename BuildLogT = AutomatedReasoningPolicyBuildLog>
  void SetBuildLog(BuildLogT&& value) {
    m_buildLogHasBeenSet = true;
    m_buildLog = std::forward<BuildLogT>(value);
  }
  template <typename BuildLogT = AutomatedReasoningPolicyBuildLog>
  AutomatedReasoningPolicyBuildResultAssets& WithBuildLog(BuildLogT&& value) {
    SetBuildLog(std::forward<BuildLogT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A comprehensive test suite generated by the build workflow, providing
   * validation capabilities for automated reasoning policies.</p>
   */
  inline const AutomatedReasoningPolicyGeneratedTestCases& GetGeneratedTestCases() const { return m_generatedTestCases; }
  inline bool GeneratedTestCasesHasBeenSet() const { return m_generatedTestCasesHasBeenSet; }
  template <typename GeneratedTestCasesT = AutomatedReasoningPolicyGeneratedTestCases>
  void SetGeneratedTestCases(GeneratedTestCasesT&& value) {
    m_generatedTestCasesHasBeenSet = true;
    m_generatedTestCases = std::forward<GeneratedTestCasesT>(value);
  }
  template <typename GeneratedTestCasesT = AutomatedReasoningPolicyGeneratedTestCases>
  AutomatedReasoningPolicyBuildResultAssets& WithGeneratedTestCases(GeneratedTestCasesT&& value) {
    SetGeneratedTestCases(std::forward<GeneratedTestCasesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An entity encompassing all the policy scenarios generated by the build
   * workflow, which can be used to validate an Automated Reasoning policy. </p>
   */
  inline const AutomatedReasoningPolicyScenarios& GetPolicyScenarios() const { return m_policyScenarios; }
  inline bool PolicyScenariosHasBeenSet() const { return m_policyScenariosHasBeenSet; }
  template <typename PolicyScenariosT = AutomatedReasoningPolicyScenarios>
  void SetPolicyScenarios(PolicyScenariosT&& value) {
    m_policyScenariosHasBeenSet = true;
    m_policyScenarios = std::forward<PolicyScenariosT>(value);
  }
  template <typename PolicyScenariosT = AutomatedReasoningPolicyScenarios>
  AutomatedReasoningPolicyBuildResultAssets& WithPolicyScenarios(PolicyScenariosT&& value) {
    SetPolicyScenarios(std::forward<PolicyScenariosT>(value));
    return *this;
  }
  ///@}
 private:
  AutomatedReasoningPolicyDefinition m_policyDefinition;

  AutomatedReasoningPolicyDefinitionQualityReport m_qualityReport;

  AutomatedReasoningPolicyBuildLog m_buildLog;

  AutomatedReasoningPolicyGeneratedTestCases m_generatedTestCases;

  AutomatedReasoningPolicyScenarios m_policyScenarios;
  bool m_policyDefinitionHasBeenSet = false;
  bool m_qualityReportHasBeenSet = false;
  bool m_buildLogHasBeenSet = false;
  bool m_generatedTestCasesHasBeenSet = false;
  bool m_policyScenariosHasBeenSet = false;
};

}  // namespace Model
}  // namespace Bedrock
}  // namespace Aws
