/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Compute min, max, variance and mean of an Image .


StatisticsImageFilter computes the minimum, maximum, sum, sum of squares, mean, variance
sigma of an image. The filter needs all of its input image. It behaves
as a filter with an input and output. Thus it can be inserted in a
pipeline with other filters and the statistics will only be recomputed
if a downstream filter changes.

This filter is automatically multi-threaded and can stream its input
when NumberOfStreamDivisions is set to more than one. Statistics are independently computed for each streamed and threaded region then
merged.

Internally a compensated summation algorithm is used for the
accumulation of intensities to improve accuracy for large images.


See:
 itk::StatisticsImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkStatisticsImageFilter.h
*/
public class StatisticsImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected StatisticsImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.StatisticsImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(StatisticsImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(StatisticsImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::StatisticsImageFilter::~StatisticsImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_StatisticsImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::StatisticsImageFilter::StatisticsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  StatisticsImageFilter() {
    this(SimpleITKJNI.new_StatisticsImageFilter(), true);
  }

  /**
double itk::simple::StatisticsImageFilter::GetMinimum() const

Return the computed Minimum.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getMinimum() {
    return SimpleITKJNI.StatisticsImageFilter_getMinimum(swigCPtr, this);
  }

  /**
double itk::simple::StatisticsImageFilter::GetMaximum() const

Return the computed Maximum.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getMaximum() {
    return SimpleITKJNI.StatisticsImageFilter_getMaximum(swigCPtr, this);
  }

  /**
double itk::simple::StatisticsImageFilter::GetMean() const

Return the computed Mean.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getMean() {
    return SimpleITKJNI.StatisticsImageFilter_getMean(swigCPtr, this);
  }

  /**
double itk::simple::StatisticsImageFilter::GetSigma() const

Return the computed Standard Deviation.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getSigma() {
    return SimpleITKJNI.StatisticsImageFilter_getSigma(swigCPtr, this);
  }

  /**
double itk::simple::StatisticsImageFilter::GetVariance() const

Return the computed Variance.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getVariance() {
    return SimpleITKJNI.StatisticsImageFilter_getVariance(swigCPtr, this);
  }

  /**
double itk::simple::StatisticsImageFilter::GetSum() const

Return the compute Sum.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getSum() {
    return SimpleITKJNI.StatisticsImageFilter_getSum(swigCPtr, this);
  }

  /**
std::string itk::simple::StatisticsImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.StatisticsImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::StatisticsImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.StatisticsImageFilter_toString(swigCPtr, this);
  }

  /**
void itk::simple::StatisticsImageFilter::Execute(const Image &amp;image)

Execute the filter on the input image

*/
public  void execute(Image image) {
    SimpleITKJNI.StatisticsImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image);
  }

}
