/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.invoke.MethodHandle;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.SplitSuperState;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.ExitableReturn;
import org.jruby.internal.runtime.methods.MethodSplitState;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.ExitableInterpreterContext;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledIRMethod
extends AbstractIRMethod
implements Compilable<DynamicMethod> {
    private MethodHandle specific;
    private final int specificArity;
    private final String encodedArgumentDescriptors;
    private final boolean needsToFindImplementer;

    public CompiledIRMethod(MethodHandle variable, String id, int line, StaticScope scope, Visibility visibility, RubyModule implementationClass, String encodedArgumentDescriptors, boolean recievesKeywordArgs, boolean needsToFindImplementer) {
        this(variable, null, -1, id, line, scope, visibility, implementationClass, encodedArgumentDescriptors, recievesKeywordArgs, needsToFindImplementer);
    }

    public CompiledIRMethod(MethodHandle variable, IRScope method2, Visibility visibility, RubyModule implementationClass, String encodedArgumentDescriptors) {
        this(variable, null, -1, method2.getId(), method2.getLine(), method2.getStaticScope(), visibility, implementationClass, encodedArgumentDescriptors, method2.receivesKeywordArgs(), !(method2 instanceof IRMethod) || method2.getFullInterpreterContext().getFlags().contains((Object)IRFlags.REQUIRES_CLASS));
    }

    public CompiledIRMethod(MethodHandle variable, MethodHandle specific, int specificArity, IRScope method2, Visibility visibility, RubyModule implementationClass, String encodedArgumentDescriptors) {
        this(variable, specific, specificArity, method2.getId(), method2.getLine(), method2.getStaticScope(), visibility, implementationClass, encodedArgumentDescriptors, method2.receivesKeywordArgs(), !(method2 instanceof IRMethod) || method2.getFullInterpreterContext().getFlags().contains((Object)IRFlags.REQUIRES_CLASS));
    }

    public CompiledIRMethod(MethodHandle variable, String id, int line, StaticScope scope, Visibility visibility, RubyModule implementationClass) {
        this(variable, null, -1, id, line, scope, visibility, implementationClass, "", false, false);
    }

    public CompiledIRMethod(MethodHandle variable, MethodHandle specific, int specificArity, String id, int line, StaticScope scope, Visibility visibility, RubyModule implementationClass, String encodedArgumentDescriptors, boolean receivesKeywordArgs, boolean needsToFindImplementer) {
        super(scope, id, line, visibility, implementationClass);
        this.specific = specific;
        this.specificArity = receivesKeywordArgs ? -1 : specificArity;
        this.staticScope.determineModule();
        this.encodedArgumentDescriptors = encodedArgumentDescriptors;
        this.setHandle(variable);
        this.needsToFindImplementer = needsToFindImplementer;
    }

    public MethodHandle getHandleFor(int arity2) {
        if (this.specificArity != -1 && arity2 == this.specificArity) {
            return this.specific;
        }
        return null;
    }

    public void setVariable(MethodHandle variable) {
        super.setHandle(variable);
    }

    public void setSpecific(MethodHandle specific) {
        this.specific = specific;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return ArgumentDescriptor.decode(this.implementationClass.getRuntime(), this.encodedArgumentDescriptors);
    }

    @Override
    public void completeBuild(ThreadContext context, DynamicMethod buildResult) {
    }

    @Override
    protected void printMethodIR() {
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        try {
            return ((MethodHandle)this.handle).invokeExact(context, this.staticScope, self2, args2, block, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        if (this.specificArity != 0) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, block, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (this.specificArity != 1) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0}, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, block, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (this.specificArity != 2) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1}, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, block, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (this.specificArity != 3) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, arg2, block, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
        try {
            return ((MethodHandle)this.handle).invokeExact(context, this.staticScope, self2, args2, Block.NULL_BLOCK, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
        if (this.specificArity != 0) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, Block.NULL_BLOCK, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
        if (this.specificArity != 1) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0}, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, Block.NULL_BLOCK, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        if (this.specificArity != 2) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1}, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, Block.NULL_BLOCK, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (this.specificArity != 3) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, arg2, Block.NULL_BLOCK, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public SplitSuperState<MethodSplitState> startSplitSuperCall(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        ExitableInterpreterContext ic = ((IRMethod)this.getIRScope()).builtInterpreterContextForJavaConstructor();
        if (ic == null) {
            return null;
        }
        MethodSplitState state2 = new MethodSplitState(context, ic, clazz, self2, name2);
        ExitableReturn result2 = this.INTERPRET_METHOD(state2, args2, block);
        return new SplitSuperState<MethodSplitState>(result2, state2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExitableReturn INTERPRET_METHOD(MethodSplitState state2, IRubyObject[] args2, Block block) {
        try {
            ThreadContext.pushBacktrace(state2.context, state2.name, state2.eic.getFileName(), state2.eic.getLine());
            try {
                this.preSplit(state2.eic, state2.context, state2.self, state2.name, block, state2.implClass, state2.scope);
                ExitableReturn exitableReturn = state2.eic.getEngine().interpret(state2.context, null, state2.self, state2.eic, state2.state, state2.implClass, state2.name, args2, block);
                this.post(state2.eic, state2.context);
                return exitableReturn;
            }
            catch (Throwable throwable) {
                this.post(state2.eic, state2.context);
                throw throwable;
            }
        }
        finally {
            ThreadContext.popBacktrace(state2.context);
        }
    }

    @Override
    public void finishSplitCall(SplitSuperState state2) {
        this.INTERPRET_METHOD((MethodSplitState)state2.state, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    protected void post(InterpreterContext ic, ThreadContext context) {
        context.popFrame();
        if (ic.popDynScope()) {
            context.popScope();
        }
    }

    protected void preSplit(InterpreterContext ic, ThreadContext context, IRubyObject self2, String name2, Block block, RubyModule implClass, DynamicScope scope) {
        context.preMethodFrameOnly(implClass, name2, self2, block);
        if (ic.pushNewDynScope()) {
            context.pushScope(scope);
        }
    }

    @Override
    public boolean needsToFindImplementer() {
        return this.needsToFindImplementer;
    }
}

