﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/wellarchitected/WellArchitected_EXPORTS.h>
#include <aws/wellarchitected/model/LensSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace WellArchitected {
namespace Model {
/**
 * <p>Output of a list lenses call.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/wellarchitected-2020-03-31/ListLensesOutput">AWS
 * API Reference</a></p>
 */
class ListLensesResult {
 public:
  AWS_WELLARCHITECTED_API ListLensesResult() = default;
  AWS_WELLARCHITECTED_API ListLensesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_WELLARCHITECTED_API ListLensesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const Aws::Vector<LensSummary>& GetLensSummaries() const { return m_lensSummaries; }
  template <typename LensSummariesT = Aws::Vector<LensSummary>>
  void SetLensSummaries(LensSummariesT&& value) {
    m_lensSummariesHasBeenSet = true;
    m_lensSummaries = std::forward<LensSummariesT>(value);
  }
  template <typename LensSummariesT = Aws::Vector<LensSummary>>
  ListLensesResult& WithLensSummaries(LensSummariesT&& value) {
    SetLensSummaries(std::forward<LensSummariesT>(value));
    return *this;
  }
  template <typename LensSummariesT = LensSummary>
  ListLensesResult& AddLensSummaries(LensSummariesT&& value) {
    m_lensSummariesHasBeenSet = true;
    m_lensSummaries.emplace_back(std::forward<LensSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListLensesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListLensesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<LensSummary> m_lensSummaries;
  bool m_lensSummariesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace WellArchitected
}  // namespace Aws
