/*
 * Decompiled with CFR 0.152.
 */
package com.github.jgonian.ipmath;

import com.github.jgonian.ipmath.AbstractIpRange;
import com.github.jgonian.ipmath.AbstractRange;
import com.github.jgonian.ipmath.Ipv4;
import com.github.jgonian.ipmath.Validate;
import java.math.BigInteger;

public final class Ipv4Range
extends AbstractIpRange<Ipv4, Ipv4Range> {
    private static final long serialVersionUID = 1L;

    protected Ipv4Range(Ipv4 start, Ipv4 end) {
        super(start, end);
    }

    @Override
    protected Ipv4Range newInstance(BigInteger start, BigInteger end) {
        return Ipv4Range.from(start).to(end);
    }

    @Override
    protected Ipv4Range newInstance(Ipv4 start, Ipv4 end) {
        return new Ipv4Range(start, end);
    }

    public static Ipv4RangeBuilder from(Ipv4 from) {
        return new Ipv4RangeBuilder(from);
    }

    public static Ipv4RangeBuilder from(BigInteger from) {
        return new Ipv4RangeBuilder(Ipv4.of(from));
    }

    public static Ipv4RangeBuilder from(Long from) {
        return new Ipv4RangeBuilder(Ipv4.of(from));
    }

    public static Ipv4RangeBuilder from(String from) {
        return new Ipv4RangeBuilder(Ipv4.parse(from));
    }

    public static Ipv4Range parse(String range) {
        int idx = range.indexOf("-");
        if (idx != -1) {
            Ipv4 start = Ipv4.parse(range.substring(0, idx));
            Ipv4 end = Ipv4.parse(range.substring(idx + 1, range.length()));
            return new Ipv4Range(start, end);
        }
        return Ipv4Range.parseCidr(range);
    }

    public static Ipv4Range parseCidr(String cidrString) {
        int idx = cidrString.indexOf("/");
        Validate.isTrue(idx != -1, "Argument [" + cidrString + "] is not a range or does not comply with the CIDR notation");
        String address = cidrString.substring(0, idx);
        String prefix = cidrString.substring(idx + 1, cidrString.length());
        return Ipv4Range.from(address).andPrefixLength(prefix);
    }

    public static Ipv4Range parseDecimalNotation(String range) {
        int idx = range.indexOf("-");
        Validate.isTrue(idx != -1, "Argument [" + range + "] does not comply with the decimal range notation");
        long start = Long.valueOf(range.substring(0, idx));
        long end = Long.valueOf(range.substring(idx + 1, range.length()));
        return Ipv4Range.from(start).to(end);
    }

    public Long size() {
        return ((Ipv4)this.end()).value() - ((Ipv4)this.start()).value() + 1L;
    }

    public static class Ipv4RangeBuilder
    extends AbstractRange.AbstractRangeBuilder<Ipv4, Ipv4Range> {
        private final Ipv4 from;

        protected Ipv4RangeBuilder(Ipv4 from) {
            this.from = from;
        }

        @Override
        public Ipv4Range to(BigInteger end) {
            return this.to(Ipv4.of(end));
        }

        @Override
        public Ipv4Range to(Long end) {
            return this.to(Ipv4.of(end));
        }

        @Override
        public Ipv4Range to(String end) {
            return this.to(Ipv4.parse(end));
        }

        public Ipv4Range andPrefixLength(String prefix) {
            return this.andPrefixLength(Integer.parseInt(prefix));
        }

        public Ipv4Range andPrefixLength(int prefixLength) {
            Validate.isTrue(this.from.lowerBoundForPrefix(prefixLength).equals(this.from), this.from + "/" + prefixLength + " is not a legal IPv4 address prefix.");
            return this.to(this.from.upperBoundForPrefix(prefixLength));
        }

        @Override
        public Ipv4Range to(Ipv4 to) {
            return new Ipv4Range(this.from, to);
        }
    }
}

