#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <Screen.h>
#include <stdio.h>
#include "GHOST_DisplayManagerZETA.h"

GHOST_DisplayManagerZETA::GHOST_DisplayManagerZETA(
	GHOST_SystemZETA* system )
	: GHOST_DisplayManager()
{
	GHOST_PRINT( "ZETA: GHOST_DisplayManagerZETA::GHOSTDisplayManagerZETA()\n" );
	
	fSystemZETA = system;
}

GHOST_DisplayManagerZETA::~GHOST_DisplayManagerZETA()
{
	fSystemZETA = NULL;
}

GHOST_TSuccess
GHOST_DisplayManagerZETA::getCurrentDisplaySetting(
	GHOST_TUns8 display,
	GHOST_DisplaySetting& setting ) const
{
	GHOST_PRINT( "ZETA: GHOST_DisplayManagerZETA::getCurrentDisplaySetting()\n" );
	
	return getDisplaySetting( display, GHOST_TInt32(0), setting );
}

GHOST_TSuccess
GHOST_DisplayManagerZETA::getDisplaySetting(
	GHOST_TUns8 display,
	GHOST_TInt32 index,
	GHOST_DisplaySetting& setting ) const
{
	GHOST_PRINT( "ZETA: GHOST_DisplayManagerZETA::getDisplaySetting()\n" );
	
	GHOST_ASSERT( display < 1, "Only single display systems are currently supported.\n" );	
	GHOST_ASSERT( index < 1, "Requested setting outside of valid range.\n" );	
	
	BScreen screen;
	
	if( screen.IsValid() != true )
		return GHOST_kFailure;
	
	display_mode mode;
	screen.GetMode( &mode );
	
#ifdef GHOST_DEBUG
		printf( "ZETA: -> x( display ): %d pixels\n", mode.timing.h_display );
		printf( "ZETA: -> y( display ): %d lines\n", mode.timing.v_display );
		printf( "ZETA: -> x( total ): %d pixels\n", mode.timing.h_total );
		printf( "ZETA: -> y( total ): %d lines\n", mode.timing.v_total );
#endif
	
	color_space cspace;	
	cspace = screen.ColorSpace();
	
	switch( cspace )
	{
		case B_CMAP8 :
		{
			GHOST_PRINT( "ZETA: -> bpp: 8\n" );
			setting.bpp = 8;
			break;
		}
		case B_RGB15 :
		case B_RGBA15 :
		{
			GHOST_PRINT( "ZETA: -> bpp: 15\n" );
			setting.bpp = 15;
			break;
		}
		case B_RGB16 :
		{
			GHOST_PRINT( "ZETA: -> bpp: 16\n" );
			setting.bpp = 16;
			break;
		}
		case B_RGB32 :
		case B_RGBA32 :
		{
			GHOST_PRINT( "ZETA: -> bpp: 32\n" );
			setting.bpp = 32;
			break;
		}
		default :
		{
			GHOST_PRINT( "ZETA: -> unrecognized/not implemented color_space! Setting 16bpp.\n" );
			setting.bpp = 16;
		}
	}
	
	float total_size = mode.timing.h_total * mode.timing.v_total;
	float refresh_rate = floor( ( ( (float)mode.timing.pixel_clock * 1000.0 ) / ( ( float )total_size ) ) );
	
#ifdef GHOST_DEBUG
	printf( "ZETA: -> refresh_rate: %luHz\n", ( long unsigned )refresh_rate );
#endif
	
	setting.xPixels = mode.timing.h_display;
	setting.yPixels = mode.timing.v_display;
	
	setting.frequency = ( GHOST_TUns32 )refresh_rate;

	return GHOST_kSuccess;	
}

GHOST_TSuccess
GHOST_DisplayManagerZETA::getNumDisplays(
	GHOST_TUns8& numDisplays ) const
{
	GHOST_PRINT( "ZETA: GHOST_DisplayManagerZETA::getNumDisplays()\n" );
	
	numDisplays = fSystemZETA->getNumDisplays();
	
	return GHOST_kSuccess;
}

GHOST_TSuccess
GHOST_DisplayManagerZETA::getNumDisplaySettings(
	GHOST_TUns8 display,
	GHOST_TInt32& numSettings) const
{
	GHOST_PRINT( "ZETA: GHOST_DisplayManagerZETA::getNumDisplaySettings()(\n" );
		
	// one display setting
	GHOST_ASSERT( display < 1, "Only single display systems are currently supported.\n" );	
	numSettings = GHOST_TInt32( 1 );
	return GHOST_kSuccess;
}

GHOST_TSuccess
GHOST_DisplayManagerZETA::setCurrentDisplaySetting(
	GHOST_TUns8 display,
	const GHOST_DisplaySetting& setting )
{
	GHOST_PRINT( "ZETA: GHOST_DisplayManagerZETA::setCurrentDisplaySetting()\n" );
	GHOST_PRINT( "ZETA: -> Not implemented!\n" );
	
	return GHOST_kSuccess;
}
