#ifndef _GHOST_SYSTEMZETA_H_
#define _GHOST_SYSTEMZETA_H_

#include <Application.h>

#include "GHOST_System.h"
#include "../GHOST_Types.h"

class GHOST_SystemZETA : public GHOST_System
{
	public:
									GHOST_SystemZETA();
		
		/*
		 * GHOST_ISystem methods for GHOST_SystemZETA
		 */
		
		GHOST_IWindow*				createWindow(
										const STR_String& title,
										GHOST_TInt32 left,
										GHOST_TInt32 top,
										GHOST_TUns32 width,
										GHOST_TUns32 height,
										GHOST_TWindowState state,
										GHOST_TDrawingContextType type,
										const bool stereoVisual );
		
		GHOST_TSuccess				getCursorPosition(
										GHOST_TInt32& x,
										GHOST_TInt32& y ) const;
		
		void						getMainDisplayDimensions(
										GHOST_TUns32& width,
										GHOST_TUns32& height ) const;
		
		GHOST_TUns8 				getNumDisplays() const;
		
		bool						processEvents(
										bool waitForEvent );
		
		GHOST_TSuccess				setCursorPosition(
										GHOST_TInt32 x,
										GHOST_TInt32 y ) const;
		/*
		 * GHOST_System methods for GHOST_SystemZETA
		 */
		
		GHOST_TSuccess				getButtons(
										GHOST_Buttons& buttons ) const;
		
		GHOST_TUns64				getMilliSeconds() const;
										
		GHOST_TSuccess				getModifierKeys(
										GHOST_ModifierKeys& keys ) const;

	protected:
		/*
		 * GHOST_System methods for GHOST_SystemZETA
		 */
		
		GHOST_TSuccess				exit();
		
		GHOST_TSuccess				init();
		
		GHOST_DisplayManager*		fDisplayManagerZETA;

	private:
		/*
		 * ZETA methods for GHOST_SystemZETA
		 */
		
		status_t					InitBApplicationObject();

		BApplication*				fBApplication;
		
		GHOST_TUns64				fStartTime;
};

#endif
