#!BPY

""" Registration info for Blender menus:
Name: 'Material_Creator'
Blender: 248
Group: 'Materials'
Tooltip: 'Create Random Materials with customizable randomness'
"""

# Renamed from Materializer
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# Copyright (C) 2006 Mariano Hidalgo
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

__author__ = "Mariano Hidalgo a.k.a. uselessdreamer"
__url__ = ("http://wiki.blender.org/index.php/Extensions:Py/Scripts/Manual/Materials/materializer")
__version__ = "1.0"

__bpydoc__ = """\
A random material generator for materials with procedural textures.
It can generate totally new materials or be used to create variations
of existing ones. It's also a fun way to explore and understand what
each material setting does.

There is an issue with the material preview that makes it impossible
to update from python, so the best way of using the script its to split
the Buttons window in two and have one of them in Material and the other
one in Texture. Then, from the script window, just hit F6 and everything
will randomize and update correctly in one keystroke.


"""

import Blender
from Blender import *
from Blender.Mathutils import Rand
import webbrowser

def event(evt, val):
	global SHOW_HELP
	if evt == Draw.QKEY:
 		Draw.Exit()             
   		return	
	if evt == Draw.RIGHTMOUSE:
 		c = Draw.PupMenu("Materializer Menu%t|Toggle Help%x01|Visit Website%x02|%l|Quit%x10")
 		if c == 1:
			SHOW_HELP = 1 - SHOW_HELP
			Draw.Redraw()
 		elif c == 2:
			webbrowser.open("http:\\uselessdreamer.byethost32.com\materializer.html")
 		elif c== 10:
			Draw.Exit()             
			return	
	elif (evt == Draw.F6KEY or evt == Draw.F5KEY) and val == 0:
		Randomize()
		Draw.Redraw()
		
def button_event(evt):
	global SHOW_HELP
	if evt == 1:
		Blender.RND_RGBCOLOR = 1 - Blender.RND_RGBCOLOR
	elif evt == 2:
		Blender.RND_RGBSPEC = 1 - Blender.RND_RGBSPEC
	elif evt == 60:
		Blender.RND_SPEC = 1 - Blender.RND_SPEC
	elif evt == 61:
		Blender.RND_HARD = 1 - Blender.RND_HARD
	elif evt == 62:
		Blender.RND_ALPHA = 1 - Blender.RND_ALPHA
	elif evt == 63:
		Blender.RND_SHADER = 1 - Blender.RND_SHADER
			
	elif evt == 3:
		Blender.RND_MIXMODE = 1 - Blender.RND_MIXMODE
	elif evt == 4:
		Blender.RND_MAPTO = 1 - Blender.RND_MAPTO
	elif evt == 5:
		Blender.RND_COLAMNT = 1 - Blender.RND_COLAMNT
	elif evt == 6:
		Blender.RND_VARAMNT = 1 - Blender.RND_VARAMNT
	elif evt == 7:
		Blender.RND_NORAMNT = 1 - Blender.RND_NORAMNT
	elif evt == 8:
		Blender.RND_DISPAMNT = 1 - Blender.RND_DISPAMNT
	
	elif evt >= 10 and evt <= 19:
		Blender.mtexs[evt-10] = 1 - Blender.mtexs[evt-10]
	elif evt >= 20 and evt <= 29:
		Blender.texs[evt-20] = 1 - Blender.texs[evt-20]
	
	elif evt == 31:
		Blender.RND_NOISESIZE = 1 - Blender.RND_NOISESIZE
	elif evt == 32:
		Blender.RND_NOISEDEPTH = 1 - Blender.RND_NOISEDEPTH
	elif evt == 33:
		Blender.RND_TEXTYPE = 1 - Blender.RND_TEXTYPE
	elif evt == 35:
		Blender.RND_NOISEBASIS = 1 - Blender.RND_NOISEBASIS
	elif evt == 36:
		Blender.RND_BASIC = 1 - Blender.RND_BASIC
	elif evt == 37:
		Blender.RND_ADVANCED = 1 - Blender.RND_ADVANCED
	elif evt == 39:
		Blender.RND_BRIGHTNESS = 1 - Blender.RND_BRIGHTNESS
	elif evt == 40:
		Blender.RND_CONTRAST = 1 - Blender.RND_CONTRAST
	
	elif evt == 100:
		Randomize()
		Window.RedrawAll()
	elif evt == 101:
		Make_Unique()
	elif evt == 102:
		Show_Presets()
	elif evt == 103:
		Undo()
	elif evt == 121:
		SHOW_HELP = 1 - SHOW_HELP
	Draw.Redraw()	

	
def INTtoFLOAT(rgba):
	r = float(rgba[0] *10 /255) /10
	g = float(rgba[1] *10 /255) /10
	b = float(rgba[2] *10 /255) /10
	a = float(rgba[3] *10 /255) /10
	return [r,g,b,a]

def gui():
	global SHOW_HELP
	theme = Window.Theme.Get()[0]
	buts = theme.get('buts')
	# Background
	r,g,b,a = INTtoFLOAT(buts.back)
	BGL.glClearColor(r+0.05,g+0.05,b+0.05,a)
	BGL.glClear(BGL.GL_COLOR_BUFFER_BIT)
	# Headers
	r,g,b,a = INTtoFLOAT(buts.header)	
	draw_square(10,405,160,16,r-0.1,g-0.1,b-0.1,a)
	# Panels 
	r,g,b,a = INTtoFLOAT(buts.panel)
	draw_square(10,5,160,400,r,g,b,a+0.1)
	# Text Hilite
	r,g,b,a = INTtoFLOAT(buts.text_hi)	
	BGL.glColor3f(r,g,b)
	BGL.glRasterPos2i(15,409)
	Draw.Text("Materializer 1.0","small")
	# Text
	r,g,b,a = INTtoFLOAT(buts.text)	
	BGL.glColor3f(r,g,b)
	BGL.glRasterPos2i(15,391)
	Draw.Text("Material","small")
	BGL.glRasterPos2i(15,303)
	Draw.Text("Texture Mappings","small")
	BGL.glRasterPos2i(15,200)
	Draw.Text("Texture Procedurals","small")
	
	staY = 0
	
	# Material Toggles
	Draw.Toggle("RGB Diff", 1, 20,staY + 370,65,16, Blender.RND_RGBCOLOR, "This will randomize the difusse color of the material.")		
	Draw.Toggle("RGB Spec", 2, 95,staY + 370,65,16, Blender.RND_RGBSPEC, "This will randomize the specular color of the material.")		
	Draw.Toggle("Specular", 60, 20,staY + 350,65,16, Blender.RND_SPEC, "This will randomize the intensity of the specular reflection on the material's surface.")		
	Draw.Toggle("Hardness", 61, 95,staY + 350,65,16, Blender.RND_HARD, "This will randomize how hard is the specular reflection.")				
	Draw.Toggle("Alpha", 62, 20,staY + 330,65,16, Blender.RND_ALPHA, "This will randomize the tranparency (alpha value) of the material, it will mix with texture's mapping to alpha.")		
	Draw.Toggle("Shader", 63, 95,staY + 330,65,16, Blender.RND_SHADER, "This will make a random choice to select between the available difusse and specular shaders.")			
	
	# Texture Mapping Toggles
	Draw.Toggle("Mix Mode", 3, 20,staY + 280,65,16, Blender.RND_MIXMODE, "This will make a random choice on how to mix the texture with the rest of the textures.")		
	Draw.Toggle("Map To", 4, 95,staY + 280,65,16, Blender.RND_MAPTO, "This will randomly make the texture affect diffent values, like alpha, displacement or diffuse color.")		
	Draw.Toggle("COL amount", 5, 20,staY + 260,65,16, Blender.RND_COLAMNT, "This checked will result in a random amount of color.")		
	Draw.Toggle("VAR amount", 6, 95,staY + 260,65,16, Blender.RND_VARAMNT, "This checked will result in a random amount of alpha or specular.")		
	Draw.Toggle("NOR amount", 7, 20,staY + 240,65,16, Blender.RND_NORAMNT, "This checked will result in a random amount of normal (bump).")		
	Draw.Toggle("DISP amount", 8, 95,staY + 240,65,16, Blender.RND_DISPAMNT, "This checked will result in a random amount of displacement.")		
	
	staY -= 20
	# Texture Procedurals Toggles
	Draw.Toggle("Noise Size", 31, 20,staY + 180,65,16, Blender.RND_NOISESIZE, "This will make a random choice of the type of texture used.")		
	Draw.Toggle("Noise Deep", 32, 95,staY + 180,65,16, Blender.RND_NOISEDEPTH, "Enable random Texture Noise Depth.")		
	Draw.Toggle("Tex Type", 33, 20,staY + 200,65,16, Blender.RND_TEXTYPE, "Enable random Texture Type.")		
	Draw.Toggle("Noise Basis", 35, 20,staY + 160,65,16, Blender.RND_NOISEBASIS, "Enable random Texture Noise basis.")		
	Draw.Toggle("Basic Tweaks", 36, 20,staY + 140,65,16, Blender.RND_BASIC, "Enable random Texture Basic tweaks.")		
	Draw.Toggle("Deeper Tweaks", 37, 95,staY + 140,65,16, Blender.RND_ADVANCED, "Enable random Texture Advanced tweaks.")		
	Draw.Toggle("Brightness", 39, 20,staY + 100,65,16, Blender.RND_BRIGHTNESS, "Enable random Texture Brightness (in the texture's colorband).")		
	Draw.Toggle("Contrast", 40, 95,staY + 100,65,16, Blender.RND_CONTRAST, "Enable random Texture Contrast (in the texture's colorband).")		
	
	
	for i in range(10):
		Draw.Toggle("", i+10,20 +(i*14),staY + 240,14,14, Blender.mtexs[i], "Uncheck to avoid mapping's changes for this particular texture slot.")		
	
	for i in range(10):
		Draw.Toggle("", i+20,20 +(i*14),staY + 80,14,14, Blender.texs[i], "Uncheck to avoid procedural's changes for this particular texture slot.")		
	
	
	Draw.Toggle("?", 121,146,403, 15,15,SHOW_HELP , "Show Help")			
	Draw.PushButton("GO!", 100, 120,20, 40,32 , "Please use F6 instead, with two button windows. if you dont you ll have to click in the Material button to update the preview.")
	Draw.PushButton("Make Unique", 101, 20,16, 80,16 , "Make the current Material single User, so you can keep randomizing without altering the current state.")
	Draw.PushButton("Presets", 102, 20,36, 80,16 , "Some usefull Radomize presets")
	#Draw.PushButton("Undo", 103, 20,36, 80,16 , "Make the current Material single User")
	if SHOW_HELP >= 1:		
		text= "Have two Buttons windows displayed, one in Material and the other one in Texture.Select an object with a materal and hit F6 (preferred, will auto update the preview) or the GO button."	
		paragraph([r,g,b],text,300,"small",186,410,14,1)
		text= "These toggles control the randomization of general material's settings, including color, alpha and shaders."	
		paragraph([r,g,b],text,300,"small",186,348,14,1)
		text= "This section acts on texture's mapping (how the texture is applied). This may radically change the look of the material and also its colors, even thou the procedurals remain the same."
		paragraph([r,g,b],text,300,"small",186,290,14,1)
		text= "This row of 10 toggles allows to freeze randomization of texture slots. No setting will be touched in the unchecked ones."
		paragraph([r,g,b],text,300,"small",186,227,14,1)		
		text= "This buttons will radically change the texture's procedural settings, altering their shape and look.|Again, the row of small toggles below allows to frezee randomization on unchecked slots"
		paragraph([r,g,b],text,300,"small",186,174,14,1)
		text= "Brightness and Contrast are the only colorband settings that can be accesed from Python. This may change in future versions."
		paragraph([r,g,b],text,300,"small",186,94,14,1)
		text= "Use the Presets button to quickly turn on and off certain toggles and the Make Unique button to create a single user version of the material once you are satisfied with the result."
		paragraph([r,g,b],text,300,"small",186,44,14,1)

def draw_square(x,y,w,h,r,g,b,a):
	BGL.glEnable(BGL.GL_BLEND)
	BGL.glBlendFunc(BGL.GL_SRC_ALPHA, BGL.GL_ONE_MINUS_SRC_ALPHA)
	BGL.glColor4f(r,g,b,a)
	BGL.glBegin(BGL.GL_POLYGON)
	BGL.glVertex2i(x, y)
	BGL.glVertex2i(x, y + h)
	BGL.glVertex2i(x + w, y + h)
	BGL.glVertex2i(x + w, y)
	BGL.glEnd()	
	BGL.glDisable( BGL.GL_BLEND )
	
def paragraph(color,text,width,size,staX,staY,spacing,square):	
	lines = []
	i = 0
	while i <= 1000:		
		if i >= len(text):
			lines.append(text)
			break
		i += 1	
		length = Draw.GetStringWidth(text[:i],size)		
		if text[i:i+1] == "|":			
			lines.append(text[:i].lstrip(" ").rstrip("|"))
			if 	text[i+1:i+2] == "|":	
				lines.append("")	
			text = text[i:].lstrip("|")						
		elif length > width:			
			c = 0
			while 1:
				if text[i-c-1:i-c] == " ":
					lines.append(text[:i-c].lstrip(" "))
					text = text[i-c:]
					break			
				else:
					c += 1
			i = 0		
	h = len(lines)*spacing
	if square:
		draw_square(staX-12,staY - h+5,width+20,h+10,1,0.6,0,1)
		draw_arrow(staX,staY)
	BGL.glColor3f(color[0],color[1],color[2])
	c = 0
	for l in lines:
		BGL.glRasterPos2i(staX,staY - (c*spacing))
		Draw.Text(l,"small")
		c+= 1		

def draw_arrow(x,y):
	BGL.glPointSize(8)
	BGL.glBegin(BGL.GL_POINTS)
	BGL.glVertex2i(x, y)
	BGL.glVertex2i(x-10, y)
	BGL.glVertex2i(x-20, y)
	BGL.glEnd()	
		
def Randomize():
	ob = Object.GetSelected()
	if not ob:
		Draw.PupMenu("No object selected.%t|Please select an object with a material on it")
		return
	me = ob[0].getData()
	mats = me.getMaterials()
	if not mats:
		Draw.PupMenu("This object has no materials.%t|Please set one on it and try again")
		return
	mat = mats[0]
	# Material RGB color and RGB specular
	if Blender.RND_RGBCOLOR:
		mat.setRGBCol(Rand(0.0,1.0),Rand(0.0,1.0),Rand(0.0,1.0))
	if Blender.RND_RGBSPEC:
		mat.setSpecCol(Rand(0.0,1.0),Rand(0.0,1.0),Rand(0.0,1.0))
	# Material Specular and Hardness intensity
	if Blender.RND_SPEC:
		mat.spec = Rand(0.0,2.0)
	if Blender.RND_HARD:
		mat.hard = int(Rand(0,255))
	# Material Alpha
	if Blender.RND_ALPHA:
		mat.alpha = Rand(0.0,1.0)
	# Material Shader
	if Blender.RND_SHADER:		
		mat.diffuseShader = int(Rand(0,4)) 
		if mat.diffuseShader == Material.Shaders.DIFFUSE_MINNAERT:
			mat.diffuseDarkness = Rand(0.0,2.0)
		elif mat.diffuseShader == Material.Shaders.DIFFUSE_TOON:
			mat.diffuseSize = Rand(0.0,3.14)
			mat.diffuseSmooth = Rand(0.0,1.0)
		elif mat.diffuseShader == Material.Shaders.DIFFUSE_ORENNAYAR:
			mat.roughness = Rand(0.0,3.14)		
		mat.specShader = int(Rand(0,5))	
		if mat.specShader == Material.Shaders.SPEC_TOON:
			mat.specSize = Rand(0.0,1.53)
			mat.specSmooth = Rand(0.0,1.0)
		elif mat.specShader == Material.Shaders.SPEC_WARDISO:	
			mat.rms = Rand(0.0,0.4)
	texs = mat.getTextures()
	count = 0
	for t in texs:
		if t:
			if Blender.mtexs[count]:
				# Mix Modes for mtex
				if Blender.RND_MIXMODE:
					t.blendmode = int(Rand(0,8))					
				# Tree MapTo random values
				if Blender.RND_MAPTO:	
					try:				
						t.mapto = Texture.MapTo.values()[int(Rand(0,14))]
						t.mapto += Texture.MapTo.values()[int(Rand(0,14))]
						t.mapto += Texture.MapTo.values()[int(Rand(0,14))]					
					except:
						t.mapto = int(Rand(0,14))					
				# Amount of COL, NOR, VAR, DISP
				if Blender.RND_COLAMNT:
					t.colfac = Rand(0.0,1.0)
				if Blender.RND_VARAMNT:
					t.varfac = Rand(0.0,1.0)
				if Blender.RND_NORAMNT:
					t.norfac = Rand(0.0,5.0)
				if Blender.RND_DISPAMNT:
					t.dispfac = Rand(0.0,1.0)
			
			tex = t.tex
			if Blender.texs[count]:				
				# Noise Size and Depth
				if Blender.RND_NOISESIZE:
					tex.noiseSize = Rand(0.0,4.0)
				if Blender.RND_NOISEDEPTH:
					tex.noiseDepth = int(Rand(0,6))
	
				# Brightness and Contrast
				if Blender.RND_BRIGHTNESS:
					tex.brightness = Rand(0.5,2.0)
				if Blender.RND_CONTRAST:
					tex.contrast = Rand(0.5,2.0)
				
				# Noise Basis				
				if Blender.RND_NOISEBASIS:					
					try:
						tex.noiseBasis = int(Rand(0,14))
					except:
						pass
					try:	
						tex.noiseBasis2 = int(Rand(0,14))
					except:
						pass
	
				# Texture Type
				if Blender.RND_TEXTYPE:
					texTypes = ['Clouds', 'Wood', 'Marble', 'Magic', 'Blend', 'Stucci', 'Noise', 'Musgrave', 'Voronoi' , 'DistNoise']
					chance = int(Rand(0,len(texTypes)-1))
					tex.setType(texTypes[chance])				
				if Blender.RND_BASIC:
					if tex.getType() == "Voronoi":
						tex.distMetric = int(Rand(0,7))
					tex.turbulence = Rand(0.0,40.0)
					tex.distAmnt = Rand(0.0,10.0)
				
				# Advanced Tweaks
				if Blender.RND_ADVANCED:
					if tex.getType() == "Musgrave":
						tex.lacunarity = Rand(0.0,6.0)
						tex.hFracDim = Rand(0.0,2.0)
						tex.octs = Rand(0.0,8.0)
					if tex.getType() == "Voronoi":
						tex.weight1 = Rand(-2.0,2.0)
						tex.weight2 = Rand(-2.0,2.0)
						tex.weight3 = Rand(-2.0,2.0)
						tex.weight4 = Rand(-2.0,2.0)						
					if tex.getType() == "Musgrave" or tex.getType() == "Voronoi":	
						tex.iScale = Rand(0.0,10.0)
					# Soft or Hard for clouds and others
					chance = int(Rand(0,2))
					if chance:
						tex.noiseType = "hard"
					else:
						tex.noiseType = "soft"		
					if tex.getType() == "Blend":
						val = ["BLN_LIN","BLN_QUAD","BLN_EASE","BLN_DIAG","BLN_SPHERE","BLN_HALO"]
						tex.stype = Texture.STypes[val[int(Rand(0,6))]]
					if tex.getType() == "Marble":
						val = ["MBL_SOFT","MBL_SHARP","MBL_SHARPER"]
						tex.stype = Texture.STypes[val[int(Rand(0,3))]]
				
	
		count += 1	

def Make_Unique():
	oldOb = Object.GetSelected()[0]
	Object.Duplicate(mesh=1,material=1,texture=1)
	scn = Scene.GetCurrent()
	ob = Object.GetSelected()[0]
	me = ob.getData()
	mat = me.getMaterials()[0]
	c = Draw.PupStrInput("Name:", "", 40)
	if c:
		mat.setName(c)
		texs = mat.getTextures()	
		if texs:
			for mtex in texs:
				if mtex:
					name = mtex.tex.name
					type = mtex.tex.getType()
					mtex.tex.setName(c[:6] + "." + type)					
		Draw.PupMenu("All done%t|New Material " + c + " and its Textures now Single User.")	
	scn.unlink(ob)
	scn.update()
	oldOb.sel = 1
	Blender.Redraw()
	
def Show_Presets():
	menu = "Randomize Presets%t"
	rows = []
	rows.append("Radical Changes%x01")
	rows.append("Strong Changes%x02")
	rows.append("Variations%x03")		
	rows.append("Slight Variations%x04")		
	rows.append("Tiny Variations%x05")
	rows.append("Just Color%x06")
	rows.append("%l")
	rows.append("Toggle All%x10")
	rows.append("Toggle Color%x11")
	rows.append("%l")
	rows.append("Toggle All Texture's Procedurals%x12")
	rows.append("Toggle All Texture's Mappings%x13")
	rows.append("%l")
	rows.append("Toggle Brightness and Contrast%x14")
	for r in rows:
		menu += "|" + r
	c = Draw.PupMenu(menu)
	if c == 1:
		Turn_All(1)
	elif c == 2:
		Turn_All(1)
		Blender.RND_SHADER = 0		
		Blender.RND_ADVANCED = 0
	elif c == 3:
		Turn_All(1)
		Blender.RND_SHADER = 0
		Blender.RND_ALPHA = 0	
		Blender.RND_TEXTYPE = 0
		Blender.RND_ADVANCED = 0
		Blender.RND_MAPTO = 0
	elif c == 4:
		Turn_All(1)
		Blender.RND_RGBCOLOR = 0
		Blender.RND_RGBSPEC = 0
		Blender.RND_SHADER = 0
		Blender.RND_ALPHA = 0	
		Blender.RND_TEXTYPE = 0
		Blender.RND_ADVANCED = 0
		Blender.RND_MIXMODE = 0
		Blender.RND_MAPTO = 0
		Blender.RND_DISPAMNT = 0		
		Blender.RND_NORAMNT = 0
		Blender.RND_BRIGHTNESS = 0
		Blender.RND_CONTRAST = 0		
	elif c == 5:
		Turn_All(1)
		Blender.RND_SHADER = 0
		Blender.RND_ALPHA = 0	
		Blender.RND_TEXTYPE = 0
		Blender.RND_ADVANCED = 0
		Blender.RND_MIXMODE = 0
		Blender.RND_MAPTO = 0
		Blender.RND_BRIGHTNESS = 0
		Blender.RND_COLAMNT = 0		
		Blender.RND_VARAMNT = 0		
		Blender.RND_DISPAMNT = 0		
		Blender.RND_NORAMNT = 0
		Blender.RND_CONTRAST = 0
		Blender.RND_RGBCOLOR = 0
		Blender.RND_RGBSPEC = 0
		Blender.RND_SPEC = 0
		Blender.RND_HARD = 0
		Blender.RND_BASIC = 0
		Blender.RND_NOISEBASIS = 0
	elif c == 6:
		Turn_All(0)
		Blender.RND_RGBCOLOR = 1
		Blender.RND_RGBSPEC = 1		
	elif c == 10:
		if Blender.RND_RGBCOLOR == 1:
			tog = 0
		else:
			tog = 1			
		Turn_All(tog)
	elif c == 11:
		if Blender.RND_RGBCOLOR == 1:
			tog = 0
		else:
			tog = 1				
		Blender.RND_RGBCOLOR = tog
		Blender.RND_RGBSPEC = tog
		Blender.RND_MIXMODE = tog
		Blender.RND_MAPTO = tog
		Blender.RND_COLAMNT = tog
	elif c == 12:
		if Blender.mtexs[0] == 1:
			tog = 0
		else:
			tog = 1
		for i in range(10):
			Blender.mtexs[i] = tog
	elif c == 13:
		if Blender.texs[0] == 1:
			tog = 0
		else:
			tog = 1
		for i in range(10):
			Blender.texs[i] = tog
	elif c == 14:
		if Blender.RND_BRIGHTNESS == 1:
			tog = 0
		else:
			tog = 1
		Blender.RND_BRIGHTNESS = tog
		Blender.RND_CONTRAST = tog

def Turn_All(on):	
	Blender.RND_RGBCOLOR = on
	Blender.RND_RGBSPEC = on
	Blender.RND_SPEC = on
	Blender.RND_HARD = on
	Blender.RND_ALPHA = on
	Blender.RND_SHADER = on
	
	Blender.RND_MIXMODE = on
	Blender.RND_MAPTO = on
	Blender.RND_COLAMNT = on
	Blender.RND_VARAMNT = on
	Blender.RND_NORAMNT = on
	Blender.RND_DISPAMNT = on

	Blender.RND_TEXTYPE = on
	Blender.RND_NOISESIZE = on
	Blender.RND_NOISEDEPTH = on
	Blender.RND_NOISEBASIS = on
	Blender.RND_BASIC = on
	Blender.RND_ADVANCED = on
	Blender.RND_BRIGHTNESS = on
	Blender.RND_CONTRAST = on

Blender.RND_RGBCOLOR = 1
Blender.RND_RGBSPEC = 1
Blender.RND_SPEC = 1
Blender.RND_HARD = 1
Blender.RND_ALPHA = 1
Blender.RND_SHADER = 1

Blender.RND_MIXMODE = 1
Blender.RND_MAPTO = 1
Blender.RND_COLAMNT = 1
Blender.RND_VARAMNT = 1
Blender.RND_NORAMNT = 1
Blender.RND_DISPAMNT = 1

Blender.mtexs = []
for i in range(10) : Blender.mtexs.append(1)
Blender.texs = []
for i in range(10) : Blender.texs.append(1)

Blender.RND_TEXTYPE = 1
Blender.RND_NOISESIZE = 1
Blender.RND_NOISEDEPTH = 1
Blender.RND_NOISEBASIS = 1
Blender.RND_BASIC = 1
Blender.RND_ADVANCED = 1
Blender.RND_BRIGHTNESS = 1
Blender.RND_CONTRAST = 1
SHOW_HELP = 0

Draw.Register(gui, event, button_event)	

