/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.config;

import de.nm.file.CsvReader;
import de.nm.string.XString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public class ConfigExecute {
    private static String osname = System.getProperty("os.name");
    private final HashMap<String, ArrayList<Entry>> map = new HashMap();

    public void addEntry(Entry entry) {
        this.put(entry);
    }

    public List<Entry> get(String name) {
        return this.map.get(name);
    }

    public void put(Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry is null!");
        }
        ArrayList<Entry> liste = this.map.get(entry.getName());
        if (liste == null) {
            liste = new ArrayList();
            this.map.put(entry.getName(), liste);
        }
        liste.add(entry);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(255);
        for (String key : this.map.keySet()) {
            ArrayList<Entry> liste = this.map.get(key);
            for (Entry entry : liste) {
                buf.append(entry);
                buf.append("\n");
            }
            buf.append("-------------\n");
        }
        return buf.toString();
    }

    public static class Entry {
        private boolean deleteScript = true;
        private final Environment env = new Environment();
        private String name;
        private String osname;
        private String[] params;
        private String scriptext = null;
        private String[] shellcmd = null;
        private final StringBuilder text = new StringBuilder(512);

        public void addEnv(Environment.Variable variable) {
            this.env.addVariable(variable);
        }

        public void addText(String txt) {
            if (txt != null && txt.trim().length() > 0) {
                this.text.append(txt.trim()).append("\n");
            }
        }

        public Environment getEnv() {
            return this.env;
        }

        public String getName() {
            return this.name;
        }

        public String getOsname() {
            return this.osname;
        }

        public String[] getParams() {
            return this.params;
        }

        public String getScriptext() {
            if (this.scriptext == null) {
                if (osname.matches("[Ww]indows.*")) {
                    return ".cmd";
                }
                if (osname.matches("[Ll]inux.*")) {
                    return "";
                }
                return "";
            }
            return this.scriptext;
        }

        public String[] getShellcmd() {
            return this.shellcmd;
        }

        public String getText() {
            return this.text.toString();
        }

        public boolean isDeleteScript() {
            return this.deleteScript;
        }

        public boolean isScript() {
            return this.text.length() > 0;
        }

        public void setDeleteScript(boolean deleteScript) {
            this.deleteScript = deleteScript;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setOsname(String osname) {
            this.osname = osname;
        }

        public void setParams(String sparam) {
            CsvReader csv = new CsvReader(sparam, ' ', '\'', -1);
            try {
                this.params = CsvReader.removeEmptyEntries((String[])csv.next());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.params = null;
            }
            if (this.params == null || this.params.length == 0) {
                StringBuilder message = new StringBuilder(255);
                message.append("At least, one parameter must be set!");
                if (this.name != null) {
                    message.append(" name=").append(this.name);
                }
                if (this.osname != null) {
                    message.append(" osname=").append(this.osname);
                }
                throw new BuildException(message.toString());
            }
        }

        public void setScriptext(String scriptext) {
            this.scriptext = scriptext;
        }

        public void setShellcmd(String sshellcmd) {
            CsvReader csv = new CsvReader(sshellcmd, ' ', '\'', -1);
            try {
                this.shellcmd = CsvReader.removeEmptyEntries((String[])csv.next());
            }
            catch (IOException e) {
                e.printStackTrace();
                this.shellcmd = null;
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(255);
            buf.append(XString.concat((String[])new String[]{this.name, " ", this.osname, " -> "}));
            buf.append(this.params == null ? "" : XString.append((char)',', (String[])this.params));
            Vector envv = this.env.getVariablesVector();
            if (envv.size() > 0) {
                buf.append("\nEnvirionment:\n");
                for (Environment.Variable v : envv) {
                    buf.append(v.getContent());
                    buf.append(" ");
                }
            }
            if (this.text.length() > 0) {
                buf.append("\nText:\n");
                buf.append((CharSequence)this.text);
            }
            return buf.toString();
        }
    }
}

