/*
 * Decompiled with CFR 0.152.
 */
package de.nm.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Grep {
    private static Pattern linePattern = Pattern.compile(".*\r?\n");
    private final Pattern pattern;
    private boolean verbose = false;

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.err.println("Usage: java de.nm.file.Grep pattern file...");
            System.exit(1);
        }
        Grep g = new Grep(args[0]);
        g.setVerbose(true);
        System.out.println("found " + g.process(args[1], "UTF-8") + " lines");
    }

    public Grep(String regex) throws PatternSyntaxException {
        this.pattern = Pattern.compile(regex);
    }

    public List<String> getLines(CharBuffer charbuffer) {
        ArrayList<String> foundlines = new ArrayList<String>();
        int found = 0;
        Matcher lineMatcher = linePattern.matcher(charbuffer);
        Matcher matcher = null;
        int lines = 0;
        while (lineMatcher.find()) {
            ++lines;
            String line = lineMatcher.group();
            if (matcher == null) {
                matcher = this.pattern.matcher(line);
            } else {
                matcher.reset(line);
            }
            if (matcher.find()) {
                ++found;
                foundlines.add(line.toString());
                if (this.verbose) {
                    System.out.print(String.valueOf(lines) + ":" + line);
                }
            }
            if (lineMatcher.end() == charbuffer.limit()) break;
        }
        return foundlines;
    }

    public List<String> getLines(File file, String encoding) throws IOException {
        FileInputStream in = new FileInputStream(file);
        FileChannel fc = in.getChannel();
        int size = (int)fc.size();
        MappedByteBuffer bytebuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        Charset charset = Charset.forName(encoding);
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer charbuffer = decoder.decode(bytebuffer);
        List<String> foundlines = this.getLines(charbuffer);
        fc.close();
        return foundlines;
    }

    public int process(CharBuffer charbuffer) {
        int found = 0;
        Matcher lineMatcher = linePattern.matcher(charbuffer);
        Matcher matcher = null;
        int lines = 0;
        while (lineMatcher.find()) {
            ++lines;
            String line = lineMatcher.group();
            if (matcher == null) {
                matcher = this.pattern.matcher(line);
            } else {
                matcher.reset(line);
            }
            if (matcher.find()) {
                ++found;
                if (this.verbose) {
                    System.out.print(String.valueOf(lines) + ":" + line);
                }
            }
            if (lineMatcher.end() == charbuffer.limit()) break;
        }
        return found;
    }

    public int process(File file, String encoding) throws IOException {
        FileInputStream in = new FileInputStream(file);
        FileChannel fc = in.getChannel();
        int size = (int)fc.size();
        MappedByteBuffer bytebuffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        Charset charset = Charset.forName(encoding);
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer charbuffer = decoder.decode(bytebuffer);
        int found = this.process(charbuffer);
        fc.close();
        return found;
    }

    public int process(String file, String encoding) throws IOException {
        return this.process(new File(file), encoding);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

