#!/usr/bin/perl

use warnings;
use strict;
use Test::Inter;
$::ti = new Test::Inter $0;
require "tests.pl";

our $dmt = new Date::Manip::TZ;
our $obj = $dmt->base();
$dmt->config("forcedate","now,America/New_York");

sub test {
   my(@test)=@_;
   if ($test[0] eq "config") {
      $dmt->config("firstday",$test[2]);
      $dmt->config("week1ofyear",$test[1]);
      return 0;
   }
   my @ret = $obj->week1_day1(@test);
   return @ret;
}

my $tests="

#####################

config jan1 1 => 0

2000 => [ 1999 12 27 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2002 12 30 ]

2004 => [ 2003 12 29 ]

2006 => [ 2005 12 26 ]

2010 => [ 2009 12 28 ]

#####################

config jan1 2 => 0

2000 => [ 1999 12 28 ]

2001 => [ 2000 12 26 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2003 12 30 ]

2006 => [ 2005 12 27 ]

2010 => [ 2009 12 29 ]

#####################

config jan1 3 => 0

2000 => [ 1999 12 29 ]

2001 => [ 2000 12 27 ]

2002 => [ 2001 12 26 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2005 12 28 ]

2010 => [ 2009 12 30 ]

#####################

config jan1 4 => 0

2000 => [ 1999 12 30 ]

2001 => [ 2000 12 28 ]

2002 => [ 2001 12 27 ]

2003 => [ 2002 12 26 ]

2004 => [ 2004 1 1 ]

2006 => [ 2005 12 29 ]

2010 => [ 2009 12 31 ]

#####################

config jan1 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2000 12 29 ]

2002 => [ 2001 12 28 ]

2003 => [ 2002 12 27 ]

2004 => [ 2003 12 26 ]

2006 => [ 2005 12 30 ]

2010 => [ 2010 1 1 ]

#####################

config jan1 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2000 12 30 ]

2002 => [ 2001 12 29 ]

2003 => [ 2002 12 28 ]

2004 => [ 2003 12 27 ]

2006 => [ 2005 12 31 ]

2010 => [ 2009 12 26 ]

#####################

config jan1 7 => 0

2000 => [ 1999 12 26 ]

2001 => [ 2000 12 31 ]

2002 => [ 2001 12 30 ]

2003 => [ 2002 12 29 ]

2004 => [ 2003 12 28 ]

2006 => [ 2006 1 1 ]

2010 => [ 2009 12 27 ]

#####################

config jan2 1 => 0

2000 => [ 1999 12 27 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2002 12 30 ]

2004 => [ 2003 12 29 ]

2006 => [ 2006 1 2 ]

2010 => [ 2009 12 28 ]

#####################

config jan2 2 => 0

2000 => [ 1999 12 28 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2003 12 30 ]

2006 => [ 2005 12 27 ]

2010 => [ 2009 12 29 ]

#####################

config jan2 3 => 0

2000 => [ 1999 12 29 ]

2001 => [ 2000 12 27 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2005 12 28 ]

2010 => [ 2009 12 30 ]

#####################

config jan2 4 => 0

2000 => [ 1999 12 30 ]

2001 => [ 2000 12 28 ]

2002 => [ 2001 12 27 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2005 12 29 ]

2010 => [ 2009 12 31 ]

#####################

config jan2 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2000 12 29 ]

2002 => [ 2001 12 28 ]

2003 => [ 2002 12 27 ]

2004 => [ 2004 1 2 ]

2006 => [ 2005 12 30 ]

2010 => [ 2010 1 1 ]

#####################

config jan2 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2000 12 30 ]

2002 => [ 2001 12 29 ]

2003 => [ 2002 12 28 ]

2004 => [ 2003 12 27 ]

2006 => [ 2005 12 31 ]

2010 => [ 2010 1 2 ]

#####################

config jan2 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2000 12 31 ]

2002 => [ 2001 12 30 ]

2003 => [ 2002 12 29 ]

2004 => [ 2003 12 28 ]

2006 => [ 2006 1 1 ]

2010 => [ 2009 12 27 ]

#####################

config jan3 1 => 0

2000 => [ 2000 1 3 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2002 12 30 ]

2004 => [ 2003 12 29 ]

2006 => [ 2006 1 2 ]

2010 => [ 2009 12 28 ]

#####################

config jan3 2 => 0

2000 => [ 1999 12 28 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2003 12 30 ]

2006 => [ 2006 1 3 ]

2010 => [ 2009 12 29 ]

#####################

config jan3 3 => 0

2000 => [ 1999 12 29 ]

2001 => [ 2001 1 3 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2005 12 28 ]

2010 => [ 2009 12 30 ]

#####################

config jan3 4 => 0

2000 => [ 1999 12 30 ]

2001 => [ 2000 12 28 ]

2002 => [ 2002 1 3 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2005 12 29 ]

2010 => [ 2009 12 31 ]

#####################

config jan3 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2000 12 29 ]

2002 => [ 2001 12 28 ]

2003 => [ 2003 1 3 ]

2004 => [ 2004 1 2 ]

2006 => [ 2005 12 30 ]

2010 => [ 2010 1 1 ]

#####################

config jan3 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2000 12 30 ]

2002 => [ 2001 12 29 ]

2003 => [ 2002 12 28 ]

2004 => [ 2004 1 3 ]

2006 => [ 2005 12 31 ]

2010 => [ 2010 1 2 ]

#####################

config jan3 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2000 12 31 ]

2002 => [ 2001 12 30 ]

2003 => [ 2002 12 29 ]

2004 => [ 2003 12 28 ]

2006 => [ 2006 1 1 ]

2010 => [ 2010 1 3 ]

#####################

config jan4 1 => 0

2000 => [ 2000 1 3 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2002 12 30 ]

2004 => [ 2003 12 29 ]

2006 => [ 2006 1 2 ]

2010 => [ 2010 1 4 ]

#####################

config jan4 2 => 0

2000 => [ 2000 1 4 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2003 12 30 ]

2006 => [ 2006 1 3 ]

2010 => [ 2009 12 29 ]

#####################

config jan4 3 => 0

2000 => [ 1999 12 29 ]

2001 => [ 2001 1 3 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2006 1 4 ]

2010 => [ 2009 12 30 ]

#####################

config jan4 4 => 0

2000 => [ 1999 12 30 ]

2001 => [ 2001 1 4 ]

2002 => [ 2002 1 3 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2005 12 29 ]

2010 => [ 2009 12 31 ]

#####################

config jan4 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2000 12 29 ]

2002 => [ 2002 1 4 ]

2003 => [ 2003 1 3 ]

2004 => [ 2004 1 2 ]

2006 => [ 2005 12 30 ]

2010 => [ 2010 1 1 ]

#####################

config jan4 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2000 12 30 ]

2002 => [ 2001 12 29 ]

2003 => [ 2003 1 4 ]

2004 => [ 2004 1 3 ]

2006 => [ 2005 12 31 ]

2010 => [ 2010 1 2 ]

#####################

config jan4 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2000 12 31 ]

2002 => [ 2001 12 30 ]

2003 => [ 2002 12 29 ]

2004 => [ 2004 1 4 ]

2006 => [ 2006 1 1 ]

2010 => [ 2010 1 3 ]

#####################

config jan5 1 => 0

2000 => [ 2000 1 3 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2002 12 30 ]

2004 => [ 2004 1 5 ]

2006 => [ 2006 1 2 ]

2010 => [ 2010 1 4 ]

#####################

config jan5 2 => 0

2000 => [ 2000 1 4 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2003 12 30 ]

2006 => [ 2006 1 3 ]

2010 => [ 2010 1 5 ]

#####################

config jan5 3 => 0

2000 => [ 2000 1 5 ]

2001 => [ 2001 1 3 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2006 1 4 ]

2010 => [ 2009 12 30 ]

#####################

config jan5 4 => 0

2000 => [ 1999 12 30 ]

2001 => [ 2001 1 4 ]

2002 => [ 2002 1 3 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2006 1 5 ]

2010 => [ 2009 12 31 ]

#####################

config jan5 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2001 1 5 ]

2002 => [ 2002 1 4 ]

2003 => [ 2003 1 3 ]

2004 => [ 2004 1 2 ]

2006 => [ 2005 12 30 ]

2010 => [ 2010 1 1 ]

#####################

config jan5 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2000 12 30 ]

2002 => [ 2002 1 5 ]

2003 => [ 2003 1 4 ]

2004 => [ 2004 1 3 ]

2006 => [ 2005 12 31 ]

2010 => [ 2010 1 2 ]

#####################

config jan5 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2000 12 31 ]

2002 => [ 2001 12 30 ]

2003 => [ 2003 1 5 ]

2004 => [ 2004 1 4 ]

2006 => [ 2006 1 1 ]

2010 => [ 2010 1 3 ]

#####################

config jan6 1 => 0

2000 => [ 2000 1 3 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2003 1 6 ]

2004 => [ 2004 1 5 ]

2006 => [ 2006 1 2 ]

2010 => [ 2010 1 4 ]

#####################

config jan6 2 => 0

2000 => [ 2000 1 4 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2004 1 6 ]

2006 => [ 2006 1 3 ]

2010 => [ 2010 1 5 ]

#####################

config jan6 3 => 0

2000 => [ 2000 1 5 ]

2001 => [ 2001 1 3 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2006 1 4 ]

2010 => [ 2010 1 6 ]

#####################

config jan6 4 => 0

2000 => [ 2000 1 6 ]

2001 => [ 2001 1 4 ]

2002 => [ 2002 1 3 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2006 1 5 ]

2010 => [ 2009 12 31 ]

#####################

config jan6 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2001 1 5 ]

2002 => [ 2002 1 4 ]

2003 => [ 2003 1 3 ]

2004 => [ 2004 1 2 ]

2006 => [ 2006 1 6 ]

2010 => [ 2010 1 1 ]

#####################

config jan6 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2001 1 6 ]

2002 => [ 2002 1 5 ]

2003 => [ 2003 1 4 ]

2004 => [ 2004 1 3 ]

2006 => [ 2005 12 31 ]

2010 => [ 2010 1 2 ]

#####################

config jan6 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2000 12 31 ]

2002 => [ 2002 1 6 ]

2003 => [ 2003 1 5 ]

2004 => [ 2004 1 4 ]

2006 => [ 2006 1 1 ]

2010 => [ 2010 1 3 ]

#####################

config jan7 1 => 0

2000 => [ 2000 1 3 ]

2001 => [ 2001 1 1 ]

2002 => [ 2002 1 7 ]

2003 => [ 2003 1 6 ]

2004 => [ 2004 1 5 ]

2006 => [ 2006 1 2 ]

2010 => [ 2010 1 4 ]

#####################

config jan7 2 => 0

2000 => [ 2000 1 4 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2003 1 7 ]

2004 => [ 2004 1 6 ]

2006 => [ 2006 1 3 ]

2010 => [ 2010 1 5 ]

#####################

config jan7 3 => 0

2000 => [ 2000 1 5 ]

2001 => [ 2001 1 3 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2004 1 7 ]

2006 => [ 2006 1 4 ]

2010 => [ 2010 1 6 ]

#####################

config jan7 4 => 0

2000 => [ 2000 1 6 ]

2001 => [ 2001 1 4 ]

2002 => [ 2002 1 3 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2006 1 5 ]

2010 => [ 2010 1 7 ]

#####################

config jan7 5 => 0

2000 => [ 2000 1 7 ]

2001 => [ 2001 1 5 ]

2002 => [ 2002 1 4 ]

2003 => [ 2003 1 3 ]

2004 => [ 2004 1 2 ]

2006 => [ 2006 1 6 ]

2010 => [ 2010 1 1 ]

#####################

config jan7 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2001 1 6 ]

2002 => [ 2002 1 5 ]

2003 => [ 2003 1 4 ]

2004 => [ 2004 1 3 ]

2006 => [ 2006 1 7 ]

2010 => [ 2010 1 2 ]

#####################

config jan7 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2001 1 7 ]

2002 => [ 2002 1 6 ]

2003 => [ 2003 1 5 ]

2004 => [ 2004 1 4 ]

2006 => [ 2006 1 1 ]

2010 => [ 2010 1 3 ]

#####################

config dow1 1 => 0

2000 => [ 2000 1 3 ]

2001 => [ 2001 1 1 ]

2002 => [ 2002 1 7 ]

2003 => [ 2003 1 6 ]

2004 => [ 2004 1 5 ]

2006 => [ 2006 1 2 ]

2010 => [ 2010 1 4 ]

#####################

config dow1 2 => 0

2000 => [ 1999 12 28 ]

2001 => [ 2000 12 26 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2003 12 30 ]

2006 => [ 2005 12 27 ]

2010 => [ 2009 12 29 ]

#####################

config dow1 3 => 0

2000 => [ 1999 12 29 ]

2001 => [ 2000 12 27 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2005 12 28 ]

2010 => [ 2009 12 30 ]

#####################

config dow1 4 => 0

2000 => [ 1999 12 30 ]

2001 => [ 2000 12 28 ]

2002 => [ 2002 1 3 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2005 12 29 ]

2010 => [ 2009 12 31 ]

#####################

config dow1 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2000 12 29 ]

2002 => [ 2002 1 4 ]

2003 => [ 2003 1 3 ]

2004 => [ 2004 1 2 ]

2006 => [ 2005 12 30 ]

2010 => [ 2010 1 1 ]

#####################

config dow1 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2000 12 30 ]

2002 => [ 2002 1 5 ]

2003 => [ 2003 1 4 ]

2004 => [ 2004 1 3 ]

2006 => [ 2005 12 31 ]

2010 => [ 2010 1 2 ]

#####################

config dow1 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2000 12 31 ]

2002 => [ 2002 1 6 ]

2003 => [ 2003 1 5 ]

2004 => [ 2004 1 4 ]

2006 => [ 2006 1 1 ]

2010 => [ 2010 1 3 ]

#####################

config dow2 1 => 0

2000 => [ 2000 1 3 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2003 1 6 ]

2004 => [ 2004 1 5 ]

2006 => [ 2006 1 2 ]

2010 => [ 2010 1 4 ]

#####################

config dow2 2 => 0

2000 => [ 2000 1 4 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2003 1 7 ]

2004 => [ 2004 1 6 ]

2006 => [ 2006 1 3 ]

2010 => [ 2010 1 5 ]

#####################

config dow2 3 => 0

2000 => [ 1999 12 29 ]

2001 => [ 2000 12 27 ]

2002 => [ 2001 12 26 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2005 12 28 ]

2010 => [ 2009 12 30 ]

#####################

config dow2 4 => 0

2000 => [ 1999 12 30 ]

2001 => [ 2000 12 28 ]

2002 => [ 2001 12 27 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2005 12 29 ]

2010 => [ 2009 12 31 ]

#####################

config dow2 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2000 12 29 ]

2002 => [ 2001 12 28 ]

2003 => [ 2003 1 3 ]

2004 => [ 2004 1 2 ]

2006 => [ 2005 12 30 ]

2010 => [ 2010 1 1 ]

#####################

config dow2 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2000 12 30 ]

2002 => [ 2001 12 29 ]

2003 => [ 2003 1 4 ]

2004 => [ 2004 1 3 ]

2006 => [ 2005 12 31 ]

2010 => [ 2010 1 2 ]

#####################

config dow2 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2000 12 31 ]

2002 => [ 2001 12 30 ]

2003 => [ 2003 1 5 ]

2004 => [ 2004 1 4 ]

2006 => [ 2006 1 1 ]

2010 => [ 2010 1 3 ]

#####################

config dow3 1 => 0

2000 => [ 2000 1 3 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2002 12 30 ]

2004 => [ 2004 1 5 ]

2006 => [ 2006 1 2 ]

2010 => [ 2010 1 4 ]

#####################

config dow3 2 => 0

2000 => [ 2000 1 4 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2004 1 6 ]

2006 => [ 2006 1 3 ]

2010 => [ 2010 1 5 ]

#####################

config dow3 3 => 0

2000 => [ 2000 1 5 ]

2001 => [ 2001 1 3 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2004 1 7 ]

2006 => [ 2006 1 4 ]

2010 => [ 2010 1 6 ]

#####################

config dow3 4 => 0

2000 => [ 1999 12 30 ]

2001 => [ 2000 12 28 ]

2002 => [ 2001 12 27 ]

2003 => [ 2002 12 26 ]

2004 => [ 2004 1 1 ]

2006 => [ 2005 12 29 ]

2010 => [ 2009 12 31 ]

#####################

config dow3 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2000 12 29 ]

2002 => [ 2001 12 28 ]

2003 => [ 2002 12 27 ]

2004 => [ 2004 1 2 ]

2006 => [ 2005 12 30 ]

2010 => [ 2010 1 1 ]

#####################

config dow3 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2000 12 30 ]

2002 => [ 2001 12 29 ]

2003 => [ 2002 12 28 ]

2004 => [ 2004 1 3 ]

2006 => [ 2005 12 31 ]

2010 => [ 2010 1 2 ]

#####################

config dow3 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2000 12 31 ]

2002 => [ 2001 12 30 ]

2003 => [ 2002 12 29 ]

2004 => [ 2004 1 4 ]

2006 => [ 2006 1 1 ]

2010 => [ 2010 1 3 ]

#####################

config dow4 1 => 0

2000 => [ 2000 1 3 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2002 12 30 ]

2004 => [ 2003 12 29 ]

2006 => [ 2006 1 2 ]

2010 => [ 2010 1 4 ]

#####################

config dow4 2 => 0

2000 => [ 2000 1 4 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2003 12 30 ]

2006 => [ 2006 1 3 ]

2010 => [ 2010 1 5 ]

#####################

config dow4 3 => 0

2000 => [ 2000 1 5 ]

2001 => [ 2001 1 3 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2006 1 4 ]

2010 => [ 2010 1 6 ]

#####################

config dow4 4 => 0

2000 => [ 2000 1 6 ]

2001 => [ 2001 1 4 ]

2002 => [ 2002 1 3 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2006 1 5 ]

2010 => [ 2010 1 7 ]

#####################

config dow4 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2000 12 29 ]

2002 => [ 2001 12 28 ]

2003 => [ 2002 12 27 ]

2004 => [ 2003 12 26 ]

2006 => [ 2005 12 30 ]

2010 => [ 2010 1 1 ]

#####################

config dow4 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2000 12 30 ]

2002 => [ 2001 12 29 ]

2003 => [ 2002 12 28 ]

2004 => [ 2003 12 27 ]

2006 => [ 2005 12 31 ]

2010 => [ 2010 1 2 ]

#####################

config dow4 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2000 12 31 ]

2002 => [ 2001 12 30 ]

2003 => [ 2002 12 29 ]

2004 => [ 2003 12 28 ]

2006 => [ 2006 1 1 ]

2010 => [ 2010 1 3 ]

#####################

config dow5 1 => 0

2000 => [ 2000 1 3 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2002 12 30 ]

2004 => [ 2003 12 29 ]

2006 => [ 2006 1 2 ]

2010 => [ 2009 12 28 ]

#####################

config dow5 2 => 0

2000 => [ 2000 1 4 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2003 12 30 ]

2006 => [ 2006 1 3 ]

2010 => [ 2009 12 29 ]

#####################

config dow5 3 => 0

2000 => [ 2000 1 5 ]

2001 => [ 2001 1 3 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2006 1 4 ]

2010 => [ 2009 12 30 ]

#####################

config dow5 4 => 0

2000 => [ 2000 1 6 ]

2001 => [ 2001 1 4 ]

2002 => [ 2002 1 3 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2006 1 5 ]

2010 => [ 2009 12 31 ]

#####################

config dow5 5 => 0

2000 => [ 2000 1 7 ]

2001 => [ 2001 1 5 ]

2002 => [ 2002 1 4 ]

2003 => [ 2003 1 3 ]

2004 => [ 2004 1 2 ]

2006 => [ 2006 1 6 ]

2010 => [ 2010 1 1 ]

#####################

config dow5 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2000 12 30 ]

2002 => [ 2001 12 29 ]

2003 => [ 2002 12 28 ]

2004 => [ 2003 12 27 ]

2006 => [ 2005 12 31 ]

2010 => [ 2009 12 26 ]

#####################

config dow5 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2000 12 31 ]

2002 => [ 2001 12 30 ]

2003 => [ 2002 12 29 ]

2004 => [ 2003 12 28 ]

2006 => [ 2006 1 1 ]

2010 => [ 2009 12 27 ]

#####################

config dow6 1 => 0

2000 => [ 1999 12 27 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2002 12 30 ]

2004 => [ 2003 12 29 ]

2006 => [ 2006 1 2 ]

2010 => [ 2009 12 28 ]

#####################

config dow6 2 => 0

2000 => [ 1999 12 28 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2003 12 30 ]

2006 => [ 2006 1 3 ]

2010 => [ 2009 12 29 ]

#####################

config dow6 3 => 0

2000 => [ 1999 12 29 ]

2001 => [ 2001 1 3 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2006 1 4 ]

2010 => [ 2009 12 30 ]

#####################

config dow6 4 => 0

2000 => [ 1999 12 30 ]

2001 => [ 2001 1 4 ]

2002 => [ 2002 1 3 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2006 1 5 ]

2010 => [ 2009 12 31 ]

#####################

config dow6 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2001 1 5 ]

2002 => [ 2002 1 4 ]

2003 => [ 2003 1 3 ]

2004 => [ 2004 1 2 ]

2006 => [ 2006 1 6 ]

2010 => [ 2010 1 1 ]

#####################

config dow6 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2001 1 6 ]

2002 => [ 2002 1 5 ]

2003 => [ 2003 1 4 ]

2004 => [ 2004 1 3 ]

2006 => [ 2006 1 7 ]

2010 => [ 2010 1 2 ]

#####################

config dow6 7 => 0

2000 => [ 1999 12 26 ]

2001 => [ 2000 12 31 ]

2002 => [ 2001 12 30 ]

2003 => [ 2002 12 29 ]

2004 => [ 2003 12 28 ]

2006 => [ 2006 1 1 ]

2010 => [ 2009 12 27 ]

#####################

config dow7 1 => 0

2000 => [ 1999 12 27 ]

2001 => [ 2001 1 1 ]

2002 => [ 2001 12 31 ]

2003 => [ 2002 12 30 ]

2004 => [ 2003 12 29 ]

2006 => [ 2005 12 26 ]

2010 => [ 2009 12 28 ]

#####################

config dow7 2 => 0

2000 => [ 1999 12 28 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2002 12 31 ]

2004 => [ 2003 12 30 ]

2006 => [ 2005 12 27 ]

2010 => [ 2009 12 29 ]

#####################

config dow7 3 => 0

2000 => [ 1999 12 29 ]

2001 => [ 2001 1 3 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2003 12 31 ]

2006 => [ 2005 12 28 ]

2010 => [ 2009 12 30 ]

#####################

config dow7 4 => 0

2000 => [ 1999 12 30 ]

2001 => [ 2001 1 4 ]

2002 => [ 2002 1 3 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2005 12 29 ]

2010 => [ 2009 12 31 ]

#####################

config dow7 5 => 0

2000 => [ 1999 12 31 ]

2001 => [ 2001 1 5 ]

2002 => [ 2002 1 4 ]

2003 => [ 2003 1 3 ]

2004 => [ 2004 1 2 ]

2006 => [ 2005 12 30 ]

2010 => [ 2010 1 1 ]

#####################

config dow7 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2001 1 6 ]

2002 => [ 2002 1 5 ]

2003 => [ 2003 1 4 ]

2004 => [ 2004 1 3 ]

2006 => [ 2005 12 31 ]

2010 => [ 2010 1 2 ]

#####################

config dow7 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2001 1 7 ]

2002 => [ 2002 1 6 ]

2003 => [ 2003 1 5 ]

2004 => [ 2004 1 4 ]

2006 => [ 2006 1 1 ]

2010 => [ 2010 1 3 ]

#####################

config firstday 1 => 0

2000 => [ 2000 1 3 ]

2001 => [ 2001 1 1 ]

2002 => [ 2002 1 7 ]

2003 => [ 2003 1 6 ]

2004 => [ 2004 1 5 ]

2006 => [ 2006 1 2 ]

2010 => [ 2010 1 4 ]

#####################

config firstday 2 => 0

2000 => [ 2000 1 4 ]

2001 => [ 2001 1 2 ]

2002 => [ 2002 1 1 ]

2003 => [ 2003 1 7 ]

2004 => [ 2004 1 6 ]

2006 => [ 2006 1 3 ]

2010 => [ 2010 1 5 ]

#####################

config firstday 3 => 0

2000 => [ 2000 1 5 ]

2001 => [ 2001 1 3 ]

2002 => [ 2002 1 2 ]

2003 => [ 2003 1 1 ]

2004 => [ 2004 1 7 ]

2006 => [ 2006 1 4 ]

2010 => [ 2010 1 6 ]

#####################

config firstday 4 => 0

2000 => [ 2000 1 6 ]

2001 => [ 2001 1 4 ]

2002 => [ 2002 1 3 ]

2003 => [ 2003 1 2 ]

2004 => [ 2004 1 1 ]

2006 => [ 2006 1 5 ]

2010 => [ 2010 1 7 ]

#####################

config firstday 5 => 0

2000 => [ 2000 1 7 ]

2001 => [ 2001 1 5 ]

2002 => [ 2002 1 4 ]

2003 => [ 2003 1 3 ]

2004 => [ 2004 1 2 ]

2006 => [ 2006 1 6 ]

2010 => [ 2010 1 1 ]

#####################

config firstday 6 => 0

2000 => [ 2000 1 1 ]

2001 => [ 2001 1 6 ]

2002 => [ 2002 1 5 ]

2003 => [ 2003 1 4 ]

2004 => [ 2004 1 3 ]

2006 => [ 2006 1 7 ]

2010 => [ 2010 1 2 ]

#####################

config firstday 7 => 0

2000 => [ 2000 1 2 ]

2001 => [ 2001 1 7 ]

2002 => [ 2002 1 6 ]

2003 => [ 2003 1 5 ]

2004 => [ 2004 1 4 ]

2006 => [ 2006 1 1 ]

2010 => [ 2010 1 3 ]

";

$::ti->tests(func  => \&test,
             tests => $tests);
$::ti->done_testing();

#Local Variables:
#mode: cperl
#indent-tabs-mode: nil
#cperl-indent-level: 3
#cperl-continued-statement-offset: 2
#cperl-continued-brace-offset: 0
#cperl-brace-offset: 0
#cperl-brace-imaginary-offset: 0
#cperl-label-offset: 0
#End:
