/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry.intersection;

import org.eclipse.draw3d.geometry.IVector2f;

public class Segment {
    private IVector2f m_end;
    private IVector2f m_start;
    private IVector2f m_left;
    private IVector2f m_right;
    private IVector2f m_upper;
    private IVector2f m_lower;
    private float m_c;
    private float m_g;

    public Segment(IVector2f i_start, IVector2f i_end) {
        this.m_start = i_start;
        this.m_end = i_end;
        float dX = this.getEnd().getX() - this.getStart().getX();
        float dY = this.getEnd().getY() - this.getStart().getY();
        if (dX != 0.0f) {
            this.m_g = Math.abs(dY / dX);
            this.m_c = this.m_g * this.getStart().getX() - this.getStart().getY();
        } else {
            this.m_g = Float.POSITIVE_INFINITY;
            this.m_c = Float.NaN;
        }
    }

    public float getC() {
        return this.m_c;
    }

    public float getG() {
        return this.m_g;
    }

    public IVector2f getEnd() {
        return this.m_end;
    }

    public IVector2f getStart() {
        return this.m_start;
    }
}

