/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.ui.impl;

import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryModel;
import org.eclipse.birt.data.oda.mongodb.internal.impl.QueryProperties;
import org.eclipse.birt.data.oda.mongodb.ui.i18n.Messages;
import org.eclipse.birt.data.oda.mongodb.ui.impl.MongoDBExpressionBuilder;
import org.eclipse.birt.data.oda.mongodb.ui.util.UIHelper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class MDBCommandExpressionBuilder
extends MongoDBExpressionBuilder {
    private QueryProperties.CommandOperationType opType;

    public MDBCommandExpressionBuilder(Shell parent, QueryProperties.CommandOperationType opType) {
        super(parent);
        this.opType = opType;
    }

    @Override
    protected void initDialogTitle() {
        this.setTitle(Messages.getString("MongoDBExpressionBuilder.CommandExpression.DialogTitle"));
    }

    @Override
    protected void createDialogHelper(Composite composite) {
        UIHelper.setSystemHelp((Control)composite, "org.eclipse.birt.cshelp.MongoDB_DataSetCommandExprDialog_ID");
    }

    @Override
    protected void doValidateExpressionSyntax() throws OdaException {
        QueryModel.validateCommandSyntax((QueryProperties.CommandOperationType)this.opType, (String)this.expression);
    }

    @Override
    protected void validateStatus() {
        Status status = null;
        status = this.expression.trim().length() == 0 ? this.getMiscStatus(4, Messages.getString("MongoDBExpressionBuilder.CommandExpression.error.EmptyExpression")) : this.getOKStatus();
        if (status != null) {
            this.updateStatus((IStatus)status);
        }
    }
}

