/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.internal.ui.history.CompareFileRevisionEditorInput;
import org.eclipse.team.internal.ui.synchronize.SaveablesCompareEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class CompareAction
extends TeamAction {
    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        IResource[] selectedResources = this.getSelectedResources();
        ITypedElement ancestor = null;
        ITypedElement left = null;
        ITypedElement right = null;
        if (selectedResources.length == 2) {
            if (selectedResources[0] != null) {
                left = this.getElementFor(selectedResources[0]);
            }
            if (selectedResources[1] != null) {
                right = this.getElementFor(selectedResources[1]);
            }
        } else if (selectedResources.length == 3) {
            SelectAncestorDialog dialog = new SelectAncestorDialog(this.getShell(), selectedResources);
            int code = dialog.open();
            if (code != 0) {
                return;
            }
            ancestor = this.getElementFor(dialog.ancestorResource);
            left = this.getElementFor(dialog.leftResource);
            right = this.getElementFor(dialog.rightResource);
        } else {
            return;
        }
        this.openInCompare(ancestor, left, right);
    }

    private void openInCompare(ITypedElement ancestor, ITypedElement left, ITypedElement right) {
        IWorkbenchPage workBenchPage = this.getTargetPage();
        SaveablesCompareEditorInput input = new SaveablesCompareEditorInput(ancestor, left, right, workBenchPage);
        IEditorPart editor = Utils.findReusableCompareEditor(input, workBenchPage, new Class[]{CompareFileRevisionEditorInput.class});
        if (editor != null) {
            IEditorInput otherInput = editor.getEditorInput();
            if (otherInput.equals((Object)input)) {
                workBenchPage.activate((IWorkbenchPart)editor);
            } else {
                CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                workBenchPage.activate((IWorkbenchPart)editor);
            }
        } else {
            CompareUI.openCompareEditor((CompareEditorInput)input);
        }
    }

    public boolean isEnabled() {
        int l = this.getSelectedResources().length;
        return l == 2 || l == 3;
    }

    private ITypedElement getElementFor(IResource resource) {
        return SaveablesCompareEditorInput.createFileElement((IFile)resource);
    }

    private static class SelectAncestorDialog
    extends MessageDialog {
        private IResource[] theResources;
        IResource ancestorResource;
        IResource leftResource;
        IResource rightResource;
        private Button[] buttons;
        private SelectionListener selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button selectedButton = (Button)e.widget;
                if (!selectedButton.getSelection()) {
                    return;
                }
                int i = 0;
                while (i < 3) {
                    if (selectedButton == buttons[i]) {
                        this.pickAncestor(i);
                    }
                    ++i;
                }
            }
        };

        public SelectAncestorDialog(Shell parentShell, IResource[] theResources) {
            super(parentShell, TeamUIMessages.SelectAncestorDialog_title, null, TeamUIMessages.SelectAncestorDialog_message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            this.theResources = theResources;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.buttons = new Button[3];
            int i = 0;
            while (i < 3) {
                this.buttons[i] = new Button(composite, 16);
                this.buttons[i].addSelectionListener(this.selectionListener);
                this.buttons[i].setText(NLS.bind((String)TeamUIMessages.SelectAncestorDialog_option, (Object)this.theResources[i].getFullPath().toPortableString()));
                this.buttons[i].setFont(parent.getFont());
                this.buttons[i].setSelection(i == 0);
                ++i;
            }
            this.pickAncestor(0);
            return composite;
        }

        private void pickAncestor(int i) {
            this.ancestorResource = this.theResources[i];
            this.leftResource = this.theResources[i == 0 ? 1 : 0];
            this.rightResource = this.theResources[i == 2 ? 1 : 2];
        }
    }
}

