/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.report.model.api.IModuleOption;
import org.eclipse.birt.report.model.api.IResourceLocator;

public class ModuleOption
implements IModuleOption {
    protected Map<String, Object> options = new HashMap<String, Object>();

    public ModuleOption() {
    }

    public ModuleOption(Map options) {
        if (options != null && !options.isEmpty()) {
            this.options.putAll(options);
        }
    }

    public boolean useSemanticCheck() {
        Object semanticCheck = this.options.get("semanticCheck");
        if (semanticCheck != null) {
            return (Boolean)semanticCheck;
        }
        return true;
    }

    public void setSemanticCheck(boolean useSemanticCheck) {
        this.options.put("semanticCheck", useSemanticCheck);
    }

    public String getResourceFolder() {
        return (String)this.options.get("resourceFolder");
    }

    public void setResourceFolder(String resourceFolder) {
        if (resourceFolder != null) {
            this.options.put("resourceFolder", resourceFolder);
        }
    }

    public void setProperty(String key, Object value) {
        this.options.put(key, value);
    }

    public Object getProperty(String key) {
        return this.options.get(key);
    }

    public boolean markLineNumber() {
        Object markLineNumber = this.options.get("markLineNumber");
        if (markLineNumber != null) {
            return (Boolean)markLineNumber;
        }
        return true;
    }

    public void setMarkLineNumber(boolean markLineNumber) {
        this.options.put("markLineNumber", markLineNumber);
    }

    public IResourceLocator getResourceLocator() {
        return (IResourceLocator)this.options.get("resourceLocator");
    }

    public void setResourceLocator(IResourceLocator locator) {
        if (locator != null) {
            this.options.put("resourceLocator", locator);
        }
    }

    public ULocale getLocale() {
        Object locale = this.options.get("locale");
        if (locale instanceof ULocale) {
            return (ULocale)locale;
        }
        if (locale instanceof Locale) {
            return ULocale.forLocale((Locale)((Locale)locale));
        }
        return null;
    }

    public void setLocale(ULocale locale) {
        if (locale != null) {
            this.options.put("locale", locale);
        }
    }

    public void setToLatestVersion(boolean toSet) {
        if (toSet) {
            this.options.put("toLatestVersion", Boolean.TRUE);
        }
    }

    public boolean toLatestVersion() {
        Object retValue = this.options.get("toLatestVersion");
        if (retValue == null || !(retValue instanceof Boolean)) {
            return false;
        }
        return (Boolean)retValue;
    }

    public Object copy() throws CloneNotSupportedException {
        ModuleOption obj = new ModuleOption();
        obj.options = new HashMap<String, Object>();
        obj.options.putAll(this.options);
        return obj;
    }

    public Map getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    public void setOptions(Map options) {
        if (options == null || options.isEmpty()) {
            return;
        }
        this.options.putAll(options);
    }

    public void close() {
        Iterator<Map.Entry<String, Object>> iterator = this.options.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (this.isPrimitiveType(entry.getValue())) continue;
            iterator.remove();
        }
    }

    private boolean isPrimitiveType(Object obj) {
        return obj == null || obj instanceof ULocale || obj.getClass().getName().startsWith("java.lang.");
    }

    public boolean isSupportedUnknownVersion() {
        Object isSupportedUnknownVersion = this.options.get("supportedUnknownVersion");
        return isSupportedUnknownVersion instanceof Boolean && (Boolean)isSupportedUnknownVersion != false;
    }

    public void setSupportedUnknownVersion(boolean isSupportedUnknownVersion) {
        this.options.put("supportedUnknownVersion", isSupportedUnknownVersion);
    }
}

