/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.cdt.notification;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.capra.core.adapters.ArtifactMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.handler.cdt.CDTHandler;
import org.eclipse.capra.ui.notification.CapraNotificationHelper;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CElementChangeListener
implements IElementChangedListener {
    ArtifactMetaModelAdapter artifactAdapter = (ArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactWrapperMetaModelAdapter().orElseThrow();

    public void elementChanged(final ElementChangedEvent event) {
        TracePersistenceAdapter tracePersistenceAdapter = (TracePersistenceAdapter)ExtensionPointHelper.getTracePersistenceAdapter().orElseThrow();
        EObject artifactModel = tracePersistenceAdapter.getArtifactWrappers(EditingDomainHelper.getResourceSet());
        List allArtifacts = this.artifactAdapter.getAllArtifacts(artifactModel);
        final List cArtifacts = allArtifacts.stream().filter(p -> this.artifactAdapter.getArtifactHandler(p).equals(CDTHandler.class.getName())).collect(Collectors.toList());
        if (cArtifacts.isEmpty()) {
            return;
        }
        Path path = new Path(EcoreUtil.getURI((EObject)artifactModel).toPlatformString(false));
        final IFile wrapperContainer = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        new WorkspaceJob("CapraNotificationJob"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                CElementChangeListener.this.handleDelta(event.getDelta(), cArtifacts, wrapperContainer);
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void handleDelta(ICElementDelta delta, List<EObject> cArtifacts, IFile wrapperContainer) {
        String affectedElementUri;
        ICElementDelta[] iCElementDeltaArray = delta.getAffectedChildren();
        int n = iCElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICElementDelta subDelta = iCElementDeltaArray[n2];
            this.handleDelta(subDelta, cArtifacts, wrapperContainer);
            ++n2;
        }
        int flags = delta.getFlags();
        int changeType = delta.getKind();
        ICElement affectedElement = delta.getElement();
        CapraNotificationHelper.IssueType issueType = null;
        if (changeType == 1) {
            issueType = CapraNotificationHelper.IssueType.ADDED;
        } else if (changeType == 2) {
            if ((flags & 0x20) != 0) {
                issueType = delta.getMovedToElement().getElementName().equals(affectedElement.getElementName()) ? CapraNotificationHelper.IssueType.MOVED : CapraNotificationHelper.IssueType.RENAMED;
            } else if (!(affectedElement instanceof ITranslationUnit) || !((ITranslationUnit)affectedElement).isWorkingCopy()) {
                issueType = CapraNotificationHelper.IssueType.DELETED;
            }
        } else if (changeType == 4) {
            issueType = CapraNotificationHelper.IssueType.CHANGED;
        }
        if (issueType != null && (affectedElementUri = affectedElement.getHandleIdentifier()) != null) {
            for (EObject aw : cArtifacts) {
                String artifactId = this.artifactAdapter.getArtifactIdentifier(aw);
                if (issueType == CapraNotificationHelper.IssueType.CHANGED && !artifactId.equals(affectedElementUri)) continue;
                CapraNotificationHelper.IssueType[] markersToDelete = null;
                String deleteMarkerUri = "";
                if (issueType == CapraNotificationHelper.IssueType.MOVED || issueType == CapraNotificationHelper.IssueType.RENAMED) {
                    deleteMarkerUri = delta.getMovedToElement().getHandleIdentifier();
                    markersToDelete = new CapraNotificationHelper.IssueType[]{CapraNotificationHelper.IssueType.MOVED, CapraNotificationHelper.IssueType.RENAMED, CapraNotificationHelper.IssueType.DELETED};
                } else if (issueType == CapraNotificationHelper.IssueType.DELETED) {
                    markersToDelete = new CapraNotificationHelper.IssueType[]{CapraNotificationHelper.IssueType.MOVED, CapraNotificationHelper.IssueType.RENAMED, CapraNotificationHelper.IssueType.CHANGED};
                    deleteMarkerUri = affectedElementUri;
                } else if (issueType == CapraNotificationHelper.IssueType.ADDED) {
                    markersToDelete = new CapraNotificationHelper.IssueType[]{CapraNotificationHelper.IssueType.MOVED, CapraNotificationHelper.IssueType.RENAMED, CapraNotificationHelper.IssueType.DELETED};
                    deleteMarkerUri = affectedElementUri;
                }
                if (!deleteMarkerUri.isEmpty() && artifactId.contains(deleteMarkerUri)) {
                    CapraNotificationHelper.deleteCapraMarker((String)artifactId, (CapraNotificationHelper.IssueType[])markersToDelete, (IFile)wrapperContainer);
                }
                if (!artifactId.contains(affectedElementUri)) continue;
                HashMap<String, String> markerInfo = this.generateMarkerInfo(aw, delta, issueType);
                CapraNotificationHelper.createCapraMarker(markerInfo, (IFile)wrapperContainer);
            }
        }
    }

    private HashMap<String, String> generateMarkerInfo(EObject aw, ICElementDelta delta, CapraNotificationHelper.IssueType issueType) {
        HashMap<String, String> markerInfo = new HashMap<String, String>();
        String oldArtifactUri = this.artifactAdapter.getArtifactIdentifier(aw);
        String oldArtifactName = this.artifactAdapter.getArtifactName(aw);
        ICElement oldAffectedElement = delta.getElement();
        String oldAffectedElementUri = oldAffectedElement.getHandleIdentifier();
        String oldAffectedElementName = oldAffectedElement.getElementName();
        String newAffectedElementUri = null;
        String newAffectedElementName = null;
        ICElement newAffectedElement = delta.getMovedToElement();
        if (newAffectedElement != null) {
            newAffectedElementUri = newAffectedElement.getHandleIdentifier();
            newAffectedElementName = newAffectedElement.getElementName();
        }
        String message = "";
        switch (issueType) {
            case RENAMED: {
                if (oldArtifactUri.equals(oldAffectedElementUri)) {
                    message = String.valueOf(oldAffectedElementUri) + " has been renamed to " + newAffectedElementUri + ".";
                    break;
                }
                message = String.valueOf(oldAffectedElementName) + ", an ancestor of " + oldArtifactUri + ", has been renamed to " + newAffectedElementName + ".";
                break;
            }
            case MOVED: {
                if (oldArtifactUri.equals(oldAffectedElementUri)) {
                    message = String.valueOf(oldAffectedElementUri) + " has been moved to " + newAffectedElementUri + ".";
                    break;
                }
                message = String.valueOf(oldAffectedElementName) + ", an ancestor of " + oldArtifactUri + ", has been moved to " + newAffectedElementUri;
                break;
            }
            case DELETED: {
                message = String.valueOf(this.artifactAdapter.getArtifactUri(aw)) + " has been deleted or has had its signature changed.";
                break;
            }
            case CHANGED: {
                message = String.valueOf(this.artifactAdapter.getArtifactUri(aw)) + " has been edited. Please check if associated trace links are still valid.";
                break;
            }
        }
        if (newAffectedElementUri != null) {
            String newArtifactName;
            String newArtifactUri;
            if (oldArtifactUri.equals(oldAffectedElementUri)) {
                newArtifactUri = newAffectedElementUri;
                newArtifactName = newAffectedElementName;
            } else {
                newArtifactUri = oldArtifactUri.replace(oldAffectedElementUri, newAffectedElementUri);
                newArtifactName = oldArtifactName;
            }
            markerInfo.put("newArtifactUri", newArtifactUri);
            markerInfo.put("newArtifactName", newArtifactName);
        }
        markerInfo.put("issueType", issueType.getValue());
        markerInfo.put("oldArtifactUri", oldArtifactUri);
        markerInfo.put("message", message);
        return markerInfo;
    }
}

