/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudSpace;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.CloudServerUtil;
import org.eclipse.cft.server.core.internal.spaces.CloudFoundrySpace;
import org.eclipse.cft.server.core.internal.spaces.CloudOrgsAndSpaces;
import org.eclipse.cft.server.core.internal.spaces.CloudSpacesDescriptor;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.osgi.util.NLS;

public abstract class CloudSpacesDelegate {
    private final CloudFoundryServer cloudServer;
    private CloudSpacesDescriptor spacesDescriptor;
    protected final String serverServiceName;

    protected CloudSpacesDelegate(CloudFoundryServer cloudServer) {
        this.cloudServer = cloudServer;
        String serverTypeId = cloudServer.getServer().getServerType().getId();
        this.serverServiceName = CloudFoundryBrandingExtensionPoint.getServiceName((String)serverTypeId);
    }

    public String getServerServiceName() {
        return this.serverServiceName;
    }

    public CloudSpace getSpaceWithNoServerInstance() {
        CloudOrgsAndSpaces orgsSpaces;
        CloudSpacesDescriptor descriptor = this.getCurrentSpacesDescriptor();
        CloudOrgsAndSpaces cloudOrgsAndSpaces = orgsSpaces = descriptor != null ? descriptor.getOrgsAndSpaces() : null;
        if (orgsSpaces != null) {
            List cloudServers = CloudServerUtil.getCloudServers();
            if (cloudServers == null || cloudServers.isEmpty()) {
                return orgsSpaces.getDefaultCloudSpace();
            }
            List spaces = orgsSpaces.getAllSpaces();
            if (spaces != null) {
                String url = this.cloudServer.getUrl();
                for (CloudSpace space : spaces) {
                    CloudFoundryServer foundServer = null;
                    for (CloudFoundryServer existingServer : cloudServers) {
                        if (!existingServer.getUrl().equals(url) || !CloudSpacesDelegate.matchesSpace(space, existingServer.getCloudFoundrySpace())) continue;
                        foundServer = this.cloudServer;
                        break;
                    }
                    if (foundServer != null) continue;
                    return space;
                }
            }
        }
        return null;
    }

    public boolean matchesCurrentDescriptor(String urlText, String userName, String password, boolean selfSigned) {
        String actualURL = CFUiUtil.getUrlFromDisplayText(urlText);
        String cachedDescriptorID = CloudSpacesDescriptor.getDescriptorID((String)userName, (String)password, (String)actualURL, (boolean)selfSigned);
        return this.getCurrentSpacesDescriptor() != null && this.getCurrentSpacesDescriptor().getID() != null && this.getCurrentSpacesDescriptor().getID().equals(cachedDescriptorID);
    }

    public IStatus validateSpaceSelection(String cloudServerURL, CloudSpace selectedCloudSpace) {
        List cloudServers;
        String errorMessage = null;
        if (cloudServerURL == null) {
            cloudServerURL = this.getCloudServer().getUrl();
        }
        if (selectedCloudSpace == null) {
            errorMessage = Messages.ERROR_INVALID_SPACE;
        } else if (cloudServerURL != null && (cloudServers = CloudServerUtil.getCloudServers()) != null) {
            for (CloudFoundryServer cloudServer : cloudServers) {
                if (!cloudServerURL.equals(cloudServer.getUrl()) || !CloudSpacesDelegate.matchesSpace(selectedCloudSpace, cloudServer.getCloudFoundrySpace())) continue;
                errorMessage = NLS.bind((String)Messages.ERROR_SERVER_INSTANCE_CLOUD_SPACE_EXISTS, (Object)cloudServer.getServer().getName(), (Object)selectedCloudSpace.getName());
                break;
            }
        }
        return errorMessage != null ? CloudFoundryPlugin.getErrorStatus((String)errorMessage) : Status.OK_STATUS;
    }

    public CloudSpacesDescriptor getCurrentSpacesDescriptor() {
        return this.spacesDescriptor;
    }

    public void clearDescriptor() {
        this.spacesDescriptor = null;
    }

    public CloudSpacesDescriptor resolveDescriptor(String urlText, String userName, String password, boolean selfSigned, IRunnableContext context, boolean updateDescriptor) throws CoreException {
        IStatus status;
        CloudSpacesDescriptor descriptor = null;
        if (updateDescriptor) {
            descriptor = this.internalUpdateDescriptor(urlText, userName, password, selfSigned, context);
        }
        if ((status = this.validateCurrent(this.getCurrentCloudSpace())) != null && !status.isOK()) {
            throw new CoreException(status);
        }
        return descriptor;
    }

    protected CloudSpacesDescriptor internalUpdateDescriptor(String urlText, String userName, String password, boolean selfSigned, IRunnableContext context) throws CoreException {
        CloudOrgsAndSpaces orgsAndSpaces;
        String actualURL = CFUiUtil.getUrlFromDisplayText(urlText);
        this.validateCredentialsLocally(actualURL, userName, password);
        if (this.spacesDescriptor == null && (orgsAndSpaces = CFUiUtil.getCloudSpaces(userName, password, actualURL, true, selfSigned, context)) != null) {
            this.spacesDescriptor = new CloudSpacesDescriptor(orgsAndSpaces, userName, password, actualURL, selfSigned);
        }
        return this.spacesDescriptor;
    }

    protected IStatus validateCurrent(CloudSpace currentSpace) {
        int severity = 0;
        String validationMessage = Messages.VALID_ACCOUNT;
        CloudSpacesDescriptor descriptor = this.getCurrentSpacesDescriptor();
        if (descriptor == null || descriptor.getOrgsAndSpaces() == null) {
            validationMessage = Messages.ERROR_CHECK_CONNECTION_NO_SPACES;
            severity = 4;
        } else if (this.getSpaceWithNoServerInstance() == null) {
            validationMessage = Messages.ERROR_ALL_SPACES_ASSOCIATED_SERVER_INSTANCES;
            severity = 4;
        } else {
            return this.validateSpaceSelection(currentSpace);
        }
        return CloudFoundryPlugin.getStatus((String)validationMessage, (int)severity);
    }

    protected void validateCredentialsLocally(String url, String userName, String password) throws CoreException {
        String[][] valuesToCheck;
        String actualURL = this.cloudServer.getUrl();
        String actualUserName = this.cloudServer.getUsername();
        String actualPassword = this.cloudServer.getPassword();
        boolean isValid = true;
        String[][] stringArrayArray = valuesToCheck = new String[][]{{url, actualURL}, {userName, actualUserName}, {password, actualPassword}};
        int n = valuesToCheck.length;
        int n2 = 0;
        while (n2 < n) {
            String[] value = stringArrayArray[n2];
            if (!this.areValid(value[0], value[1])) {
                isValid = false;
                break;
            }
            ++n2;
        }
        if (!isValid) {
            throw new CoreException(CloudFoundryPlugin.getErrorStatus((String)NLS.bind((String)Messages.CloudSpacesDelegate_ERROR_FAIL_LOADING_CLOUDSPACES, (Object[])new String[]{actualURL, userName})));
        }
    }

    protected boolean areValid(String expected, String actual) {
        return actual != null ? actual.equals(expected) : false;
    }

    protected CloudFoundryServer getCloudServer() {
        return this.cloudServer;
    }

    public static boolean matchesSpace(CloudSpace selectedCloudSpace, CloudFoundrySpace existingSpace) {
        return existingSpace == null && selectedCloudSpace == null || existingSpace != null && selectedCloudSpace != null && existingSpace.getOrgName().equals(selectedCloudSpace.getOrganization().getName()) && existingSpace.getSpaceName().equals(selectedCloudSpace.getName());
    }

    public IStatus validateSpaceSelection(CloudSpace selectedCloudSpace) {
        return this.validateSpaceSelection(null, selectedCloudSpace);
    }

    public boolean hasSpace() {
        return this.getCurrentCloudSpace() != null;
    }

    public abstract void setSelectedSpace(CloudSpace var1);

    protected abstract CloudSpace getCurrentCloudSpace();
}

