/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.primitive;

import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.lazy.primitive.CollectLongToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.FlatCollectLongToObjectIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyLongIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.SelectLongIterable;

public final class LazyLongIterate {
    private static final LazyLongIterable EMPTY_ITERABLE = LongLists.immutable.empty().asLazy();

    private LazyLongIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyLongIterable adapt(LongIterable iterable) {
        return new LazyLongIterableAdapter(iterable);
    }

    public static LazyLongIterable select(LongIterable iterable, LongPredicate predicate) {
        return new SelectLongIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(LongIterable iterable, LongToObjectFunction<? extends V> function) {
        return new CollectLongToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> flatCollect(LongIterable iterable, LongToObjectFunction<? extends Iterable<V>> function) {
        return new FlatCollectLongToObjectIterable(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(LongIterable iterable, LongPredicate predicate, LongToObjectFunction<? extends V> function) {
        return LazyLongIterate.select(iterable, predicate).collect((LongToObjectFunction)function);
    }

    public static LazyLongIterable empty() {
        return EMPTY_ITERABLE;
    }
}

