/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.comma.behavior.behavior.Port;
import org.eclipse.comma.behavior.behavior.ProvidedPort;
import org.eclipse.comma.behavior.behavior.RequiredPort;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.component.component.ComponentPackage;
import org.eclipse.comma.behavior.component.utilities.ComponentUtilities;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.InterfaceDefinitionPackage;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.project.ProjectUtility;
import org.eclipse.comma.project.project.AdapterInterfacePairs;
import org.eclipse.comma.project.project.ComponentReference;
import org.eclipse.comma.project.project.CompoundInterface;
import org.eclipse.comma.project.project.DocumentationGenerationTask;
import org.eclipse.comma.project.project.EnvironmentComponent;
import org.eclipse.comma.project.project.EventMapping;
import org.eclipse.comma.project.project.ExecutableSource;
import org.eclipse.comma.project.project.FilePath;
import org.eclipse.comma.project.project.GeneratorBlock;
import org.eclipse.comma.project.project.HomeState;
import org.eclipse.comma.project.project.HomeStateSet;
import org.eclipse.comma.project.project.InterfaceMappings;
import org.eclipse.comma.project.project.InterfaceModel;
import org.eclipse.comma.project.project.InterfaceReference;
import org.eclipse.comma.project.project.ModelQualityChecksGenerationTask;
import org.eclipse.comma.project.project.MonitoringTask;
import org.eclipse.comma.project.project.ParameterSegment;
import org.eclipse.comma.project.project.Path;
import org.eclipse.comma.project.project.PathMappings;
import org.eclipse.comma.project.project.PortSpec;
import org.eclipse.comma.project.project.Project;
import org.eclipse.comma.project.project.ProjectDescription;
import org.eclipse.comma.project.project.ProjectPackage;
import org.eclipse.comma.project.project.RESTOperation;
import org.eclipse.comma.project.project.RESTTask;
import org.eclipse.comma.project.project.ReachabilityGraphGenerationTask;
import org.eclipse.comma.project.project.Segment;
import org.eclipse.comma.project.project.SignatureMapping;
import org.eclipse.comma.project.project.SimulatorGenerationTask;
import org.eclipse.comma.project.project.Task;
import org.eclipse.comma.project.project.TestApplicationGenerationTask;
import org.eclipse.comma.project.project.TestCasesGenerationTask;
import org.eclipse.comma.project.project.TraceSource;
import org.eclipse.comma.project.project.TypeMapping;
import org.eclipse.comma.project.project.TypeMappings;
import org.eclipse.comma.project.validation.AbstractProjectValidator;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.signature.utilities.InterfaceUtilities;
import org.eclipse.comma.testcases.TestCasesGenerator;
import org.eclipse.comma.types.comments.SLCommentLocator;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.FileImport;
import org.eclipse.comma.types.types.NamespaceImport;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.Type;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypeObject;
import org.eclipse.comma.types.types.TypeReference;
import org.eclipse.comma.types.types.TypesPackage;
import org.eclipse.comma.types.utilities.TypeUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ProjectValidator
extends AbstractProjectValidator {
    public final String WARNING_CODE_EMPTY_BLOCK = "warning_code_empty_block";
    public final String ERROR_CODE_DUPLICATE_BLOCK = "error_code_duplicate_block";
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IResourceValidator validator;

    @Check
    public void checkImportForValidity(FileImport imp) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((Resource)imp.eResource(), (URI)URI.createURI((String)imp.getImportURI()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Invalid resource", (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
        } else {
            Resource res = EcoreUtil2.getResource((Resource)imp.eResource(), (String)imp.getImportURI());
            if (res == null) {
                this.error("Invalid resource", (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
            } else {
                boolean _not_1;
                boolean _isEmpty = res.getErrors().isEmpty();
                boolean bl2 = _not_1 = !_isEmpty;
                if (_not_1) {
                    this.error("Resource contains errors", (EStructuralFeature)TypesPackage.Literals.FILE_IMPORT__IMPORT_URI);
                }
            }
        }
    }

    @Check
    public void checkUniqueTaskName(Project project) {
        HashSet<Task> duplicates = new HashSet<Task>();
        HashMap<String, Task> knownTasks = new HashMap<String, Task>();
        List tasks = EcoreUtil2.getAllContentsOfType((EObject)project, Task.class);
        for (Task task : tasks) {
            Task duplicate = knownTasks.put(task.getName(), task);
            if (duplicate == null) continue;
            duplicates.add(task);
            duplicates.add(duplicate);
        }
        Consumer<Task> _function = it -> this.error("Duplicate task name.", (EObject)it, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        duplicates.forEach(_function);
    }

    @Check
    public void checkBlocks(Project project) {
        HashSet<GeneratorBlock> duplicates = new HashSet<GeneratorBlock>();
        HashMap<String, GeneratorBlock> knownBlocks = new HashMap<String, GeneratorBlock>();
        EList<GeneratorBlock> _generatorBlocks = project.getGeneratorBlocks();
        for (GeneratorBlock block : _generatorBlocks) {
            GeneratorBlock duplicate;
            boolean _isEmpty = IteratorExtensions.isEmpty((Iterator)block.eAllContents());
            if (_isEmpty) {
                this.warning("This block contains no tasks or elements.", block, null, "warning_code_empty_block", new String[0]);
            }
            if ((duplicate = knownBlocks.put(block.eClass().getName(), block)) == null) continue;
            duplicates.add(block);
            duplicates.add(duplicate);
        }
        Consumer<GeneratorBlock> _function = it -> this.error("Duplicate block.", (EObject)it, null, "error_code_duplicate_block", new String[0]);
        duplicates.forEach(_function);
    }

    @Check
    public void checkDuplicatedTypeMappingsNames(Project prj) {
        List<TypeMappings> typeMappings = ProjectUtility.getTypeMappings(prj);
        for (TypeMappings tm1 : typeMappings) {
            for (TypeMappings tm2 : typeMappings) {
                if (Objects.equal((Object)tm1, (Object)tm2) || !tm1.getName().equals(tm2.getName())) continue;
                this.error("Duplicate name of type mappings", tm1, null);
            }
        }
    }

    @Check
    public void checkDuplicatedCommonMappings(TypeMappings mappings) {
        EList<TypeMapping> _commonMappings = mappings.getCommonMappings();
        for (TypeMapping m1 : _commonMappings) {
            EList<TypeMapping> _commonMappings_1 = mappings.getCommonMappings();
            for (TypeMapping m2 : _commonMappings_1) {
                if (Objects.equal((Object)m1, (Object)m2) || !Objects.equal((Object)m1.getType(), (Object)m2.getType())) continue;
                this.error("Duplicate type mapping", (EStructuralFeature)ProjectPackage.Literals.TYPE_MAPPINGS__COMMON_MAPPINGS, mappings.getCommonMappings().indexOf((Object)m1));
            }
        }
    }

    @Check
    public void checkDuplicatedInterfaceMappings(TypeMappings mappings) {
        EList<InterfaceMappings> _interfaceMappings = mappings.getInterfaceMappings();
        for (InterfaceMappings m1 : _interfaceMappings) {
            EList<InterfaceMappings> _interfaceMappings_1 = mappings.getInterfaceMappings();
            for (InterfaceMappings m2 : _interfaceMappings_1) {
                if (Objects.equal((Object)m1, (Object)m2) || !Objects.equal((Object)m1.getInterface(), (Object)m2.getInterface())) continue;
                this.error("Duplicate interface mapping", (EStructuralFeature)ProjectPackage.Literals.TYPE_MAPPINGS__INTERFACE_MAPPINGS, mappings.getInterfaceMappings().indexOf((Object)m1));
            }
        }
    }

    @Check
    public void checkDuplicatedTypesInInterfaceMappings(InterfaceMappings mapping) {
        EList<TypeMapping> _mappings = mapping.getMappings();
        for (TypeMapping m1 : _mappings) {
            EList<TypeMapping> _mappings_1 = mapping.getMappings();
            for (TypeMapping m2 : _mappings_1) {
                if (Objects.equal((Object)m1, (Object)m2) || !Objects.equal((Object)m1.getType(), (Object)m2.getType())) continue;
                this.error("Duplicate type mapping", (EStructuralFeature)ProjectPackage.Literals.INTERFACE_MAPPINGS__MAPPINGS, mapping.getMappings().indexOf((Object)m1));
            }
        }
    }

    @Check
    public void checkReachabilityGenerationTaskParameters(ReachabilityGraphGenerationTask task) {
        boolean _tripleNotEquals;
        String _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            this.checkParamsResource(task, task.getParams(), (EStructuralFeature)ProjectPackage.Literals.REACHABILITY_GRAPH_GENERATION_TASK__PARAMS, 0);
        }
    }

    @Check
    public void checkTestCasesGenerationTaskParameters(TestCasesGenerationTask task) {
        boolean _tripleNotEquals;
        String _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            this.checkParamsResource(task, task.getParams(), (EStructuralFeature)ProjectPackage.Literals.TEST_CASES_GENERATION_TASK__PARAMS, 0);
        }
    }

    @Check
    public void checkSimulatorGenerationTaskParameters(SimulatorGenerationTask task) {
        boolean _tripleNotEquals;
        EList<String> _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            EList<String> _params_1 = task.getParams();
            for (String param : _params_1) {
                this.checkParamsResource(task, param, (EStructuralFeature)ProjectPackage.Literals.SIMULATOR_GENERATION_TASK__PARAMS, task.getParams().indexOf((Object)param));
            }
        }
    }

    @Check
    public void checkReachabilityGraphGenerationTaskParameters(ReachabilityGraphGenerationTask task) {
        boolean _tripleNotEquals;
        String _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            this.checkParamsResource(task, task.getParams(), (EStructuralFeature)ProjectPackage.Literals.REACHABILITY_GRAPH_GENERATION_TASK__PARAMS, 0);
        }
    }

    @Check
    public void checkModelQualityChecksGenerationTaskParameters(ModelQualityChecksGenerationTask task) {
        boolean _tripleNotEquals;
        String _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            this.checkParamsResource(task, task.getParams(), (EStructuralFeature)ProjectPackage.Literals.MODEL_QUALITY_CHECKS_GENERATION_TASK__PARAMS, 0);
        }
    }

    @Check
    public void checkTestApplicationGenerationTaskParameters(TestApplicationGenerationTask task) {
        boolean _tripleNotEquals;
        EList<String> _params = task.getParams();
        boolean bl = _tripleNotEquals = _params != null;
        if (_tripleNotEquals) {
            EList<String> _params_1 = task.getParams();
            for (String param : _params_1) {
                this.checkParamsResource(task, param, (EStructuralFeature)ProjectPackage.Literals.TEST_APPLICATION_GENERATION_TASK__PARAMS, task.getParams().indexOf((Object)param));
            }
        }
    }

    public void checkParamsResource(EObject resource, String param, EStructuralFeature feature, int index) {
        Resource ipres = EcoreUtil2.getResource((Resource)resource.eResource(), (String)param);
        if (ipres == null || !(IterableExtensions.head((Iterable)ipres.getContents()) instanceof Parameters)) {
            this.error("Invalid resource", feature, index);
        } else {
            boolean _not;
            Functions.Function1 _function = issue -> {
                Severity _severity = issue.getSeverity();
                return Objects.equal((Object)_severity, (Object)Severity.ERROR);
            };
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)this.validator.validate(ipres, CheckMode.ALL, null), (Functions.Function1)_function));
            boolean bl = _not = !_isEmpty;
            if (_not) {
                this.error("Errors found in .params file", feature, index);
            }
        }
    }

    @Check
    public void checkHomeStates(ModelQualityChecksGenerationTask task) {
        boolean _tripleNotEquals;
        EList<HomeStateSet> _homeStateSets = task.getHomeStateSets();
        boolean bl = _tripleNotEquals = _homeStateSets != null;
        if (_tripleNotEquals) {
            Consumer<HomeStateSet> _function = set -> {
                boolean _not;
                Functions.Function1 _function_1 = m -> m.getName();
                Set missingMachines = IterableExtensions.toSet((Iterable)ListExtensions.map((List)task.getTarget().getInterface().getMachines(), (Functions.Function1)_function_1));
                ArrayList machines = new ArrayList();
                Consumer<HomeState> _function_2 = state -> {
                    EObject _eContainer = state.getHs().eContainer();
                    String name = ((StateMachine)_eContainer).getName();
                    boolean _contains = machines.contains(name);
                    if (_contains) {
                        String error = String.format("Home state set contains multiple states from machine %s", String.join((CharSequence)", ", name));
                        this.error(error, (EObject)state, (EStructuralFeature)ProjectPackage.Literals.HOME_STATE__HS);
                    }
                    machines.add(name);
                    missingMachines.remove(name);
                };
                set.getStates().forEach(_function_2);
                boolean _isEmpty = missingMachines.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    String error = String.format("Home state set is missing state from machine(s): %s", String.join((CharSequence)", ", missingMachines));
                    this.error(error, (EObject)set, (EStructuralFeature)ProjectPackage.Literals.HOME_STATE_SET__STATES);
                }
            };
            task.getHomeStateSets().forEach(_function);
        }
    }

    @Check
    public void checkReachabilityGenerationTaskMissingParameters(ReachabilityGraphGenerationTask task) {
        InterfaceReference _target = task.getTarget();
        List<String> _xifexpression = null;
        String _params = task.getParams();
        boolean _tripleNotEquals = _params != null;
        _xifexpression = _tripleNotEquals ? Arrays.asList(task.getParams()) : null;
        this.checkParametersMissing(_target, _xifexpression, task, false);
    }

    @Check
    public void checkTestCasesGenerationTaskMissingParameters(TestCasesGenerationTask task) {
        InterfaceReference _target = task.getTarget();
        List<String> _xifexpression = null;
        String _params = task.getParams();
        boolean _tripleNotEquals = _params != null;
        _xifexpression = _tripleNotEquals ? Arrays.asList(task.getParams()) : null;
        this.checkParametersMissing(_target, _xifexpression, task, false);
    }

    @Check
    public void checkTestCasesGenerationTaskMissingTemplate(TestCasesGenerationTask task) {
        File projectFile = ProjectUtility.uriToFile(task.eResource().getURI());
        if (task.getTemplate() != null && TestCasesGenerator.getTemplate((File)projectFile, (String)task.getTemplate()) == null) {
            String error = String.format("Template file '%s' does not exist", task.getTemplate());
            this.error(error, task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        }
    }

    @Check
    public void checkTestApplicationGenerationTaskMissingParameters(TestApplicationGenerationTask task) {
        this.checkParametersMissing(task.getTarget(), (List<String>)task.getParams(), task, true);
    }

    @Check
    public void checkSimulatorGenerationTaskMissingParameters(SimulatorGenerationTask task) {
        this.checkParametersMissing(task.getTarget(), (List<String>)task.getParams(), task, true);
    }

    @Check
    public void checkModelQualityChecksGenerationTaskMissingParameters(ModelQualityChecksGenerationTask task) {
        InterfaceReference _target = task.getTarget();
        List<String> _xifexpression = null;
        String _params = task.getParams();
        boolean _tripleNotEquals = _params != null;
        _xifexpression = _tripleNotEquals ? Arrays.asList(task.getParams()) : null;
        this.checkParametersMissing(_target, _xifexpression, task, false);
    }

    public void checkParametersMissing(Object target, List<String> params, EObject task, boolean requiredPorts) {
        boolean _isEmpty;
        boolean _not;
        ArrayList<Interface> interfaces = new ArrayList<Interface>();
        if (target instanceof InterfaceReference) {
            interfaces.add(((InterfaceReference)target).getInterface());
        } else if (target instanceof ComponentReference) {
            Component comp = ((ComponentReference)target).getComponent();
            List compInterfaces = ComponentUtilities.getAllInterfaces((EObject)comp, (IScopeProvider)this.scopeProvider);
            Consumer<Port> _function = p -> {
                if (p instanceof ProvidedPort || requiredPorts) {
                    Functions.Function1 _function_1 = i -> i.getName().equals(p.getInterface().getName());
                    Interface itf = (Interface)IterableExtensions.findFirst((Iterable)compInterfaces, (Functions.Function1)_function_1);
                    interfaces.add(itf);
                }
            };
            comp.getPorts().forEach(_function);
        }
        Functions.Function1 _function_1 = itf -> this.hasOpenEvents((Interface)itf);
        List missing = IterableExtensions.toList((Iterable)IterableExtensions.filter(interfaces, (Functions.Function1)_function_1));
        Functions.Function1 _function_2 = i -> i.getName();
        List missingByName = IterableExtensions.toList((Iterable)ListExtensions.map(new ArrayList(missing), (Functions.Function1)_function_2));
        if (params != null) {
            for (String file : params) {
                Resource param = EcoreUtil2.getResource((Resource)task.eResource(), (String)file);
                if (param == null || !(IterableExtensions.head((Iterable)param.getContents()) instanceof Parameters)) continue;
                EObject _head = (EObject)IterableExtensions.head((Iterable)param.getContents());
                Parameters p2 = (Parameters)_head;
                missing.remove(p2.getInterface());
                missingByName.remove(p2.getInterface().getName());
            }
        }
        boolean bl = _not = !(_isEmpty = missingByName.isEmpty());
        if (_not) {
            String error = String.format("Missing parameters for %s", String.join((CharSequence)", ", missingByName));
            this.error(error, task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        } else {
            boolean _not_1;
            boolean _isEmpty_1 = missing.isEmpty();
            boolean bl2 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                Functions.Function1 _function_3 = i -> i.getName();
                String error_1 = String.format("Provided parameters for %s are for different .interface", String.join((CharSequence)", ", ListExtensions.map((List)missing, (Functions.Function1)_function_3)));
                this.error(error_1, task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
            }
        }
    }

    public boolean hasOpenEvents(Interface itf) {
        Functions.Function1 _function = it -> it.getStates();
        Functions.Function1 _function_1 = s -> !StateMachineUtilities.getAllOpenTriggers((State)s).isEmpty() || !StateMachineUtilities.getAllOpenNotifications((State)s).isEmpty() || !StateMachineUtilities.getAllCommandsWithOpenReply((State)s).isEmpty();
        return IterableExtensions.exists((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)itf.getMachines(), (Functions.Function1)_function)), (Functions.Function1)_function_1);
    }

    @Check
    public void checkMonitoringTask(MonitoringTask task) {
        this.validateTraceSources((List<TraceSource>)task.getTraces());
        this.validateDirectories((List<FilePath>)task.getTracedirs(), task);
    }

    public void validateTraceSources(List<TraceSource> sources) {
        Functions.Function1 _function = s -> {
            String _path = s.getPath();
            return _path != null;
        };
        List filteredSources = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.filter(sources, FilePath.class), (Functions.Function1)_function));
        ProjectUtility.TraceResources resources = ProjectUtility.getTraceResourcesFromFiles(filteredSources);
        for (FilePath invalid : resources.invalidTraceSources) {
            this.error("Invalid resource", invalid, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        for (FilePath wrongNamed : resources.wrongnamedTraceSources) {
            this.error("Trace file name must start with a letter and may contain letters, digits and _", wrongNamed, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        for (FilePath duplicate : resources.duplicateTraceSources) {
            this.error("File with the same name is already used", duplicate, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
    }

    @Check
    public void checkDuplicatedInterfaces(CompoundInterface compInterface) {
        EList<InterfaceModel> _interfaces = compInterface.getInterfaces();
        for (InterfaceModel i1 : _interfaces) {
            EList<InterfaceModel> _interfaces_1 = compInterface.getInterfaces();
            for (InterfaceModel i2 : _interfaces_1) {
                if (Objects.equal((Object)i1, (Object)i2) || !Objects.equal((Object)i1.getInterfaceModel(), (Object)i2.getInterfaceModel())) continue;
                this.error("Duplicate interface", i1, null);
            }
        }
    }

    @Check
    public void checkCompoundName(CompoundInterface compound) {
        List _allInterfaces = ComponentUtilities.getAllInterfaces((EObject)compound, (IScopeProvider)this.scopeProvider);
        for (Interface interface_ : _allInterfaces) {
            boolean _equals = interface_.getName().equals(compound.getName());
            if (!_equals) continue;
            this.error("Compound interface names are not allowed to be equal to an imported interface.", (EStructuralFeature)ProjectPackage.Literals.COMPOUND_INTERFACE__NAME);
        }
    }

    public void validateDirectories(List<FilePath> filePaths, Task task) {
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        ProjectUtility.TraceResources resources = ProjectUtility.getTraceResourcesFromDirs(filePaths);
        for (FilePath dir : resources.nonexistentDirectories) {
            this.error("Directory does not exist", dir, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        for (FilePath dir_1 : resources.duplicateDirectories) {
            this.error("Directory is already listed", dir_1, (EStructuralFeature)ProjectPackage.Literals.FILE_PATH__PATH);
        }
        boolean _isEmpty = resources.duplicateTraceFiles.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            this.error("Trace directories contain files with duplicate names", task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = resources.wrongnamedTraceFiles.isEmpty());
        if (_not_1) {
            this.error("Trace directories contain files with wrong names", task, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        }
    }

    @Check
    public void validateDocGenerationTask(DocumentationGenerationTask task) {
        boolean _not;
        boolean _isValidUri = EcoreUtil2.isValidUri((Resource)task.eResource(), (URI)URI.createURI((String)task.getTemplate()));
        boolean bl = _not = !_isValidUri;
        if (_not) {
            this.error("Template not found", (EStructuralFeature)ProjectPackage.Literals.DOCUMENTATION_GENERATION_TASK__TEMPLATE);
        }
    }

    @Check
    public void checkDuplications(ProjectDescription prj) {
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)prj.getImports(), NamespaceImport.class));
        if (_isEmpty) {
            return;
        }
        Multimap multiMap = this.getGlobalDeclarations((EObject)prj, TypesPackage.eINSTANCE.getTypeDecl());
        this.placePredefinedTypes(multiMap);
        Set _entrySet = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry.getKey()).toString();
            String _plus = "Duplicate imported type " + _string;
            this.error(_plus, prj.getProject(), (EStructuralFeature)ProjectPackage.Literals.PROJECT__NAME);
        }
        multiMap = this.getGlobalDeclarations((EObject)prj, InterfaceDefinitionPackage.Literals.INTERFACE);
        Set _entrySet_1 = multiMap.asMap().entrySet();
        for (Map.Entry entry : _entrySet_1) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry.getKey()).toString();
            String _plus = "Duplicate imported interface " + _string;
            this.error(_plus, prj.getProject(), (EStructuralFeature)ProjectPackage.Literals.PROJECT__NAME);
        }
        multiMap = this.getGlobalDeclarations((EObject)prj, ComponentPackage.Literals.COMPONENT);
        Set set = multiMap.asMap().entrySet();
        for (Map.Entry entry_2 : set) {
            boolean _greaterThan;
            Collection duplicates = (Collection)entry_2.getValue();
            int _size = duplicates.size();
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            String _string = ((QualifiedName)entry_2.getKey()).toString();
            String _plus = "Duplicate imported component " + _string;
            this.error(_plus, prj.getProject(), (EStructuralFeature)ProjectPackage.Literals.PROJECT__NAME);
        }
    }

    @Check
    public void checkClientEnvironment(TestApplicationGenerationTask task) {
        ExecutableSource _target = task.getTarget();
        if (_target instanceof ComponentReference) {
            boolean _not;
            boolean _isEmpty = task.getEnvComponents().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                ExecutableSource _target_1 = task.getTarget();
                this.checkClientEnvironment((List<EnvironmentComponent>)task.getEnvComponents(), ((ComponentReference)_target_1).getComponent());
            }
        }
        if (task.getTarget() instanceof InterfaceReference && !task.getEnvComponents().isEmpty()) {
            this.warning("Component environment is not applicable to interface testing. It will be ignored", (EStructuralFeature)ProjectPackage.Literals.TEST_APPLICATION_GENERATION_TASK__ENV_COMPONENTS);
        }
    }

    @Check
    public void checkClientEnvironment(SimulatorGenerationTask task) {
        ExecutableSource _target = task.getTarget();
        if (_target instanceof ComponentReference) {
            boolean _not;
            boolean _isEmpty = task.getEnvComponents().isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                ExecutableSource _target_1 = task.getTarget();
                this.checkClientEnvironment((List<EnvironmentComponent>)task.getEnvComponents(), ((ComponentReference)_target_1).getComponent());
            }
        }
        if (task.getTarget() instanceof InterfaceReference && !task.getEnvComponents().isEmpty()) {
            this.warning("Component environment is not applicable to interface simulator. It will be ignored", (EStructuralFeature)ProjectPackage.Literals.SIMULATOR_GENERATION_TASK__ENV_COMPONENTS);
        }
    }

    public void checkClientEnvironment(List<EnvironmentComponent> envComponents, Component component) {
        HashSet<String> components = new HashSet<String>();
        for (EnvironmentComponent envComponent : envComponents) {
            boolean _not;
            String _role = envComponent.getRole();
            String _id = envComponent.getId();
            String _plus = String.valueOf(_role) + _id;
            boolean _add = components.add(_plus);
            boolean bl = _not = !_add;
            if (_not) {
                this.error("Component is already defined", envComponent, (EStructuralFeature)ProjectPackage.Literals.ENVIRONMENT_COMPONENT__ID);
            }
            HashSet<String> ports = new HashSet<String>();
            EList<PortSpec> _portSpecs = envComponent.getPortSpecs();
            for (PortSpec portSpec : _portSpecs) {
                boolean _not_3;
                boolean _not_2;
                String _paramFile;
                boolean _tripleNotEquals_1;
                boolean _tripleNotEquals;
                Port _port = portSpec.getPort();
                boolean bl2 = _tripleNotEquals = _port != null;
                if (_tripleNotEquals) {
                    boolean _not_1;
                    boolean _add_1 = ports.add(portSpec.getPort().getName());
                    boolean bl3 = _not_1 = !_add_1;
                    if (_not_1) {
                        this.error("Port is already used", portSpec, (EStructuralFeature)ProjectPackage.Literals.PORT_SPEC__PORT);
                    }
                }
                if (envComponent.getRole().equals("client") && portSpec.getPort() instanceof RequiredPort) {
                    this.error("Clients can not be defined for required ports", portSpec, (EStructuralFeature)ProjectPackage.Literals.PORT_SPEC__PORT);
                }
                if (envComponent.getRole().equals("server") && portSpec.getPort() instanceof ProvidedPort) {
                    this.error("Servers can not be defined for provided ports", portSpec, (EStructuralFeature)ProjectPackage.Literals.PORT_SPEC__PORT);
                }
                boolean bl4 = _tripleNotEquals_1 = (_paramFile = portSpec.getParamFile()) != null;
                if (!_tripleNotEquals_1) continue;
                Resource ipres = EcoreUtil2.getResource((Resource)portSpec.eResource(), (String)portSpec.getParamFile());
                if (ipres == null || !(IterableExtensions.head((Iterable)ipres.getContents()) instanceof Parameters)) {
                    this.error("Invalid resource", portSpec, (EStructuralFeature)ProjectPackage.Literals.PORT_SPEC__PARAM_FILE);
                    continue;
                }
                Functions.Function1 _function = issue -> {
                    Severity _severity = issue.getSeverity();
                    return Objects.equal((Object)_severity, (Object)Severity.ERROR);
                };
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)this.validator.validate(ipres, CheckMode.ALL, null), (Functions.Function1)_function));
                boolean bl5 = _not_2 = !_isEmpty;
                if (_not_2) {
                    this.error("Errors found in .params file", portSpec, (EStructuralFeature)ProjectPackage.Literals.PORT_SPEC__PARAM_FILE);
                    continue;
                }
                EObject _head = (EObject)IterableExtensions.head((Iterable)ipres.getContents());
                boolean _equals = ((Parameters)_head).getInterface().getName().equals(portSpec.getPort().getInterface().getName());
                boolean bl6 = _not_3 = !_equals;
                if (!_not_3) continue;
                this.error(".params file and the port have different interfaces", portSpec, (EStructuralFeature)ProjectPackage.Literals.PORT_SPEC__PARAM_FILE);
            }
        }
    }

    @Check
    public void checkRESTTask(RESTTask task) {
        List<Signature> signatures = ProjectUtility.getSignaturesForRESTTask(task, this.scopeProvider);
        ArrayList<String> messages = new ArrayList<String>();
        for (Signature sig : signatures) {
            messages.addAll(this.checkSignatureCommandsForREST(sig));
        }
        for (String errorMsg : messages) {
            this.error(errorMsg, (EStructuralFeature)ProjectPackage.Literals.TASK__NAME);
        }
    }

    public List<String> checkSignatureCommandsForREST(Signature sig) {
        ArrayList<String> _xblockexpression = null;
        ArrayList<String> result = new ArrayList<String>();
        EList _commands = sig.getCommands();
        for (Command command : _commands) {
            boolean _not;
            Functions.Function1 _function = it -> {
                DIRECTION _direction = it.getDirection();
                return Objects.equal((Object)_direction, (Object)DIRECTION.INOUT);
            };
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)command.getParameters(), (Functions.Function1)_function));
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            String _name = command.getName();
            String _plus = "Command " + _name;
            String _plus_1 = String.valueOf(_plus) + " in signature ";
            String _name_1 = sig.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + " has INOUT parameters";
            result.add(_plus_3);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    @Check
    public void checkDuplicatedPathMappingsNames(Project prj) {
        List<PathMappings> pathMappings = ProjectUtility.getPathMappings(prj);
        for (PathMappings pm1 : pathMappings) {
            for (PathMappings pm2 : pathMappings) {
                if (Objects.equal((Object)pm1, (Object)pm2) || !pm1.getName().equals(pm2.getName())) continue;
                this.error("Duplicate name of type mappings", pm1, null);
            }
        }
    }

    @Check
    public void checkDuplicateSignatureMappings(PathMappings pm) {
        EList<SignatureMapping> _signatureMappings = pm.getSignatureMappings();
        for (SignatureMapping sm1 : _signatureMappings) {
            EList<SignatureMapping> _signatureMappings_1 = pm.getSignatureMappings();
            for (SignatureMapping sm2 : _signatureMappings_1) {
                if (Objects.equal((Object)sm1, (Object)sm2) || !Objects.equal((Object)sm1.getSignature(), (Object)sm2.getSignature())) continue;
                this.error("Mapping for this signature is already defined", sm2, null);
            }
        }
    }

    @Check
    public void checkDuplicateEventMapping(SignatureMapping sm) {
        EList<EventMapping> _eventMappings = sm.getEventMappings();
        for (EventMapping em1 : _eventMappings) {
            EList<EventMapping> _eventMappings_1 = sm.getEventMappings();
            for (EventMapping em2 : _eventMappings_1) {
                if (Objects.equal((Object)em1, (Object)em2) || !Objects.equal((Object)em1.getEvent(), (Object)em2.getEvent())) continue;
                this.error("Mapping for this event is already given", em2, null);
            }
        }
    }

    @Check
    public void checkDuplicateParameterSegment(Path p) {
        ArrayList paramSegments = new ArrayList();
        Consumer<Segment> _function = it -> {
            if (it instanceof ParameterSegment) {
                paramSegments.add((ParameterSegment)it);
            }
        };
        p.getSegments().forEach(_function);
        for (ParameterSegment s1 : paramSegments) {
            for (ParameterSegment s2 : paramSegments) {
                if (Objects.equal((Object)s1, (Object)s2) || !Objects.equal((Object)s1.getParameter(), (Object)s2.getParameter())) continue;
                this.error("Parameter already used", s2, null);
            }
        }
    }

    @Check
    public void checkSignatureMappingForCompleteness(SignatureMapping sm) {
        List _allInterfaceEvents = InterfaceUtilities.getAllInterfaceEvents((Signature)sm.getSignature());
        for (InterfaceEvent ev : _allInterfaceEvents) {
            if (ev instanceof Notification || IterableExtensions.exists(sm.getEventMappings(), it -> {
                InterfaceEvent _event = it.getEvent();
                return Objects.equal((Object)_event, (Object)ev);
            })) continue;
            String _name = ev.getName();
            String _plus = "Event " + _name;
            String _plus_1 = String.valueOf(_plus) + " does not have path mapping";
            this.error(_plus_1, sm, (EStructuralFeature)ProjectPackage.Literals.SIGNATURE_MAPPING__SIGNATURE);
        }
    }

    @Check
    public void checkPathMappings(RESTTask task) {
        List<Signature> _signaturesForRESTTask = ProjectUtility.getSignaturesForRESTTask(task, this.scopeProvider);
        for (Signature sig : _signaturesForRESTTask) {
            boolean _not;
            Functions.Function1 _function = it -> {
                Signature _signature = it.getSignature();
                return Objects.equal((Object)_signature, (Object)sig);
            };
            boolean _exists = IterableExtensions.exists(task.getPathMappings().getSignatureMappings(), (Functions.Function1)_function);
            boolean bl = _not = !_exists;
            if (!_not) continue;
            String _name = sig.getName();
            String _plus = "Missing path mappings for signature " + _name;
            this.error(_plus, task, (EStructuralFeature)ProjectPackage.Literals.REST_TASK__PATH_MAPPINGS);
        }
    }

    @Check
    public void checkOperationOfEventMapping(EventMapping em) {
        InterfaceEvent _event_1;
        InterfaceEvent _event = em.getEvent();
        if (_event instanceof Signal) {
            boolean _notEquals;
            RESTOperation _restOperation = em.getRestOperation();
            boolean bl = _notEquals = !Objects.equal((Object)((Object)_restOperation), (Object)((Object)RESTOperation.PUT));
            if (_notEquals) {
                this.error("Signals have to be mapped to PUT operation", em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__REST_OPERATION);
            }
        }
        if ((_event_1 = em.getEvent()) instanceof Command) {
            RESTOperation _restOperation_1;
            boolean _equals;
            if (Objects.equal((Object)((Object)em.getRestOperation()), (Object)((Object)RESTOperation.PUT)) && !IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)em.getEvent().getParameters(), it -> {
                DIRECTION _direction = it.getDirection();
                return Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
            }))) {
                this.error("Commands mapped to PUT cannot have out parameters", em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__REST_OPERATION);
            }
            if (_equals = Objects.equal((Object)((Object)(_restOperation_1 = em.getRestOperation())), (Object)((Object)RESTOperation.DELETE))) {
                boolean _not;
                Functions.Function1 _function = it -> {
                    DIRECTION _direction = it.getDirection();
                    return !Objects.equal((Object)_direction, (Object)DIRECTION.IN);
                };
                boolean _isEmpty = IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)em.getEvent().getParameters(), (Functions.Function1)_function));
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    this.error("Commands mapped to DELETE have to have only IN parameters", em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__REST_OPERATION);
                }
            }
        }
    }

    @Check
    public void checkCommandPathMapping(EventMapping em) {
        if (!(!(em.getEvent() instanceof Command) || Objects.equal((Object)((Object)em.getRestOperation()), (Object)((Object)RESTOperation.PUT)) || TypeUtilities.isVoid((Type)((Command)em.getEvent()).getType()) && IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)em.getEvent().getParameters(), it -> {
            DIRECTION _direction = it.getDirection();
            return Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
        })))) {
            ArrayList paramSegments = new ArrayList();
            Consumer<Segment> _function = it -> {
                if (it instanceof ParameterSegment) {
                    paramSegments.add((ParameterSegment)it);
                }
            };
            em.getPath().getSegments().forEach(_function);
            Functions.Function1 _function_1 = it -> {
                DIRECTION _direction = it.getDirection();
                return Objects.equal((Object)_direction, (Object)DIRECTION.IN);
            };
            Iterable _filter = IterableExtensions.filter((Iterable)em.getEvent().getParameters(), (Functions.Function1)_function_1);
            for (Parameter p : _filter) {
                boolean _not;
                Functions.Function1 _function_2 = it -> {
                    Parameter _parameter = it.getParameter();
                    return Objects.equal((Object)p, (Object)_parameter);
                };
                boolean _exists = IterableExtensions.exists(paramSegments, (Functions.Function1)_function_2);
                boolean bl = _not = !_exists;
                if (!_not) continue;
                String _name = p.getName();
                String _plus = "Input parameter " + _name;
                String _plus_1 = String.valueOf(_plus) + " is not part of the path";
                this.error(_plus_1, em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__PATH);
            }
        }
    }

    @Check
    public void checkCommandReturnType(EventMapping em) {
        boolean _not;
        InterfaceEvent _event = em.getEvent();
        boolean bl = _not = !(_event instanceof Command);
        if (_not) {
            return;
        }
        InterfaceEvent _event_1 = em.getEvent();
        Command command = (Command)_event_1;
        if (command.getType() instanceof TypeReference && ((TypeReference)command.getType()).getType() instanceof RecordTypeDecl) {
            Type _type = command.getType();
            TypeDecl _type_1 = ((TypeReference)_type).getType();
            RecordTypeDecl returnType = (RecordTypeDecl)_type_1;
            List fields = TypeUtilities.getAllFields((RecordTypeDecl)returnType);
            boolean _isEmpty = fields.isEmpty();
            if (_isEmpty) {
                this.error("Empty record as return type", em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__EVENT);
                return;
            }
            TypeObject _typeObject = TypeUtilities.getTypeObject((Type)((RecordField)fields.get(0)).getType());
            if (_typeObject instanceof EnumTypeDecl) {
                boolean _lessThan;
                TypeObject _typeObject_1 = TypeUtilities.getTypeObject((Type)((RecordField)fields.get(0)).getType());
                EnumTypeDecl enumType = (EnumTypeDecl)_typeObject_1;
                EList _literals = enumType.getLiterals();
                for (EnumElement literal : _literals) {
                    if (literal.getValue() != null && literal.getValue().getValue() >= 100) continue;
                    this.error("Enum literals in the first field of return type have to indicate HTTP response codes", em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__EVENT);
                    return;
                }
                int _length = ((Object[])Conversions.unwrapArray((Object)fields, Object.class)).length;
                boolean bl2 = _lessThan = _length < 2;
                if (_lessThan) {
                    return;
                }
                int _length_1 = ((Object[])Conversions.unwrapArray((Object)fields, Object.class)).length;
                int _minus = _length_1 - 1;
                IntegerRange _upTo = new IntegerRange(1, _minus);
                for (Integer index : _upTo) {
                    boolean _startsWith;
                    boolean _lessThan_1;
                    String comment = SLCommentLocator.getSLComment((EObject)((EObject)fields.get(index))).trim();
                    int _length_2 = comment.length();
                    boolean bl3 = _lessThan_1 = _length_2 < 3;
                    if (_lessThan_1) {
                        String _name = ((RecordField)fields.get(index)).getName();
                        String _plus = "Field " + _name;
                        String _plus_1 = String.valueOf(_plus) + " does not indicate correct HTTP response code";
                        this.error(_plus_1, em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__EVENT);
                    }
                    if (_startsWith = comment.startsWith("204")) {
                        this.error("Response code 204 (No content) cannot be used", em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__EVENT);
                    }
                    try {
                        int code = Integer.parseInt(comment.substring(0, 3));
                        if (code >= 100 && code <= 599) continue;
                        String _name_1 = ((RecordField)fields.get(index)).getName();
                        String _plus_2 = "Field " + _name_1;
                        String _plus_3 = String.valueOf(_plus_2) + " does not indicate correct HTTP response code";
                        this.error(_plus_3, em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__EVENT);
                    }
                    catch (Throwable _t) {
                        if (_t instanceof Exception) {
                            String _name_2 = ((RecordField)fields.get(index)).getName();
                            String _plus_4 = "Field " + _name_2;
                            String _plus_5 = String.valueOf(_plus_4) + " does not indicate correct HTTP response code";
                            this.error(_plus_5, em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__EVENT);
                            continue;
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
            } else {
                this.error("The first record field must be enumeration that encodes HTTP response codes", em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__EVENT);
            }
        } else {
            this.error("Return type of command must be a record type following response encoding rules", em, (EStructuralFeature)ProjectPackage.Literals.EVENT_MAPPING__EVENT);
        }
    }

    @Check
    public void checkRestTask(RESTTask task) {
        if (!task.getRestServerURL().startsWith("http://") && !task.getRestServerURL().startsWith("https://")) {
            this.error("URL has to start with http:// or https://", (EStructuralFeature)ProjectPackage.Literals.REST_TASK__REST_SERVER_URL);
        }
    }

    @Check
    public void checkInterfaceVersion(RESTTask task) {
        boolean _tripleNotEquals;
        Interface _sourceInterface = task.getSourceInterface();
        boolean bl = _tripleNotEquals = _sourceInterface != null;
        if (_tripleNotEquals) {
            boolean _tripleEquals;
            String _version = task.getSourceInterface().getVersion();
            boolean bl2 = _tripleEquals = _version == null;
            if (_tripleEquals) {
                this.error("Source interface has to have version", (EStructuralFeature)ProjectPackage.Literals.REST_TASK__SOURCE_INTERFACE);
            }
        }
    }

    @Check
    public void checkInterfacesAssignedToAdapters(TestApplicationGenerationTask task) {
        HashSet<String> interfaces = new HashSet<String>();
        EList<AdapterInterfacePairs> _adapterInterfacePairs = task.getAdapterInterfacePairs();
        for (AdapterInterfacePairs p : _adapterInterfacePairs) {
            EList<Interface> _interfaces = p.getInterfaces();
            for (Interface i : _interfaces) {
                boolean _not;
                boolean _add = interfaces.add(i.getName());
                boolean bl = _not = !_add;
                if (!_not) continue;
                String _name = i.getName();
                String _plus = "Interface " + _name;
                String _plus_1 = String.valueOf(_plus) + " used multiple times";
                this.error(_plus_1, (EStructuralFeature)ProjectPackage.Literals.TEST_APPLICATION_GENERATION_TASK__ADAPTER_INTERFACE_PAIRS);
            }
        }
    }
}

