/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ecore.impl;

import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.enablement.oda.ecore.impl.DataTypes;

public class ResultSetMetaData
implements IResultSetMetaData {
    private final ColumnDefinition[] columns;

    public ResultSetMetaData(ColumnDefinition[] columns) {
        this.columns = columns;
    }

    public int getColumnCount() throws OdaException {
        return this.columns.length;
    }

    public String getColumnName(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columns[index - 1].getAttributes().getName();
    }

    public String getColumnLabel(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columns[index - 1].getAttributes().getUiHints().getDisplayName();
    }

    public int getColumnType(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columns[index - 1].getAttributes().getNativeDataTypeCode();
    }

    public String getColumnTypeName(int index) throws OdaException {
        this.validateColumnIndex(index);
        return DataTypes.getNativeType(this.columns[index - 1].getAttributes().getNativeDataTypeCode());
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columns[index - 1].getUsageHints().getFormattingHints().getDisplaySize();
    }

    public int getPrecision(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columns[index - 1].getAttributes().getPrecision();
    }

    public int getScale(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columns[index - 1].getAttributes().getScale();
    }

    public int isNullable(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columns[index - 1].getAttributes().getNullability().getValue();
    }

    private void validateColumnIndex(int index) throws OdaException {
        if (index > this.getColumnCount() || index < 1) {
            throw new OdaException("Invalid column index");
        }
    }
}

