/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.ecore.ui.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.enablement.oda.ecore.impl.Driver;
import org.eclipse.datatools.enablement.oda.ecore.ui.Activator;
import org.eclipse.datatools.enablement.oda.ecore.ui.i18n.Messages;
import org.eclipse.datatools.enablement.oda.ecore.ui.impl.EcoreUtil;
import org.eclipse.datatools.enablement.oda.ecore.ui.sourceviewer.DefaultSourceViewer;
import org.eclipse.datatools.enablement.oda.ecore.ui.sourceviewer.IOCLSourceViewer;
import org.eclipse.datatools.enablement.oda.ecore.ui.util.PropertiesUtil;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class DataSetQueryWizardPage
extends DataSetWizardPage {
    private transient ComboViewer contextCombo;
    private transient IOCLSourceViewer syntaxViewer;
    private Properties dataSourceProperties;
    private StyledText queryText;

    public DataSetQueryWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(Messages.getString("DataSetQueryWizardPage.message.default"));
        this.setPageComplete(false);
    }

    public DataSetQueryWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setTitle(pageName);
        this.setMessage(Messages.getString("DataSetQueryWizardPage.message.default"));
        this.setPageComplete(false);
    }

    public void createPageCustomControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().hint(-1, 100).align(4, 4).applyTo((Control)composite);
        Label fieldLabel = new Label(composite, 0);
        fieldLabel.setText(Messages.getString("DataSetQueryWizardPage.label.invariant"));
        this.contextCombo = new ComboViewer(composite, 0);
        this.contextCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataSetQueryWizardPage.this.validateData();
                IStructuredSelection eventSelection = (IStructuredSelection)event.getSelection();
                DataSetQueryWizardPage.this.setInvariantToSelection(DataSetQueryWizardPage.this.getEditingDesign(), eventSelection);
            }
        });
        Label queryLabel = new Label(composite, 0);
        queryLabel.setText(Messages.getString("DataSetQueryWizardPage.label.query"));
        this.syntaxViewer = this.createSyntaxViewer(composite);
        SourceViewer viewer = this.syntaxViewer.getSourceViewer();
        GridDataFactory.fillDefaults().grab(true, true).applyTo(viewer.getControl());
        this.queryText = viewer.getTextWidget();
        this.queryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataSetQueryWizardPage.this.validateData();
            }
        });
        this.queryText.addKeyListener((KeyListener)new InputKeyListener(viewer));
        this.setControl((Control)composite);
        this.initializeControl();
        GridLayoutFactory.fillDefaults().margins(4, 4).generateLayout(composite);
    }

    private IOCLSourceViewer createSyntaxViewer(Composite composite) {
        IOCLSourceViewer sourceViewer = null;
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.datatools.enablement.oda.ecore.ui.OCLSyntaxViewer");
        int i = 0;
        while (i < configurationElements.length) {
            IConfigurationElement element = configurationElements[i];
            if (element.getName().equalsIgnoreCase("oclSourceViewer")) {
                try {
                    sourceViewer = (IOCLSourceViewer)element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    throw new RuntimeException("Unable to create the extension", e);
                }
                if (!(sourceViewer instanceof DefaultSourceViewer)) break;
            }
            ++i;
        }
        sourceViewer.createExpressionControl(composite);
        return sourceViewer;
    }

    private void initializeControl() {
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        this.dataSourceProperties = DesignUtil.convertDataSourceProperties((DataSourceDesign)dataSetDesign.getDataSourceDesign());
        try {
            EPackage ePackage = EcoreUtil.getPackageForModel(this.dataSourceProperties);
            if (ePackage != null) {
                this.fillContextCombo(dataSetDesign, ePackage);
                this.syntaxViewer.setExpression(dataSetDesign.getQueryText());
            }
            this.validateData();
        }
        catch (WrappedException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                this.setMessage(e.getMessage(), 3);
            } else {
                this.setMessage(String.valueOf(Messages.getString("DataSetQueryWizardPage.message.loadError")) + cause.getMessage(), 3);
            }
        }
        catch (OdaException odaException) {
            this.setMessage(Messages.getString("DataSetQueryWizardPage.message.noEPackage"), 3);
        }
    }

    private void fillContextCombo(DataSetDesign dataSetDesign, EPackage ePackage) {
        this.contextCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.contextCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((EClassifier)element).getName();
            }
        });
        this.contextCombo.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((EClassifier)e1).getName().compareTo(((EClassifier)e2).getName());
            }
        });
        LinkedList<EClass> classes = new LinkedList<EClass>((Collection<EClass>)ePackage.getEClassifiers());
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof EClass) continue;
            iter.remove();
        }
        EClass dummy = EcoreFactory.eINSTANCE.createEClass();
        dummy.setName("");
        classes.add(dummy);
        this.contextCombo.setInput(classes);
        this.initializeContextCombo(this.getEditingDesign(), ePackage);
    }

    private void initializeContextCombo(DataSetDesign dataSetDesign, EPackage ePackage) {
        if (dataSetDesign.getPrivateProperties() != null) {
            String invariant = dataSetDesign.getPrivateProperties().getProperty("OCL_ECORE_INVARIANT");
            if (invariant == null || invariant.length() == 0 || ePackage.getEClassifier(invariant) == null) {
                return;
            }
            EClassifier invariantEClass = ePackage.getEClassifier(invariant);
            this.contextCombo.setSelection((ISelection)new StructuredSelection((Object)invariantEClass));
        }
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.syntaxViewer == null || this.queryText == null) {
            return design;
        }
        this.savePage(design);
        return design;
    }

    protected boolean canLeave() {
        return this.isPageComplete();
    }

    private void setInvariantToSelection(DataSetDesign dataSetDesign, IStructuredSelection selection) {
        Object selectedElement = selection.getFirstElement();
        if (selectedElement == null) {
            return;
        }
        String invariant = selectedElement instanceof EClassifier ? ((EClassifier)selectedElement).getName() : selectedElement.toString();
        PropertiesUtil.persistProperty(dataSetDesign, "OCL_ECORE_INVARIANT", invariant);
    }

    private void savePage(DataSetDesign dataSetDesign) {
        block12: {
            dataSetDesign.setQueryText(this.queryText.getText());
            this.setInvariantToSelection(dataSetDesign, (IStructuredSelection)this.contextCombo.getSelection());
            if (dataSetDesign.getPrimaryResultSet() != null) {
                return;
            }
            IConnection connection = null;
            try {
                try {
                    Driver driver = new Driver();
                    connection = driver.getConnection(null);
                    connection.open(this.dataSourceProperties);
                    this.updateDesign(connection, dataSetDesign);
                }
                catch (OdaException e) {
                    dataSetDesign.setResultSets(null);
                    dataSetDesign.setParameters(null);
                    String message = String.valueOf(Messages.getString("DataSetQueryWizardPage.message.designUpdateError")) + e.getMessage();
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.datatools.enablement.oda.ecore.ui", message, (Throwable)e));
                    try {
                        connection.close();
                    }
                    catch (OdaException odaException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    connection.close();
                }
                catch (OdaException odaException) {}
                throw throwable;
            }
            try {
                connection.close();
            }
            catch (OdaException odaException) {}
        }
    }

    private void updateDesign(IConnection conn, DataSetDesign dataSetDesign) throws OdaException {
        IQuery query = conn.newQuery(null);
        query.prepare(dataSetDesign.getQueryText());
        try {
            IResultSetMetaData resultSetMetaData = query.getMetaData();
            this.updateResultSetDesign(resultSetMetaData, dataSetDesign);
        }
        catch (OdaException e) {
            dataSetDesign.setResultSets(null);
            throw e;
        }
    }

    private void updateResultSetDesign(IResultSetMetaData resultSetMetaData, DataSetDesign dataSetDesign) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)resultSetMetaData);
        ResultSetDefinition resultSetDefinition = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefinition.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefinition);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    private void validateData() {
        boolean isValid;
        boolean bl = isValid = this.syntaxViewer.getExpression() != null && this.syntaxViewer.getExpression().trim().length() > 0;
        if (isValid) {
            this.setMessage(Messages.getString("DataSetQueryWizardPage.message.default"));
        } else {
            this.setMessage(Messages.getString("DataSetQueryWizardPage.message.expressionRequired"), 3);
        }
        this.setPageComplete(isValid);
    }

    private class InputKeyListener
    implements KeyListener {
        private final SourceViewer viewer;

        public InputKeyListener(SourceViewer viewer) {
            this.viewer = viewer;
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 9) {
                this.viewer.getTextWidget().traverse(16);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    }
}

