/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.spec.result.filter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionArguments;
import org.eclipse.datatools.connectivity.oda.spec.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.spec.IValidator;
import org.eclipse.datatools.connectivity.oda.spec.ValidationContext;
import org.eclipse.datatools.connectivity.oda.spec.manifest.FilterExpressionDefinition;
import org.eclipse.datatools.connectivity.oda.spec.manifest.ResultExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.spec.manifest.SupportedDataSetType;
import org.eclipse.datatools.connectivity.oda.spec.result.filter.AtomicExpression;
import org.eclipse.datatools.connectivity.oda.spec.util.ValidatorUtil;

public class CustomExpression
extends AtomicExpression
implements IExecutableExtension {
    private static final String QUALIFIER_SEPARATOR = ".";
    private String m_id;
    private String m_extensionId;
    private Map<String, Object> m_customData;
    private FilterExpressionDefinition m_definition;

    protected CustomExpression(String extensionId, String id) {
        this(extensionId, id, null, null);
    }

    protected CustomExpression(String extensionId, String id, ExpressionVariable variable, ExpressionArguments args) {
        super(variable, args);
        this.m_extensionId = extensionId;
        this.m_id = id;
    }

    protected CustomExpression() {
        super(null, null);
    }

    public void setInitializationData(IConfigurationElement exprElement, String propertyName, Object data) throws CoreException {
        this.m_extensionId = exprElement.getDeclaringExtension().getUniqueIdentifier();
        try {
            this.m_id = FilterExpressionDefinition.getIdAttributeValue(exprElement);
        }
        catch (OdaException ex) {
            throw new CoreException((IStatus)new Status(4, exprElement.getContributor().getName(), ex.getLocalizedMessage()));
        }
    }

    public String getId() {
        return this.m_id;
    }

    public String getDeclaringExtensionId() {
        return this.m_extensionId;
    }

    public String getQualifiedId() {
        return String.valueOf(this.m_extensionId) + QUALIFIER_SEPARATOR + this.m_id;
    }

    public String getName() {
        FilterExpressionDefinition defn = this.getDefinition();
        if (defn == null) {
            return this.getQualifiedId();
        }
        return String.valueOf(this.m_extensionId) + QUALIFIER_SEPARATOR + defn.getDisplayName();
    }

    public boolean supportsDataSetType(String odaDataSourceId, String odaDataSetId) {
        FilterExpressionDefinition defn = this.getDefinition();
        if (defn == null) {
            return false;
        }
        return defn.supportsDataSetType(odaDataSourceId, odaDataSetId);
    }

    public boolean supportsDataSetType(SupportedDataSetType dataSetType) {
        if (dataSetType == null) {
            return false;
        }
        return this.supportsDataSetType(dataSetType.getOdaDataSourceId(), dataSetType.getOdaDataSetId());
    }

    public Object getData(String key) {
        if (this.m_customData == null) {
            return null;
        }
        return this.m_customData.get(key);
    }

    public void setData(String key, Object value) {
        if (this.m_customData == null) {
            this.m_customData = new HashMap<String, Object>();
        }
        this.m_customData.put(key, value);
    }

    public FilterExpressionDefinition getDefinition() {
        if (this.m_definition == null) {
            try {
                this.m_definition = ResultExtensionExplorer.getInstance().getExtensionFilterDefinition(this.getDeclaringExtensionId(), this.getId());
            }
            catch (OdaException odaException) {
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        return this.m_definition;
    }

    public void validateSyntax(ValidationContext context) throws OdaException {
        try {
            FilterExpressionDefinition defn = this.getDefinition();
            if (defn == null) {
                throw this.newFilterExprException(Messages.bind((String)Messages.querySpec_NON_DEFINED_CUSTOM_FILTER, (Object)this.getName()));
            }
            this.validateSyntax(context, defn);
            IValidator customValidator = this.getValidator(context, defn);
            if (customValidator != null) {
                customValidator.validateSyntax(this, context);
            }
        }
        catch (OdaException ex) {
            throw ValidatorUtil.newFilterExprException(this, ex);
        }
    }

    protected void validateSyntax(ValidationContext context, FilterExpressionDefinition defn) throws OdaException {
        assert (defn != null);
        this.validateExpressionArguments(context, defn);
    }

    protected void validateExpressionArguments(ValidationContext context, FilterExpressionDefinition defn) throws OdaException {
        int maxArgs;
        int minArgs;
        int numArgs = this.getArguments().valueCount();
        if (numArgs < (minArgs = defn.getMinArguments().intValue())) {
            throw this.newFilterExprException(Messages.bind((String)Messages.querySpec_CUSTOM_FILTER_LESS_THAN_MIN_ARGS, (Object[])new Object[]{this.getName(), numArgs, minArgs}));
        }
        if (!defn.supportsUnboundedMaxArguments() && numArgs > (maxArgs = defn.getMaxArguments().intValue())) {
            throw this.newFilterExprException(Messages.bind((String)Messages.querySpec_CUSTOM_FILTER_EXCEED_MAX_ARGS, (Object[])new Object[]{this.getName(), numArgs, maxArgs}));
        }
    }

    protected IValidator getValidator(ValidationContext context, FilterExpressionDefinition defn) {
        if (context != null && context.getValidator() != null) {
            return context.getValidator();
        }
        try {
            if (defn != null) {
                return defn.getValidator();
            }
        }
        catch (OdaException odaException) {}
        return null;
    }

    protected OdaException newFilterExprException(String message) {
        return ValidatorUtil.newFilterExprException(message, this);
    }

    public boolean isNegatable() {
        FilterExpressionDefinition defn = this.getDefinition();
        return defn == null ? false : defn.isNegatable();
    }

    public boolean isOptionable() {
        FilterExpressionDefinition defn = this.getDefinition();
        return defn == null ? super.isOptionable() : defn.isOptionable();
    }
}

