/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TextFormatType implements Enumerator
{
    PLAIN_LITERAL(0, "Plain", "Plain"),
    HTML_LITERAL(1, "HTML", "HTML"),
    RTF_LITERAL(2, "RTF", "RTF");

    public static final String copyright = "Copyright (c) 2005, 2009 Actuate Corporation";
    public static final int PLAIN = 0;
    public static final int HTML = 1;
    public static final int RTF = 2;
    private static final TextFormatType[] VALUES_ARRAY;
    public static final List<TextFormatType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TextFormatType[]{PLAIN_LITERAL, HTML_LITERAL, RTF_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TextFormatType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextFormatType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextFormatType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextFormatType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextFormatType get(int value) {
        switch (value) {
            case 0: {
                return PLAIN_LITERAL;
            }
            case 1: {
                return HTML_LITERAL;
            }
            case 2: {
                return RTF_LITERAL;
            }
        }
        return null;
    }

    private TextFormatType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

