/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ICatalogTable;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogColumn;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogSchema;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.ase.ddl.SybaseASEDdlParser;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASEViewTableImpl;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseAuthorizedObject;
import org.eclipse.datatools.modelbase.sql.expressions.QueryExpression;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogView
extends SybaseASEViewTableImpl
implements ICatalogObject,
ICatalogTable,
IAdaptable {
    private static final long serialVersionUID = 3258125856181269553L;
    private Boolean columnsLoaded = Boolean.FALSE;
    private Boolean viewLoaded = Boolean.FALSE;
    private Boolean idLoaded = Boolean.FALSE;
    private Boolean privilegesLoaded = Boolean.FALSE;
    private int viewId = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.isNeedRefresh()) {
            Boolean bl = this.columnsLoaded;
            synchronized (bl) {
                if (this.columnsLoaded.booleanValue()) {
                    this.columnsLoaded = Boolean.FALSE;
                }
            }
            bl = this.viewLoaded;
            synchronized (bl) {
                if (this.viewLoaded.booleanValue()) {
                    this.viewLoaded = Boolean.FALSE;
                }
            }
            bl = this.idLoaded;
            synchronized (bl) {
                if (this.idLoaded.booleanValue()) {
                    this.idLoaded = Boolean.FALSE;
                }
            }
            bl = this.privilegesLoaded;
            synchronized (bl) {
                if (this.privilegesLoaded.booleanValue()) {
                    this.privilegesLoaded = Boolean.FALSE;
                }
            }
            RefreshManager.getInstance().referesh((ICatalogObject)this);
        }
    }

    public Connection getConnection() {
        SybaseASECatalogSchema schema = (SybaseASECatalogSchema)this.getSchema();
        return schema.getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getSchema().getCatalog().getDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getColumns() {
        Boolean bl = this.columnsLoaded;
        synchronized (bl) {
            if (!this.columnsLoaded.booleanValue()) {
                this.loadColumns();
            }
        }
        return this.columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryExpression getQueryExpression() {
        Boolean bl = this.viewLoaded;
        synchronized (bl) {
            if (!this.viewLoaded.booleanValue()) {
                this.loadView();
            }
        }
        return this.queryExpression;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 8) {
            this.getColumns();
        }
        if (id == 19) {
            this.getCheckType();
        }
        if (id == 18) {
            this.getQueryExpression();
        }
        if (id == 7) {
            this.getPrivileges();
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getPrivileges() {
        Boolean bl = this.privilegesLoaded;
        synchronized (bl) {
            if (!this.privilegesLoaded.booleanValue()) {
                this.loadPrivileges();
                this.privilegesLoaded = Boolean.TRUE;
            }
        }
        return super.getPrivileges();
    }

    protected void loadPrivileges() {
        super.getPrivileges().clear();
        SybaseASECatalog catalog = (SybaseASECatalog)this.getSchema().getCatalog();
        List privileges = SybaseASECatalogUtils.getPrivileges((SybaseAuthorizedObject)this, catalog);
        super.getPrivileges().addAll((Collection)privileges);
    }

    private void loadColumns() {
        boolean deliver;
        block17: {
            if (this.columnsLoaded.booleanValue()) {
                return;
            }
            EList columnList = super.getColumns();
            columnList.clear();
            Connection connection = this.getConnection();
            deliver = this.eDeliver();
            this.eSetDeliver(false);
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = connection.getCatalog();
                    connection.setCatalog(this.getSchema().getCatalog().getName());
                    DatabaseMetaData metaData = this.getConnection().getMetaData();
                    String catalogName = null;
                    if (metaData.supportsCatalogsInTableDefinitions()) {
                        catalogName = connection.getCatalog();
                    }
                    ResultSet r = metaData.getColumns(catalogName, this.getSchema().getName(), this.getName(), null);
                    while (r.next()) {
                        SybaseASECatalogColumn column = new SybaseASECatalogColumn();
                        String columnName = r.getString(4);
                        column.setName(columnName);
                        columnList.add((Object)column);
                    }
                    this.columnsLoaded = Boolean.TRUE;
                    r.close();
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    try {
                        if (oldCatalog != null) {
                            connection.setCatalog(oldCatalog);
                        }
                        break block17;
                    }
                    catch (SQLException e2) {
                        JDBCASEPlugin.getDefault().log(e2);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (oldCatalog != null) {
                        connection.setCatalog(oldCatalog);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                }
                throw throwable;
            }
            try {
                if (oldCatalog != null) {
                    connection.setCatalog(oldCatalog);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        this.eSetDeliver(deliver);
    }

    private void loadView() {
        if (this.viewLoaded.booleanValue()) {
            return;
        }
        Connection connection = this.getConnection();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        String text = SybaseASECatalogUtils.getCompiledObjectText((SQLObject)this, connection, this.getSchema().getCatalog().getName());
        SybaseASEDdlParser ddlParser = new SybaseASEDdlParser(this.getDatabaseDefinition());
        ddlParser.parseView((ViewTable)this, text);
        this.viewLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    private DatabaseDefinition getDatabaseDefinition() {
        Database d = this.getSchema().getCatalog().getDatabase();
        return RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTableId() {
        Boolean bl = this.idLoaded;
        synchronized (bl) {
            if (!this.idLoaded.booleanValue()) {
                this.loadViewId();
                this.idLoaded = Boolean.TRUE;
            }
        }
        return this.viewId;
    }

    private void loadViewId() {
        block7: {
            if (this.idLoaded.booleanValue()) {
                return;
            }
            PreparedStatement stmt = null;
            ResultSet rs = null;
            Connection conn = this.getConnection();
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(this.getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("SELECT O.id from sysobjects O, sysusers U where U.uid = O.uid and U.name = ? and O.name = ?");
                    stmt.setString(1, this.getSchema().getName());
                    stmt.setString(2, this.getName());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        this.viewId = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
    }

    public boolean isSystem() {
        return false;
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }

    public boolean isNeedRefresh() {
        return this.columnsLoaded != false || this.viewLoaded != false || this.idLoaded != false || this.privilegesLoaded != false;
    }
}

