/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogIndex;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogProcedure;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEFuncBasedIndexMember;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybaseAuthorizedObject;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasePrivilege;
import org.eclipse.datatools.enablement.sybase.models.sybasesqlmodel.SybasesqlmodelFactory;
import org.eclipse.datatools.modelbase.dbdefinition.PredefinedDataTypeDefinition;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.constraints.IncrementType;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.PrimitiveType;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogUtils {
    private static final String PROCEDURE_CAT = "PROCEDURE_CAT";
    private static final String PROCEDURE_SCHEM = "PROCEDURE_SCHEM";
    private static final String PROCEDURE_NAME = "PROCEDURE_NAME";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String COLUMN_TYPE = "COLUMN_TYPE";
    private static final String DATA_TYPE = "DATA_TYPE";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String PRECISION = "PRECISION";
    private static final String LENGTH = "LENGTH";
    private static final String SCALE = "SCALE";
    private static final String RADIX = "RADIX";
    private static final String NULLABLE = "NULLABLE";
    private static final String REMARKS = "REMARKS";
    protected static final int RESULT_SET_STRING = 1;
    static final int PERMISSION_ATTR_GRANTOR = 1;
    static final int PERMISSION_ATTR_GRANTEE = 2;
    static final int PERMISSION_ATTR_TYPE = 3;
    static final int PERMISSION_ATTR_ACTION = 4;
    static final int PERMISSION_ATTR_OWNER = 5;
    static final int PERMISSION_ATTR_OBJECT = 6;
    static final int PERMISSION_ATTR_OBJTYPE = 7;
    static final int PERMISSION_ATTR_COLUMN = 8;
    static final int PERMISSION_REFERENCE_TYPE = 151;
    static final int PERMISSION_SELECT_TYPE = 193;
    static final int PERMISSION_INSERT_TYPE = 195;
    static final int PERMISSION_DELETE_TYPE = 196;
    static final int PERMISSION_UPDATE_TYPE = 197;
    static final int PERMISSION_EXECUTE_TYPE = 224;
    static final int GRANT_WITH_GRANT_TYPE = 0;
    static final int GRANT_TYPE = 1;
    static final int REVOKE_TYPE = 2;
    private static final int CONST_UNICHARSIZE = 2;
    protected static ArrayList _colMetaData = new ArrayList();

    public static List getDBDatatypes(String ctg, Connection conn) throws SQLException {
        ArrayList<String> ret;
        block6: {
            ret = new ArrayList<String>();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(ctg);
                    stmt = conn.prepareStatement("select name from systypes where usertype < 100 and usertype > 0 and name not in ('floatn', 'datetimn', 'numericn', 'decimaln', 'moneyn', 'intn', 'daten', 'timen', 'uintn') order by name");
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        String udtName = rs.getString(1);
                        if (udtName == null) continue;
                        ret.add(udtName);
                    }
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return ret;
    }

    public static ResultSet getStoredProcs(String sch_nm, Connection cnxn) throws SQLException {
        PreparedStatement stmt = cnxn.prepareStatement("SELECT O.name as PROCEDURE_NAME, O.sysstat2 as PROCEDURE_TYPE FROM sysusers U, sysobjects O WHERE U.uid=O.uid AND U.name = ? and O.type='P' order by 1");
        stmt.setString(1, sch_nm);
        return stmt.executeQuery();
    }

    protected static int getConfigureOption(String configParameter, Connection connection) {
        int result = 0;
        Statement stmt = null;
        ResultSet rSet = null;
        try {
            try {
                String pattern = "'{' call sp_configure ''{0}'' '}'";
                String sql = MessageFormat.format(pattern, configParameter);
                stmt = connection.prepareStatement(sql);
                boolean isResultSet = stmt.execute();
                int updateCount = -1;
                do {
                    if (isResultSet) {
                        rSet = stmt.getResultSet();
                        while (rSet.next()) {
                            try {
                                result = rSet.getInt("Run Value");
                                break;
                            }
                            catch (SQLException e) {
                                JDBCASEPlugin.getDefault().log(e);
                            }
                        }
                    }
                    isResultSet = stmt.getMoreResults();
                    updateCount = stmt.getUpdateCount();
                } while (isResultSet || updateCount != -1);
            }
            catch (Exception exception) {
                try {
                    if (rSet != null) {
                        rSet.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                }
            }
        }
        finally {
            try {
                if (rSet != null) {
                    rSet.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        return result;
    }

    protected static List getPrivileges(AuthorizationIdentifier auth, SybaseASECatalog catalog) {
        ArrayList<SybasePrivilege> result;
        block21: {
            result = new ArrayList<SybasePrivilege>();
            EList authIds = catalog.getAuthorizationIds();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            Connection conn = ((ICatalogObject)auth).getConnection();
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(catalog.getName());
                    stmt = conn.prepareStatement("select distinct grantor.name as grantor, authid.name as grantee, p.protecttype as type, p.action, owner.name as owner, obj.name as object, obj.type as objectType, cols.name as column_name from sysprotects p join master.dbo.spt_values c on convert(tinyint,substring(isnull(p.columns,0x1), c.low,1)) & c.high != 0 and c.type = 'P' and c.number <= 1024 join sysusers authid on authid.uid = p.uid and authid.name like ? join sysobjects obj on p.id = obj.id join sysusers owner on obj.uid = owner.uid join sysusers grantor on p.grantor = grantor.uid left  join  syscolumns cols on\t(cols.id = p.id and cols.colid = c.number)");
                    stmt.setString(1, auth.getName());
                    rs = stmt.executeQuery();
                    block16: while (rs.next()) {
                        SQLObject permissionObj = null;
                        String grantee = rs.getString(6);
                        if (grantee == null) continue;
                        SybasePrivilege privilege = SybasesqlmodelFactory.eINSTANCE.createSybasePrivilege();
                        String owner = rs.getString(5);
                        String columnName = rs.getString(8);
                        boolean isColumn = columnName != null;
                        Schema schema = (Schema)ASEUtil.getSQLObject((Collection)catalog.getSchemas(), owner);
                        String objType = rs.getString(7).trim();
                        if (objType.equals("U") || objType.equals("S") || objType.equals("V")) {
                            permissionObj = ASEUtil.getSQLObject((Collection)schema.getTables(), grantee);
                        } else {
                            if (!objType.equals("P") && !objType.equals("F")) continue;
                            permissionObj = ASEUtil.getSQLObject((Collection)schema.getRoutines(), grantee);
                        }
                        if (isColumn) {
                            EList columns = ((Table)permissionObj).getColumns();
                            permissionObj = ASEUtil.getSQLObject((Collection)columns, columnName);
                        }
                        privilege.setObject(permissionObj);
                        String sAction = null;
                        int iAction = rs.getInt(4);
                        switch (iAction) {
                            case 196: {
                                sAction = "delete";
                                break;
                            }
                            case 195: {
                                sAction = "insert";
                                break;
                            }
                            case 151: {
                                sAction = "references";
                                break;
                            }
                            case 193: {
                                sAction = "select";
                                break;
                            }
                            case 197: {
                                sAction = "update";
                                break;
                            }
                            case 224: {
                                sAction = "execute";
                                break;
                            }
                            default: {
                                sAction = "other";
                                continue block16;
                            }
                        }
                        privilege.setAction(sAction);
                        int iType = rs.getInt(3);
                        switch (iType) {
                            case 0: {
                                privilege.setGrantable(true);
                                break;
                            }
                            case 2: {
                                privilege.setRevoked(true);
                            }
                        }
                        String grantorName = rs.getString(1);
                        AuthorizationIdentifier grantor = (AuthorizationIdentifier)ASEUtil.getSQLObject((Collection)authIds, grantorName);
                        privilege.setGrantor(grantor);
                        privilege.setGrantee(auth);
                        result.add(privilege);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block21;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return result;
    }

    protected static List getPrivileges(SybaseAuthorizedObject object, SybaseASECatalog catalog) {
        ArrayList<SybasePrivilege> result;
        block21: {
            result = new ArrayList<SybasePrivilege>();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            Connection conn = catalog.getConnection();
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(catalog.getName());
                    String ownerName = SybaseASECatalogUtils.getSchemaName((EObject)object);
                    if (ownerName != null && ownerName.trim().length() > 0) {
                        stmt = conn.prepareStatement("select distinct grantor.name as grantor,  authid.name as grantee, p.protecttype as type,  p.action, owner.name as owner, obj.name as object, obj.type as objectType, cols.name as column_name  from sysprotects p join master.dbo.spt_values c  on convert(tinyint,substring(isnull(p.columns,0x1), c.low,1)) & c.high != 0  and c.type = 'P' and c.number <= 1024   join sysusers authid on authid.uid = p.uid  join sysobjects obj on p.id = obj.id   join sysusers owner on obj.uid = owner.uid   join sysusers grantor on p.grantor = grantor.uid   left  join  syscolumns cols on    (cols.id = p.id and cols.colid = c.number)  where obj.name = ? and owner.name = ?");
                        stmt.setString(1, object.getName());
                        stmt.setString(2, ownerName);
                    } else {
                        stmt = conn.prepareStatement("select distinct grantor.name as grantor,  authid.name as grantee, p.protecttype as type,  p.action, owner.name as owner, obj.name as object, obj.type as objectType, cols.name as column_name  from sysprotects p join master.dbo.spt_values c  on convert(tinyint,substring(isnull(p.columns,0x1), c.low,1)) & c.high != 0  and c.type = 'P' and c.number <= 1024   join sysusers authid on authid.uid = p.uid  join sysobjects obj on p.id = obj.id   join sysusers owner on obj.uid = owner.uid   join sysusers grantor on p.grantor = grantor.uid   left  join  syscolumns cols on    (cols.id = p.id and cols.colid = c.number)  where obj.name = ?");
                        stmt.setString(1, object.getName());
                    }
                    rs = stmt.executeQuery();
                    EList authIds = catalog.getAuthorizationIds();
                    block16: while (rs.next()) {
                        boolean isColumn;
                        SybaseAuthorizedObject permissionObj = object;
                        String granteeName = rs.getString(2);
                        if (granteeName == null) continue;
                        SybasePrivilege privilege = SybasesqlmodelFactory.eINSTANCE.createSybasePrivilege();
                        AuthorizationIdentifier grantee = (AuthorizationIdentifier)ASEUtil.getSQLObject((Collection)authIds, granteeName);
                        if (grantee == null) continue;
                        privilege.setGrantee(grantee);
                        String columnName = rs.getString(8);
                        boolean bl = isColumn = columnName != null;
                        if (isColumn) {
                            EList columns = ((Table)permissionObj).getColumns();
                            permissionObj = ASEUtil.getSQLObject((Collection)columns, columnName);
                            privilege.getActionObjects().add((Object)permissionObj);
                        }
                        String sAction = null;
                        int iAction = rs.getInt(4);
                        switch (iAction) {
                            case 196: {
                                sAction = "delete";
                                break;
                            }
                            case 195: {
                                sAction = "insert";
                                break;
                            }
                            case 151: {
                                sAction = "references";
                                break;
                            }
                            case 193: {
                                sAction = "select";
                                break;
                            }
                            case 197: {
                                sAction = "update";
                                break;
                            }
                            case 224: {
                                sAction = "execute";
                                break;
                            }
                            default: {
                                sAction = "other";
                                continue block16;
                            }
                        }
                        privilege.setAction(sAction);
                        int iType = rs.getInt(3);
                        switch (iType) {
                            case 0: {
                                privilege.setGrantable(true);
                                break;
                            }
                            case 2: {
                                privilege.setRevoked(true);
                            }
                        }
                        String grantorName = rs.getString(1);
                        AuthorizationIdentifier authId = (AuthorizationIdentifier)ASEUtil.getSQLObject((Collection)authIds, grantorName);
                        privilege.setGrantor(authId);
                        result.add(privilege);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block21;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return result;
    }

    public static String getSchemaName(EObject obj) {
        if (obj instanceof Trigger) {
            return ((Trigger)obj).getSchema().getName();
        }
        EObject container = ContainmentServiceImpl.INSTANCE.getContainer(obj);
        while (container != null) {
            obj = container;
            if (obj instanceof Schema) {
                return ((Schema)obj).getName();
            }
            container = ContainmentServiceImpl.INSTANCE.getContainer(obj);
        }
        return null;
    }

    protected static String getCompiledObjectText(SQLObject obj, Connection conn, String catalogName) {
        StringBuffer strRes;
        block12: {
            if (conn == null) {
                return null;
            }
            strRes = new StringBuffer();
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(catalogName);
                    String coName = obj.getName();
                    int groupNumb = -1;
                    if (obj instanceof SybaseASECatalogProcedure) {
                        groupNumb = ((SybaseASECatalogProcedure)obj).getGroupNumber();
                    }
                    String sql = "{ call sp_helptext ? }";
                    if (groupNumb >= 1) {
                        sql = "{ call sp_helptext ?,? }";
                    }
                    stmt = conn.prepareStatement(sql);
                    stmt.setString(1, String.valueOf(SybaseASECatalogUtils.getSchemaName((EObject)obj)) + "." + coName);
                    if (groupNumb >= 1) {
                        stmt.setInt(2, groupNumb);
                    }
                    boolean updateCount = stmt.execute();
                    while (!updateCount) {
                        updateCount = stmt.getMoreResults();
                    }
                    updateCount = stmt.getMoreResults();
                    while (!updateCount) {
                        updateCount = stmt.getMoreResults();
                    }
                    rs = stmt.getResultSet();
                    while (rs.next()) {
                        strRes.append(rs.getString("text"));
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return strRes.toString().trim();
    }

    public static String getUDTOwner(String typeName, String dbName, Connection conn) throws SQLException {
        if (typeName != null && !typeName.trim().equals("")) {
            Statement stat = null;
            ResultSet rs = null;
            String ownerName = null;
            try {
                String query = "SELECT U.name owner_name,T.name udt_name, PHY.name udt_sys_name, T.length udt_length,T.prec udt_precision, T.scale udt_scale, T.allownulls udt_allow_nulls, T.ident udt_is_identity,(SELECT DO.name + '.' + object_name(T.tdefault,db_id('" + dbName + "')) " + "FROM " + dbName + ".dbo.sysusers DO " + "WHERE DO.uid=(SELECT uid from " + dbName + ".dbo.sysobjects where id = T.tdefault)) " + "udt_default_name, " + "(SELECT RO.name + '.' + object_name((case when T.domain<>0 then T.domain else T.accessrule end),db_id('pubs2')) " + "FROM " + dbName + ".dbo.sysusers RO " + "WHERE RO.uid = (SELECT uid from dbo.sysobjects where id  = T.domain OR id = T.accessrule)) " + "udt_rule_name " + "FROM  " + dbName + ".dbo.systypes T, " + dbName + ".dbo.sysusers U, " + dbName + ".dbo.systypes PHY " + "WHERE T.uid = U.uid AND PHY.usertype =(SELECT min(usertype) FROM " + dbName + ".dbo.systypes WHERE type = T.type ) " + "AND T.type = PHY.type AND T.usertype >= 100 AND T.name like '" + typeName + "'";
                stat = conn.createStatement();
                rs = stat.executeQuery(query.toString());
                if (rs.next()) {
                    ownerName = rs.getString("owner_name");
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (stat != null) {
                    stat.close();
                }
            }
            return ownerName;
        }
        return null;
    }

    protected static IndexMember getIndexMember(DatabaseDefinition dbDef, SybaseASECatalogIndex index, String colName, String order, Connection conn) {
        String catalogName;
        DataModelElementFactory factory;
        int funcIndexColId;
        boolean isFunctionalIndexCol;
        IncrementType incType;
        IndexMember member;
        block11: {
            member = null;
            incType = IncrementType.get((String)order);
            isFunctionalIndexCol = false;
            funcIndexColId = -1;
            factory = dbDef.getDataModelElementFactory();
            catalogName = index.getTable().getSchema().getCatalog().getName();
            String version = dbDef.getVersion();
            if (version.compareTo("15") >= 0) {
                PreparedStatement stmt = null;
                ResultSet rs = null;
                String oldCatalog = null;
                try {
                    try {
                        oldCatalog = conn.getCatalog();
                        conn.setCatalog(catalogName);
                        stmt = conn.prepareStatement("SELECT isnull(status3,0),computedcol FROM syscolumns  WHERE name like ? AND id = object_id(?)");
                        stmt.setString(1, colName);
                        stmt.setString(2, ASEUtil.getFullQuatifiedName((SQLObject)index.getTable()));
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            int status3 = rs.getInt(1);
                            if ((status3 & 1) <= 0) continue;
                            isFunctionalIndexCol = true;
                            funcIndexColId = rs.getInt(2);
                        }
                    }
                    catch (SQLException e) {
                        JDBCASEPlugin.getDefault().log(e);
                        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    throw throwable;
                }
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            }
        }
        if (!isFunctionalIndexCol) {
            member = (IndexMember)factory.create(SQLConstraintsPackage.eINSTANCE.getIndexMember());
        } else {
            String funcIndexColExpr = SybaseASECatalogUtils.getFunctionedIndexExpression(funcIndexColId, catalogName, conn);
            member = (SybaseASEFuncBasedIndexMember)factory.create(SybaseasesqlmodelPackage.eINSTANCE.getSybaseASEFuncBasedIndexMember());
            ((SybaseASEFuncBasedIndexMember)member).setColumnExpression(funcIndexColExpr);
        }
        EList columnList = index.getTable().getColumns();
        int i = 0;
        while (i < columnList.size()) {
            Column col = (Column)columnList.get(i);
            if (col.getName().equals(colName)) {
                member.setColumn(col);
                break;
            }
            ++i;
        }
        member.setIncrementType(incType);
        return member;
    }

    private static String getFunctionedIndexExpression(int colId, String catalog, Connection conn) {
        StringBuffer text;
        block10: {
            text = new StringBuffer(256);
            PreparedStatement stmt = null;
            ResultSet rs = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(catalog);
                    stmt = conn.prepareStatement("SELECT text FROM syscomments WHERE id = ?");
                    stmt.setInt(1, colId);
                    rs = stmt.executeQuery();
                    int count = 0;
                    while (rs.next()) {
                        ++count;
                        String expression = rs.getString(1);
                        if (!expression.equals("")) {
                            String tmpExpression;
                            int pos;
                            expression = expression.trim();
                            if (count == 1) {
                                expression = expression.substring(expression.indexOf("AS") + 2).trim();
                            }
                            if ((pos = (tmpExpression = expression.toUpperCase()).lastIndexOf("MATERIALIZED")) != -1) {
                                expression = expression.substring(0, pos).trim();
                                pos = tmpExpression.lastIndexOf("NOT");
                                if (pos != -1) {
                                    expression = expression.substring(0, pos).trim();
                                }
                            }
                        }
                        text.append(expression);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return text.toString();
    }

    protected static String getIndexCache(SybaseASECatalogIndex index, int indexId, Connection conn) {
        String cacheName;
        block6: {
            PreparedStatement stmt = null;
            ResultSet rs = null;
            cacheName = null;
            String oldCatalog = null;
            try {
                try {
                    oldCatalog = conn.getCatalog();
                    conn.setCatalog(index.getTable().getSchema().getCatalog().getName());
                    stmt = conn.prepareStatement("select char_value FROM sysattributes b, sysobjects c WHERE c.id = b.object AND b.object_info1 = ? AND c.id in (Select object_id(?)) AND object_type = 'I'  order by 1");
                    stmt.setInt(1, indexId);
                    stmt.setString(2, ASEUtil.getFullQuatifiedName((SQLObject)index.getTable()));
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        cacheName = rs.getString(1);
                    }
                }
                catch (SQLException e) {
                    JDBCASEPlugin.getDefault().log(e);
                    SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
                throw throwable;
            }
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        }
        return cacheName;
    }

    protected static PredefinedDataType getASEPredefinedType(int length, int precision, int scale, int iCharSize, String typeName, DatabaseDefinition databaseDefinition) throws SQLException {
        EStructuralFeature feature;
        PredefinedDataTypeDefinition typeDefinition = databaseDefinition.getPredefinedDataTypeDefinition(typeName);
        PrimitiveType primitiveType = typeDefinition.getPrimitiveType();
        PredefinedDataType type = databaseDefinition.getPredefinedDataType(typeDefinition);
        if (primitiveType.getValue() == 14) {
            feature = type.eClass().getEStructuralFeature("precision");
            type.eSet(feature, (Object)new Integer(length * 2));
        } else if (primitiveType.getValue() == 3 || primitiveType.getValue() == 4) {
            iCharSize = iCharSize == 0 ? 1 : iCharSize;
            feature = type.eClass().getEStructuralFeature("length");
            type.eSet(feature, (Object)new Integer(length / iCharSize));
        } else if (typeName.equals("unichar") || typeName.equals("univarchar")) {
            feature = type.eClass().getEStructuralFeature("length");
            type.eSet(feature, (Object)new Integer(length / 2));
        } else if (typeDefinition.isLengthSupported()) {
            feature = type.eClass().getEStructuralFeature("length");
            type.eSet(feature, (Object)new Integer(length));
        } else if (typeDefinition.isPrecisionSupported()) {
            feature = type.eClass().getEStructuralFeature("precision");
            type.eSet(feature, (Object)new Integer(precision));
        }
        if (typeDefinition.isScaleSupported()) {
            feature = type.eClass().getEStructuralFeature("scale");
            type.eSet(feature, (Object)new Integer(scale));
        }
        return type;
    }

    public static void cleanupJDBCResouce(ResultSet rs, Statement stmt, String oldCatalog, Connection conn) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            JDBCASEPlugin.getDefault().log(e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            JDBCASEPlugin.getDefault().log(e);
        }
        try {
            if (oldCatalog != null) {
                conn.setCatalog(oldCatalog);
            }
        }
        catch (SQLException e) {
            JDBCASEPlugin.getDefault().log(e);
        }
    }

    public static String getBoundDefaultValue(String body) {
        String result = "";
        Pattern pattern = Pattern.compile("\\s*create\\s+default\\s+.*\\s+AS\\s+(.*\\S)\\s*", 34);
        Matcher matcher = pattern.matcher(body);
        if (matcher.matches()) {
            result = matcher.group(1);
        }
        return result;
    }

    public static DataType getSpecifiedUserDefinedDatatype(Catalog catalog, String typeName) {
        DataType type = null;
        EList schemaList = catalog.getSchemas();
        int i = 0;
        while (i < schemaList.size()) {
            Schema schema = (Schema)schemaList.get(i);
            type = (DataType)ASEUtil.getSQLObject((Collection)schema.getUserDefinedTypes(), typeName);
            if (type != null) break;
            ++i;
        }
        return type;
    }
}

