/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.ui.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.datatools.sqltools.plan.IPlanService;
import org.eclipse.datatools.sqltools.plan.PlanRequest;
import org.eclipse.datatools.sqltools.plan.PlanServiceRegistry;
import org.eclipse.datatools.sqltools.plan.internal.IPlanInstance;
import org.eclipse.datatools.sqltools.plan.internal.PlanViewPlugin;
import org.eclipse.datatools.sqltools.plan.internal.ui.actions.Messages;
import org.eclipse.datatools.sqltools.plan.internal.util.ILogger;
import org.eclipse.datatools.sqltools.plan.internal.util.Images;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SavePlanAction
extends Action {
    public static final String CDATA_END = "]]>";
    public static final String CDATA_END_SUB = "]]&gt;";
    private static ILogger _log = PlanViewPlugin.getLogger(null);

    public SavePlanAction() {
        this.setText(Messages.SavePlanAction_saveplan_title);
        this.setToolTipText(Messages.SavePlanAction_saveplan_tooltip);
        this.setImageDescriptor(Images.DESC_EXPORT_PLAN);
        this.setDisabledImageDescriptor(Images.DESC_EXPORT_PLAN_DISABLE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, HelpUtil.getContextId((String)"save_plan_action", (String)PlanViewPlugin.getDefault().getBundle().getSymbolicName()));
    }

    private String checkFileExists(String file, boolean backInputDlg) {
        if (file == null) {
            return "";
        }
        if (backInputDlg) {
            FileDialog dlg = new FileDialog(PlanViewPlugin.getActiveWorkbenchShell(), 8192);
            dlg.setFileName(file);
            String retFile = dlg.open();
            if (retFile == null) {
                return "";
            }
            return this.checkFileExists(retFile, false);
        }
        File f = new File(file);
        if (f.exists()) {
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            String question = NLS.bind((String)Messages.SavePlanAction_overwrite_q, (Object[])new Object[]{file});
            MessageDialog d = new MessageDialog(PlanViewPlugin.getActiveWorkbenchWindow().getShell(), Messages.SavePlanAction_question, null, question, 3, buttons, 0);
            switch (d.open()) {
                case 0: {
                    return file;
                }
                case 1: {
                    return this.checkFileExists(file, true);
                }
                case 2: {
                    return "";
                }
            }
            return "";
        }
        return file;
    }

    public void run() {
        FileDialog dlg = new FileDialog(PlanViewPlugin.getActiveWorkbenchShell(), 8192);
        String file = dlg.open();
        if (file != null) {
            if ("".equals(file = this.checkFileExists(file, false))) {
                return;
            }
            DocumentBuilder builder = null;
            try {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (Exception ex) {
                _log.error("SavePlanAction.builder.error", (Throwable)ex);
            }
            Document document = builder.newDocument();
            Element root = document.createElement("plans");
            document.appendChild(root);
            IPlanInstance[] instances = PlanViewPlugin.getPlanManager().getAllPlanInstances();
            int i = 0;
            while (i < instances.length) {
                IPlanInstance instance = instances[i];
                PlanRequest planRequest = instance.getPlanRequest();
                IPlanService service = PlanServiceRegistry.getInstance().getPlanService(instance.getPlanRequest().getDatabaseDefinitionId());
                if (instance.isFinished()) {
                    Element planNode = document.createElement("plan");
                    Attr status = document.createAttribute("status");
                    status.setNodeValue(this.getStatusString(instance.getStatus()));
                    planNode.setAttributeNode(status);
                    Attr type = document.createAttribute("type");
                    type.setNodeValue(service.getPlanOption().getTypeNameById(instance.getPlanRequest().getPlanType()));
                    planNode.setAttributeNode(type);
                    root.appendChild(planNode);
                    Element requestNode = document.createElement("request");
                    Attr dbId = document.createAttribute("dbDefinitionId");
                    dbId.setNodeValue(planRequest.getDatabaseDefinitionId());
                    requestNode.setAttributeNode(dbId);
                    CDATASection sql = document.createCDATASection(planRequest.getSql());
                    requestNode.appendChild(sql);
                    planNode.appendChild(requestNode);
                    Element rawPlanNode = document.createElement("rawPlan");
                    planNode.appendChild(rawPlanNode);
                    if (instance.getStatus() == 1) {
                        CDATASection rawPlanData;
                        if (instance.getRawPlan() == null) {
                            rawPlanData = document.createCDATASection("");
                            rawPlanNode.appendChild(rawPlanData);
                        } else {
                            rawPlanData = document.createCDATASection(instance.getRawPlan().toString().replaceAll(CDATA_END, CDATA_END_SUB));
                            rawPlanNode.appendChild(rawPlanData);
                        }
                    } else {
                        CDATASection failureInfo = document.createCDATASection(instance.getFailThrowable().getMessage());
                        rawPlanNode.appendChild(failureInfo);
                    }
                }
                ++i;
            }
            try {
                File exportedFile = new File(file);
                FileOutputStream fos = new FileOutputStream(exportedFile);
                String enc = PlanViewPlugin.getDefault().getPreferenceStore().getString("org.eclipse.datatools.sqltools.plan.preferences.exportformat.pref_encoding");
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, enc);
                DOMSource source = new DOMSource(document.getDocumentElement());
                StreamResult result = new StreamResult(osw);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.transform(source, result);
            }
            catch (Exception e) {
                Status fstatus = new Status(4, "org.eclipse.datatools.sqltools.plan", 0, e.getMessage(), (Throwable)e);
                final String title = Messages.SavePlanAction_error;
                final String msg = Messages.SavePlanAction_error_info;
                Display display = PlanViewPlugin.getActiveWorkbenchShell().getDisplay();
                display.asyncExec(new Runnable((IStatus)fstatus){
                    private final /* synthetic */ IStatus val$fstatus;
                    {
                        this.val$fstatus = iStatus;
                    }

                    public void run() {
                        ErrorDialog.openError((Shell)PlanViewPlugin.getActiveWorkbenchShell(), (String)title, (String)msg, (IStatus)this.val$fstatus);
                    }
                });
                _log.error("SavePlanAction.error.message", (Throwable)e);
            }
        }
    }

    private String getStatusString(int status) {
        switch (status) {
            case 1: {
                return "SUCCESS";
            }
            case 2: {
                return "FAILED";
            }
        }
        return "RUNNING";
    }

    public void update() {
        boolean shouldEnable = false;
        IPlanInstance[] instances = PlanViewPlugin.getPlanManager().getAllPlanInstances();
        int i = 0;
        while (i < instances.length) {
            if (instances[i].isFinished()) {
                shouldEnable = true;
                break;
            }
            ++i;
        }
        this.setEnabled(shouldEnable);
    }
}

