/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AxisType implements Enumerator
{
    DIMENSION_MEMBER_LITERAL(0, "DimensionMember", "DimensionMember"),
    DIMENSION_ATTRIBUTE_LITERAL(1, "DimensionAttribute", "DimensionAttribute"),
    MEASURE_LITERAL(2, "Measure", "Measure");

    public static final String copyright = "Copyright (c) 2005, 2009 Actuate Corporation";
    public static final int DIMENSION_MEMBER = 0;
    public static final int DIMENSION_ATTRIBUTE = 1;
    public static final int MEASURE = 2;
    private static final AxisType[] VALUES_ARRAY;
    public static final List<AxisType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AxisType[]{DIMENSION_MEMBER_LITERAL, DIMENSION_ATTRIBUTE_LITERAL, MEASURE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AxisType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AxisType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AxisType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AxisType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AxisType get(int value) {
        switch (value) {
            case 0: {
                return DIMENSION_MEMBER_LITERAL;
            }
            case 1: {
                return DIMENSION_ATTRIBUTE_LITERAL;
            }
            case 2: {
                return MEASURE_LITERAL;
            }
        }
        return null;
    }

    private AxisType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

