/**
 * <copyright>
 * </copyright>
 *
 * $Id: SQLQueryModelItemProviderAdapterFactory.java,v 1.2 2008/01/31 02:58:42 bpayton Exp $
 */
package org.eclipse.datatools.modelbase.sql.query.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.datatools.modelbase.sql.query.util.SQLQueryModelAdapterFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SQLQueryModelItemProviderAdapterFactory extends SQLQueryModelAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected Collection supportedTypes = new ArrayList();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public SQLQueryModelItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected QueryDeleteStatementItemProvider queryDeleteStatementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createQueryDeleteStatementAdapter() {
        if (queryDeleteStatementItemProvider == null) {
            queryDeleteStatementItemProvider = new QueryDeleteStatementItemProvider(this);
        }

        return queryDeleteStatementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected QueryInsertStatementItemProvider queryInsertStatementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createQueryInsertStatementAdapter() {
        if (queryInsertStatementItemProvider == null) {
            queryInsertStatementItemProvider = new QueryInsertStatementItemProvider(this);
        }

        return queryInsertStatementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected QuerySelectStatementItemProvider querySelectStatementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createQuerySelectStatementAdapter() {
        if (querySelectStatementItemProvider == null) {
            querySelectStatementItemProvider = new QuerySelectStatementItemProvider(this);
        }

        return querySelectStatementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected QueryUpdateStatementItemProvider queryUpdateStatementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createQueryUpdateStatementAdapter() {
        if (queryUpdateStatementItemProvider == null) {
            queryUpdateStatementItemProvider = new QueryUpdateStatementItemProvider(this);
        }

        return queryUpdateStatementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.UpdateAssignmentExpression} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected UpdateAssignmentExpressionItemProvider updateAssignmentExpressionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.UpdateAssignmentExpression}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createUpdateAssignmentExpressionAdapter() {
        if (updateAssignmentExpressionItemProvider == null) {
            updateAssignmentExpressionItemProvider = new UpdateAssignmentExpressionItemProvider(this);
        }

        return updateAssignmentExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.CursorReference} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected CursorReferenceItemProvider cursorReferenceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.CursorReference}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createCursorReferenceAdapter() {
        if (cursorReferenceItemProvider == null) {
            cursorReferenceItemProvider = new CursorReferenceItemProvider(this);
        }

        return cursorReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected QueryExpressionRootItemProvider queryExpressionRootItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createQueryExpressionRootAdapter() {
        if (queryExpressionRootItemProvider == null) {
            queryExpressionRootItemProvider = new QueryExpressionRootItemProvider(this);
        }

        return queryExpressionRootItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValuesRow} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValuesRowItemProvider valuesRowItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValuesRow}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValuesRowAdapter() {
        if (valuesRowItemProvider == null) {
            valuesRowItemProvider = new ValuesRowItemProvider(this);
        }

        return valuesRowItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.QueryValues} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected QueryValuesItemProvider queryValuesItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.QueryValues}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createQueryValuesAdapter() {
        if (queryValuesItemProvider == null) {
            queryValuesItemProvider = new QueryValuesItemProvider(this);
        }

        return queryValuesItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.TableJoined} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected TableJoinedItemProvider tableJoinedItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.TableJoined}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createTableJoinedAdapter() {
        if (tableJoinedItemProvider == null) {
            tableJoinedItemProvider = new TableJoinedItemProvider(this);
        }

        return tableJoinedItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.WithTableSpecification} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected WithTableSpecificationItemProvider withTableSpecificationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.WithTableSpecification}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createWithTableSpecificationAdapter() {
        if (withTableSpecificationItemProvider == null) {
            withTableSpecificationItemProvider = new WithTableSpecificationItemProvider(this);
        }

        return withTableSpecificationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected SearchConditionCombinedItemProvider searchConditionCombinedItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createSearchConditionCombinedAdapter() {
        if (searchConditionCombinedItemProvider == null) {
            searchConditionCombinedItemProvider = new SearchConditionCombinedItemProvider(this);
        }

        return searchConditionCombinedItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.OrderByValueExpression} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected OrderByValueExpressionItemProvider orderByValueExpressionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.OrderByValueExpression}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createOrderByValueExpressionAdapter() {
        if (orderByValueExpressionItemProvider == null) {
            orderByValueExpressionItemProvider = new OrderByValueExpressionItemProvider(this);
        }

        return orderByValueExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.QueryCombined} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected QueryCombinedItemProvider queryCombinedItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.QueryCombined}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createQueryCombinedAdapter() {
        if (queryCombinedItemProvider == null) {
            queryCombinedItemProvider = new QueryCombinedItemProvider(this);
        }

        return queryCombinedItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.QuerySelect} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected QuerySelectItemProvider querySelectItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.QuerySelect}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createQuerySelectAdapter() {
        if (querySelectItemProvider == null) {
            querySelectItemProvider = new QuerySelectItemProvider(this);
        }

        return querySelectItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ResultTableAllColumns} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ResultTableAllColumnsItemProvider resultTableAllColumnsItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ResultTableAllColumns}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createResultTableAllColumnsAdapter() {
        if (resultTableAllColumnsItemProvider == null) {
            resultTableAllColumnsItemProvider = new ResultTableAllColumnsItemProvider(this);
        }

        return resultTableAllColumnsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ResultColumn} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ResultColumnItemProvider resultColumnItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ResultColumn}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createResultColumnAdapter() {
        if (resultColumnItemProvider == null) {
            resultColumnItemProvider = new ResultColumnItemProvider(this);
        }

        return resultColumnItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.PredicateBasic} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected PredicateBasicItemProvider predicateBasicItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.PredicateBasic}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createPredicateBasicAdapter() {
        if (predicateBasicItemProvider == null) {
            predicateBasicItemProvider = new PredicateBasicItemProvider(this);
        }

        return predicateBasicItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.PredicateBetween} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected PredicateBetweenItemProvider predicateBetweenItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.PredicateBetween}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createPredicateBetweenAdapter() {
        if (predicateBetweenItemProvider == null) {
            predicateBetweenItemProvider = new PredicateBetweenItemProvider(this);
        }

        return predicateBetweenItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.PredicateExists} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected PredicateExistsItemProvider predicateExistsItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.PredicateExists}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createPredicateExistsAdapter() {
        if (predicateExistsItemProvider == null) {
            predicateExistsItemProvider = new PredicateExistsItemProvider(this);
        }

        return predicateExistsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.PredicateLike} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected PredicateLikeItemProvider predicateLikeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.PredicateLike}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createPredicateLikeAdapter() {
        if (predicateLikeItemProvider == null) {
            predicateLikeItemProvider = new PredicateLikeItemProvider(this);
        }

        return predicateLikeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.PredicateIsNull} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected PredicateIsNullItemProvider predicateIsNullItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.PredicateIsNull}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createPredicateIsNullAdapter() {
        if (predicateIsNullItemProvider == null) {
            predicateIsNullItemProvider = new PredicateIsNullItemProvider(this);
        }

        return predicateIsNullItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedValueSelect} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected PredicateQuantifiedValueSelectItemProvider predicateQuantifiedValueSelectItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedValueSelect}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createPredicateQuantifiedValueSelectAdapter() {
        if (predicateQuantifiedValueSelectItemProvider == null) {
            predicateQuantifiedValueSelectItemProvider = new PredicateQuantifiedValueSelectItemProvider(this);
        }

        return predicateQuantifiedValueSelectItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedRowSelect} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected PredicateQuantifiedRowSelectItemProvider predicateQuantifiedRowSelectItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.PredicateQuantifiedRowSelect}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createPredicateQuantifiedRowSelectAdapter() {
        if (predicateQuantifiedRowSelectItemProvider == null) {
            predicateQuantifiedRowSelectItemProvider = new PredicateQuantifiedRowSelectItemProvider(this);
        }

        return predicateQuantifiedRowSelectItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.PredicateInValueSelect} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected PredicateInValueSelectItemProvider predicateInValueSelectItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.PredicateInValueSelect}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createPredicateInValueSelectAdapter() {
        if (predicateInValueSelectItemProvider == null) {
            predicateInValueSelectItemProvider = new PredicateInValueSelectItemProvider(this);
        }

        return predicateInValueSelectItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.PredicateInValueList} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected PredicateInValueListItemProvider predicateInValueListItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.PredicateInValueList}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createPredicateInValueListAdapter() {
        if (predicateInValueListItemProvider == null) {
            predicateInValueListItemProvider = new PredicateInValueListItemProvider(this);
        }

        return predicateInValueListItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.PredicateInValueRowSelect} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected PredicateInValueRowSelectItemProvider predicateInValueRowSelectItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.PredicateInValueRowSelect}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createPredicateInValueRowSelectAdapter() {
        if (predicateInValueRowSelectItemProvider == null) {
            predicateInValueRowSelectItemProvider = new PredicateInValueRowSelectItemProvider(this);
        }

        return predicateInValueRowSelectItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionSimpleItemProvider valueExpressionSimpleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionSimpleAdapter() {
        if (valueExpressionSimpleItemProvider == null) {
            valueExpressionSimpleItemProvider = new ValueExpressionSimpleItemProvider(this);
        }

        return valueExpressionSimpleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionColumnItemProvider valueExpressionColumnItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionColumnAdapter() {
        if (valueExpressionColumnItemProvider == null) {
            valueExpressionColumnItemProvider = new ValueExpressionColumnItemProvider(this);
        }

        return valueExpressionColumnItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionVariableItemProvider valueExpressionVariableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionVariableAdapter() {
        if (valueExpressionVariableItemProvider == null) {
            valueExpressionVariableItemProvider = new ValueExpressionVariableItemProvider(this);
        }

        return valueExpressionVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionScalarSelect} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionScalarSelectItemProvider valueExpressionScalarSelectItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionScalarSelect}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionScalarSelectAdapter() {
        if (valueExpressionScalarSelectItemProvider == null) {
            valueExpressionScalarSelectItemProvider = new ValueExpressionScalarSelectItemProvider(this);
        }

        return valueExpressionScalarSelectItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionLabeledDuration} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionLabeledDurationItemProvider valueExpressionLabeledDurationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionLabeledDuration}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionLabeledDurationAdapter() {
        if (valueExpressionLabeledDurationItemProvider == null) {
            valueExpressionLabeledDurationItemProvider = new ValueExpressionLabeledDurationItemProvider(this);
        }

        return valueExpressionLabeledDurationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionCastItemProvider valueExpressionCastItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionCastAdapter() {
        if (valueExpressionCastItemProvider == null) {
            valueExpressionCastItemProvider = new ValueExpressionCastItemProvider(this);
        }

        return valueExpressionCastItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionNullValue} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionNullValueItemProvider valueExpressionNullValueItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionNullValue}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionNullValueAdapter() {
        if (valueExpressionNullValueItemProvider == null) {
            valueExpressionNullValueItemProvider = new ValueExpressionNullValueItemProvider(this);
        }

        return valueExpressionNullValueItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionDefaultValue} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionDefaultValueItemProvider valueExpressionDefaultValueItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionDefaultValue}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionDefaultValueAdapter() {
        if (valueExpressionDefaultValueItemProvider == null) {
            valueExpressionDefaultValueItemProvider = new ValueExpressionDefaultValueItemProvider(this);
        }

        return valueExpressionDefaultValueItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionFunctionItemProvider valueExpressionFunctionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionFunction}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionFunctionAdapter() {
        if (valueExpressionFunctionItemProvider == null) {
            valueExpressionFunctionItemProvider = new ValueExpressionFunctionItemProvider(this);
        }

        return valueExpressionFunctionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionCombinedItemProvider valueExpressionCombinedItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCombined}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionCombinedAdapter() {
        if (valueExpressionCombinedItemProvider == null) {
            valueExpressionCombinedItemProvider = new ValueExpressionCombinedItemProvider(this);
        }

        return valueExpressionCombinedItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.GroupingSets} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected GroupingSetsItemProvider groupingSetsItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.GroupingSets}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createGroupingSetsAdapter() {
        if (groupingSetsItemProvider == null) {
            groupingSetsItemProvider = new GroupingSetsItemProvider(this);
        }

        return groupingSetsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementSublist} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected GroupingSetsElementSublistItemProvider groupingSetsElementSublistItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementSublist}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createGroupingSetsElementSublistAdapter() {
        if (groupingSetsElementSublistItemProvider == null) {
            groupingSetsElementSublistItemProvider = new GroupingSetsElementSublistItemProvider(this);
        }

        return groupingSetsElementSublistItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementExpression} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected GroupingSetsElementExpressionItemProvider groupingSetsElementExpressionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementExpression}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createGroupingSetsElementExpressionAdapter() {
        if (groupingSetsElementExpressionItemProvider == null) {
            groupingSetsElementExpressionItemProvider = new GroupingSetsElementExpressionItemProvider(this);
        }

        return groupingSetsElementExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.SuperGroup} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected SuperGroupItemProvider superGroupItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.SuperGroup}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createSuperGroupAdapter() {
        if (superGroupItemProvider == null) {
            superGroupItemProvider = new SuperGroupItemProvider(this);
        }

        return superGroupItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.GroupingExpression} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected GroupingExpressionItemProvider groupingExpressionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.GroupingExpression}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createGroupingExpressionAdapter() {
        if (groupingExpressionItemProvider == null) {
            groupingExpressionItemProvider = new GroupingExpressionItemProvider(this);
        }

        return groupingExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.SuperGroupElementSublist} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected SuperGroupElementSublistItemProvider superGroupElementSublistItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.SuperGroupElementSublist}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createSuperGroupElementSublistAdapter() {
        if (superGroupElementSublistItemProvider == null) {
            superGroupElementSublistItemProvider = new SuperGroupElementSublistItemProvider(this);
        }

        return superGroupElementSublistItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.SuperGroupElementExpression} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected SuperGroupElementExpressionItemProvider superGroupElementExpressionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.SuperGroupElementExpression}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createSuperGroupElementExpressionAdapter() {
        if (superGroupElementExpressionItemProvider == null) {
            superGroupElementExpressionItemProvider = new SuperGroupElementExpressionItemProvider(this);
        }

        return superGroupElementExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionCaseSearchItemProvider valueExpressionCaseSearchItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearch}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionCaseSearchAdapter() {
        if (valueExpressionCaseSearchItemProvider == null) {
            valueExpressionCaseSearchItemProvider = new ValueExpressionCaseSearchItemProvider(this);
        }

        return valueExpressionCaseSearchItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimple} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionCaseSimpleItemProvider valueExpressionCaseSimpleItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimple}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionCaseSimpleAdapter() {
        if (valueExpressionCaseSimpleItemProvider == null) {
            valueExpressionCaseSimpleItemProvider = new ValueExpressionCaseSimpleItemProvider(this);
        }

        return valueExpressionCaseSimpleItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseElse} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionCaseElseItemProvider valueExpressionCaseElseItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseElse}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionCaseElseAdapter() {
        if (valueExpressionCaseElseItemProvider == null) {
            valueExpressionCaseElseItemProvider = new ValueExpressionCaseElseItemProvider(this);
        }

        return valueExpressionCaseElseItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionCaseSearchContentItemProvider valueExpressionCaseSearchContentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSearchContent}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionCaseSearchContentAdapter() {
        if (valueExpressionCaseSearchContentItemProvider == null) {
            valueExpressionCaseSearchContentItemProvider = new ValueExpressionCaseSearchContentItemProvider(this);
        }

        return valueExpressionCaseSearchContentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimpleContent} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionCaseSimpleContentItemProvider valueExpressionCaseSimpleContentItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionCaseSimpleContent}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionCaseSimpleContentAdapter() {
        if (valueExpressionCaseSimpleContentItemProvider == null) {
            valueExpressionCaseSimpleContentItemProvider = new ValueExpressionCaseSimpleContentItemProvider(this);
        }

        return valueExpressionCaseSimpleContentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.TableInDatabase} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected TableInDatabaseItemProvider tableInDatabaseItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.TableInDatabase}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createTableInDatabaseAdapter() {
        if (tableInDatabaseItemProvider == null) {
            tableInDatabaseItemProvider = new TableInDatabaseItemProvider(this);
        }

        return tableInDatabaseItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.TableFunction} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected TableFunctionItemProvider tableFunctionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.TableFunction}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createTableFunctionAdapter() {
        if (tableFunctionItemProvider == null) {
            tableFunctionItemProvider = new TableFunctionItemProvider(this);
        }

        return tableFunctionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ColumnName} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ColumnNameItemProvider columnNameItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ColumnName}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createColumnNameAdapter() {
        if (columnNameItemProvider == null) {
            columnNameItemProvider = new ColumnNameItemProvider(this);
        }

        return columnNameItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.TableNested} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected TableNestedItemProvider tableNestedItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.TableNested}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createTableNestedAdapter() {
        if (tableNestedItemProvider == null) {
            tableNestedItemProvider = new TableNestedItemProvider(this);
        }

        return tableNestedItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.QueryMergeStatement} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected QueryMergeStatementItemProvider queryMergeStatementItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.QueryMergeStatement}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createQueryMergeStatementAdapter() {
        if (queryMergeStatementItemProvider == null) {
            queryMergeStatementItemProvider = new QueryMergeStatementItemProvider(this);
        }

        return queryMergeStatementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.SearchConditionNested} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected SearchConditionNestedItemProvider searchConditionNestedItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.SearchConditionNested}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createSearchConditionNestedAdapter() {
        if (searchConditionNestedItemProvider == null) {
            searchConditionNestedItemProvider = new SearchConditionNestedItemProvider(this);
        }

        return searchConditionNestedItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected ValueExpressionNestedItemProvider valueExpressionNestedItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createValueExpressionNestedAdapter() {
        if (valueExpressionNestedItemProvider == null) {
            valueExpressionNestedItemProvider = new ValueExpressionNestedItemProvider(this);
        }

        return valueExpressionNestedItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.OrderByOrdinal} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected OrderByOrdinalItemProvider orderByOrdinalItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.OrderByOrdinal}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createOrderByOrdinalAdapter() {
        if (orderByOrdinalItemProvider == null) {
            orderByOrdinalItemProvider = new OrderByOrdinalItemProvider(this);
        }

        return orderByOrdinalItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.TableCorrelation} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected TableCorrelationItemProvider tableCorrelationItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.TableCorrelation}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createTableCorrelationAdapter() {
        if (tableCorrelationItemProvider == null) {
            tableCorrelationItemProvider = new TableCorrelationItemProvider(this);
        }

        return tableCorrelationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.UpdateSource} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected UpdateSourceItemProvider updateSourceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.UpdateSource}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createUpdateSourceAdapter() {
        if (updateSourceItemProvider == null) {
            updateSourceItemProvider = new UpdateSourceItemProvider(this);
        }

        return updateSourceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.UpdateSourceExprList} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected UpdateSourceExprListItemProvider updateSourceExprListItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.UpdateSourceExprList}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createUpdateSourceExprListAdapter() {
        if (updateSourceExprListItemProvider == null) {
            updateSourceExprListItemProvider = new UpdateSourceExprListItemProvider(this);
        }

        return updateSourceExprListItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.UpdateSourceQuery} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected UpdateSourceQueryItemProvider updateSourceQueryItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.UpdateSourceQuery}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createUpdateSourceQueryAdapter() {
        if (updateSourceQueryItemProvider == null) {
            updateSourceQueryItemProvider = new UpdateSourceQueryItemProvider(this);
        }

        return updateSourceQueryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.OrderByResultColumn} instances.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  protected OrderByResultColumnItemProvider orderByResultColumnItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.OrderByResultColumn}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter createOrderByResultColumnAdapter() {
        if (orderByResultColumnItemProvider == null) {
            orderByResultColumnItemProvider = new OrderByResultColumnItemProvider(this);
        }

        return orderByResultColumnItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.WithTableReference} instances.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	protected WithTableReferenceItemProvider withTableReferenceItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.WithTableReference}.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	public Adapter createWithTableReferenceAdapter() {
        if (withTableReferenceItemProvider == null) {
            withTableReferenceItemProvider = new WithTableReferenceItemProvider(this);
        }

        return withTableReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.datatools.modelbase.sql.query.QueryNested} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected QueryNestedItemProvider queryNestedItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.datatools.modelbase.sql.query.QueryNested}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Adapter createQueryNestedAdapter() {
        if (queryNestedItemProvider == null) {
            queryNestedItemProvider = new QueryNestedItemProvider(this);
        }

        return queryNestedItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
     * @generated
     */
  public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

}
