/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.rhino.debugger;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.AbstractEaseDebugger;
import org.eclipse.ease.debugging.EaseDebugFrame;
import org.eclipse.ease.debugging.IScriptDebugFrame;
import org.eclipse.ease.lang.javascript.rhino.RhinoScriptEngine;
import org.eclipse.ease.lang.javascript.rhino.debugger.RhinoDebuggerEngine;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;

public class RhinoDebugger
extends AbstractEaseDebugger
implements Debugger {
    private static final Pattern PROTOTYPE_PATTERN = Pattern.compile("^(.*)\\.prototype\\.(.*)\\s*=\\s*function\\(.*$");
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("^\\s*(.*)\\s:\\sfunction\\(.*$");
    private static final Pattern ANONYMOUS_PATTERN = Pattern.compile("^.*function\\(.*$");
    private final Map<Integer, Script> fFrameToSource = new HashMap<Integer, Script>();
    private Script fLastScript = null;

    private static DebuggableScript getParentScript(DebuggableScript rhinoScript) {
        while (rhinoScript.getParent() != null) {
            rhinoScript = rhinoScript.getParent();
        }
        return rhinoScript;
    }

    public RhinoDebugger(RhinoDebuggerEngine engine, boolean showDynamicCode) {
        super((IDebugEngine)engine, showDynamicCode);
    }

    protected RhinoDebuggerEngine getEngine() {
        return (RhinoDebuggerEngine)super.getEngine();
    }

    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
    }

    public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
        if (fnOrScript.getParent() == null && this.isTrackedScript(this.fLastScript)) {
            this.fFrameToSource.put(fnOrScript.hashCode(), this.fLastScript);
        }
        Script script = this.fFrameToSource.get(RhinoDebugger.getParentScript(fnOrScript).hashCode());
        RhinoDebugFrame debugFrame = new RhinoDebugFrame(fnOrScript, script);
        this.getStacktrace().add(0, (Object)debugFrame);
        return debugFrame;
    }

    public void notify(IScriptEngine engine, Script script, int status) {
        switch (status) {
            case 3: 
            case 5: {
                this.fLastScript = script;
                break;
            }
            case 2: {
                this.fFrameToSource.clear();
                this.fLastScript = null;
                break;
            }
        }
        super.notify(engine, script, status);
    }

    public class RhinoDebugFrame
    extends EaseDebugFrame
    implements DebugFrame,
    IScriptDebugFrame {
        private final String fFunctionName;
        private Scriptable fScope;

        public RhinoDebugFrame(DebuggableScript fnOrScript, Script script) {
            super(script, 0, fnOrScript.isFunction() ? 2 : 1);
            this.fFunctionName = this.getFunctionName(fnOrScript);
        }

        private String getFunctionName(DebuggableScript fnOrScript) {
            int[] lineNumbers;
            String candidate = fnOrScript.getFunctionName();
            if (candidate == null && this.getScript() != null && (lineNumbers = fnOrScript.getLineNumbers()).length > 0) {
                int headerLineNumber = this.getFirstLineNumber(lineNumbers);
                try {
                    String definitionLine = this.getLineOfCode(this.getScript().getCode(), headerLineNumber);
                    if (definitionLine != null) {
                        definitionLine = definitionLine.trim();
                        Matcher matcher = PROTOTYPE_PATTERN.matcher(definitionLine);
                        if (matcher.matches()) {
                            return String.valueOf(matcher.group(1).trim()) + ":" + matcher.group(2).trim();
                        }
                        matcher = PROPERTY_PATTERN.matcher(definitionLine);
                        if (matcher.matches()) {
                            return matcher.group(1).trim();
                        }
                        if (ANONYMOUS_PATTERN.matcher(definitionLine).matches()) {
                            return "<anonymous function>";
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return candidate;
        }

        private String getLineOfCode(String code, int lineNumber) {
            String[] lines = code.split("\n");
            if (lines.length >= lineNumber) {
                return lines[lineNumber - 1];
            }
            return null;
        }

        private int getFirstLineNumber(int[] lineNumbers) {
            int firstLine = lineNumbers[0];
            int[] nArray = lineNumbers;
            int n = lineNumbers.length;
            int n2 = 0;
            while (n2 < n) {
                int lineNumber = nArray[n2];
                if (lineNumber < firstLine) {
                    firstLine = lineNumber;
                }
                ++n2;
            }
            return firstLine;
        }

        public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
            this.fScope = activation;
            if (this.getScript() != null) {
                RhinoDebugger.this.processLine(this.getScript(), this.getLineNumber());
            }
        }

        public void onLineChange(Context cx, int lineNumber) {
            this.setLineNumber(lineNumber);
            if (this.getScript() != null) {
                RhinoDebugger.this.processLine(this.getScript(), this.getLineNumber());
            }
        }

        public void onExceptionThrown(Context cx, Throwable ex) {
            RhinoDebugger.this.setExceptionStacktrace(RhinoDebugger.this.getStacktrace().clone());
        }

        public void onExit(Context cx, boolean byThrow, Object resultOrException) {
            RhinoDebugger.this.getStacktrace().remove((Object)this);
            this.fScope = null;
            if (this.getScript() != null) {
                RhinoDebugger.this.processLine(this.getScript(), this.getLineNumber());
            }
        }

        public void onDebuggerStatement(Context cx) {
        }

        public String getName() {
            if (this.getType() == 2) {
                return this.fFunctionName != null ? String.valueOf(this.fFunctionName) + "()" : "";
            }
            return "";
        }

        public Map<String, Object> getVariables() {
            Map result = RhinoDebugger.this.getEngine().getVariables(this.fScope);
            return result;
        }

        public void setVariable(String name, Object content) {
            RhinoDebugger.this.getEngine().setVariable(name, content, this.fScope);
        }

        public Object inject(String expression) throws Throwable {
            StringReader reader = new StringReader(expression);
            return RhinoScriptEngine.getContext().evaluateReader(this.fScope, (Reader)reader, null, 1, null);
        }
    }
}

