/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.custom.model.impl;

import java.util.Set;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.custom.model.ECPHardcodedReferences;
import org.eclipse.emf.ecp.view.spi.custom.model.VCustomDomainModelReference;
import org.eclipse.emf.ecp.view.spi.custom.model.impl.VCustomDomainModelReferenceImpl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DomainModelReferenceConverter;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component
public class CustomDMRConverter
implements DomainModelReferenceConverter {
    private EMFFormsDatabinding emfFormsDatabinding;
    private ServiceReference<EMFFormsDatabinding> databindingServiceReference;

    @Activate
    protected final void activate(BundleContext bundleContext) {
        this.databindingServiceReference = bundleContext.getServiceReference(EMFFormsDatabinding.class);
        this.emfFormsDatabinding = (EMFFormsDatabinding)bundleContext.getService(this.databindingServiceReference);
    }

    @Deactivate
    protected final void deactivate(BundleContext bundleContext) {
        bundleContext.ungetService(this.databindingServiceReference);
        this.emfFormsDatabinding = null;
    }

    public double isApplicable(VDomainModelReference domainModelReference) {
        if (VCustomDomainModelReference.class.isInstance(domainModelReference)) {
            return 5.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public IValueProperty convertToValueProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VCustomDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VTableDomainModelReference.");
        }
        VCustomDomainModelReference tableDomainModelReference = (VCustomDomainModelReference)VCustomDomainModelReference.class.cast(domainModelReference);
        ECPHardcodedReferences customControl = CustomDMRConverter.loadObject(tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName());
        if (customControl == null) {
            throw new DatabindingFailedException(String.format("The provided ECPHardcodedReferences from Bundle %1$s Class %2$s cannot be resolved.", tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName()));
        }
        Set<VDomainModelReference> neededDomainModelReferences = customControl.getNeededDomainModelReferences();
        if (neededDomainModelReferences.isEmpty()) {
            throw new DatabindingFailedException(String.format("The provided ECPHardcodedReferences from Bundle %1$s Class %2$s doesn't define any DomainModelReferences.", tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName()));
        }
        return this.emfFormsDatabinding.getValueProperty(neededDomainModelReferences.iterator().next(), object);
    }

    private static ECPHardcodedReferences loadObject(String bundleName, String clazz) throws DatabindingFailedException {
        Class loadClass;
        block6: {
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle == null) {
                new ClassNotFoundException(String.format(LocalizationServiceHelper.getString(VCustomDomainModelReferenceImpl.class, (String)"BundleNotFound_ExceptionMessage"), clazz, bundleName));
                return null;
            }
            loadClass = bundle.loadClass(clazz);
            if (ECPHardcodedReferences.class.isAssignableFrom(loadClass)) break block6;
            return null;
        }
        try {
            return (ECPHardcodedReferences)ECPHardcodedReferences.class.cast(loadClass.newInstance());
        }
        catch (ClassNotFoundException ex) {
            throw new DatabindingFailedException(ex.getMessage());
        }
        catch (InstantiationException ex) {
            throw new DatabindingFailedException(ex.getMessage());
        }
        catch (IllegalAccessException ex) {
            throw new DatabindingFailedException(ex.getMessage());
        }
    }

    public IListProperty convertToListProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (!VCustomDomainModelReference.class.isInstance(domainModelReference)) {
            throw new IllegalArgumentException("DomainModelReference must be an instance of VTableDomainModelReference.");
        }
        VCustomDomainModelReference tableDomainModelReference = (VCustomDomainModelReference)VCustomDomainModelReference.class.cast(domainModelReference);
        ECPHardcodedReferences customControl = CustomDMRConverter.loadObject(tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName());
        if (customControl == null) {
            throw new DatabindingFailedException(String.format("The provided ECPHardcodedReferences from Bundle %1$s Class %2$s cannot be resolved.", tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName()));
        }
        Set<VDomainModelReference> neededDomainModelReferences = customControl.getNeededDomainModelReferences();
        if (neededDomainModelReferences.isEmpty()) {
            throw new DatabindingFailedException(String.format("The provided ECPHardcodedReferences from Bundle %1$s Class %2$s doesn't define any DomainModelReferences.", tableDomainModelReference.getBundleName(), tableDomainModelReference.getClassName()));
        }
        return this.emfFormsDatabinding.getListProperty(neededDomainModelReferences.iterator().next(), object);
    }
}

