/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.merge;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.common.MetamodelFactory;
import org.eclipse.emf.edapt.internal.common.MetamodelUtils;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="partitionReference", label="Partition Reference", description="In the metamodel, a reference is partitioned into a number of references according to its type. A sub reference is created for each subclass of the reference's type. Finally, the original reference is deleted. In the model, the value of the reference is partitioned accordingly.")
public class PartitionReference
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference to be partitioned")
    public EReference reference;

    @EdaptConstraint(restricts="reference", description="The reference must be multi-valued")
    public boolean checkReferenceMany(EReference reference) {
        return reference.isMany();
    }

    @EdaptConstraint(restricts="reference", description="The type of the reference must be abstract")
    public boolean checkReferenceTypeAbstract(EReference reference) {
        EClass type = reference.getEReferenceType();
        return !MetamodelUtils.isConcrete((EClass)type);
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EClass contextClass = this.reference.getEContainingClass();
        EClass type = this.reference.getEReferenceType();
        ArrayList<EReference> subReferences = new ArrayList<EReference>();
        for (EClass subClass : metamodel.getESubTypes(type)) {
            String name = String.valueOf(subClass.getName().substring(0, 1).toLowerCase()) + subClass.getName().substring(1);
            EReference subReference = MetamodelFactory.newEReference((EClass)contextClass, (String)name, (EClass)subClass, (int)0, (int)-1, (boolean)this.reference.isContainment());
            subReferences.add(subReference);
        }
        metamodel.delete((EModelElement)this.reference);
        for (Instance instance : model.getAllInstances(contextClass)) {
            List values = (List)instance.unset((EStructuralFeature)this.reference);
            for (Instance value : values) {
                EReference subReference = this.getReferenceForInstance(subReferences, value);
                instance.add((EStructuralFeature)subReference, (Object)value);
            }
        }
    }

    private EReference getReferenceForInstance(List<EReference> references, Instance value) {
        for (EReference reference : references) {
            if (!value.instanceOf(reference.getEReferenceType())) continue;
            return reference;
        }
        return null;
    }
}

