/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.dependent;

import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import org.jboss.cdi.tck.tests.context.dependent.DomesticationKit;
import org.jboss.cdi.tck.tests.context.dependent.Fox;
import org.jboss.cdi.tck.tests.context.dependent.Pet;
import org.jboss.cdi.tck.tests.context.dependent.Tarantula;

public class SpiderProducer {
    @Inject
    private BeanManager beanManager;
    private static boolean dependentContextActive = false;
    private static boolean destroyed = false;
    private static Integer instanceUsedForDisposalHashcode = null;
    private static Integer instanceUsedForProducerHashcode = null;
    private static Integer foxUsedForDisposalHashcode = null;

    @Produces
    @Pet
    public Tarantula produceTarantula(Tarantula spider, DomesticationKit domesticationKit) {
        dependentContextActive = this.beanManager.getContext(Dependent.class).isActive();
        instanceUsedForProducerHashcode = this.hashCode();
        return spider;
    }

    public void disposeTarantula(@Disposes @Pet Tarantula tarantula, Fox fox) {
        dependentContextActive = this.beanManager.getContext(Dependent.class).isActive();
        instanceUsedForDisposalHashcode = this.hashCode();
        foxUsedForDisposalHashcode = fox.hashCode();
    }

    public static boolean isDependentContextActive() {
        return dependentContextActive;
    }

    public static Integer getInstanceUsedForDisposalHashcode() {
        return instanceUsedForDisposalHashcode;
    }

    public static Integer getInstanceUsedForProducerHashcode() {
        return instanceUsedForProducerHashcode;
    }

    public static Integer getFoxUsedForDisposalHashcode() {
        return foxUsedForDisposalHashcode;
    }

    public static boolean isDestroyed() {
        return destroyed;
    }

    public static void reset() {
        destroyed = false;
        dependentContextActive = false;
        instanceUsedForDisposalHashcode = null;
        instanceUsedForProducerHashcode = null;
        foxUsedForDisposalHashcode = null;
    }

    @PreDestroy
    public void destroy() {
        destroyed = true;
    }
}

