/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.alternative.metadata;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Bill;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Bread;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Carrot;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Cheap;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.CheapLiteral;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Expensive;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.ExpensiveLiteral;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Grocery;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.GroceryInterceptor;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.GroceryWrapper;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Market;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.MarketWrapper;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Milk;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Pasta;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.ProcessAnnotatedTypeObserver;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Sausage;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Shop;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.TropicalFruit;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Vegetables;
import org.jboss.cdi.tck.tests.extensions.alternative.metadata.Yogurt;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class AlternativeMetadataTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AlternativeMetadataTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{GroceryInterceptor.class.getName()}).up())).withExtension(ProcessAnnotatedTypeObserver.class)).build();
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="ha")
    public void testGetBaseTypeUsedToDetermineTypeOfInjectionPoint() {
        Assert.assertTrue((boolean)GroceryWrapper.isGetBaseTypeOfFruitFieldUsed());
        Assert.assertEquals((Object)this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getFruit().getMetadata().getType(), TropicalFruit.class);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="hb")
    public void testGetBaseTypeUsedToDetermineTypeOfInitializerInjectionPoint() {
        Assert.assertEquals((Object)this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getInitializerFruit().getMetadata().getType(), TropicalFruit.class);
        Assert.assertTrue((boolean)GroceryWrapper.isGetBaseTypeOfInitializerTropicalFruitParameterUsed());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="alternative_metadata_sources", id="hc"), @SpecAssertion(section="alternative_metadata_sources", id="s")})
    public void testGetBaseTypeUsedToDetermineTypeOfConstructorInjectionPoint() {
        Assert.assertEquals((Object)this.getContextualReference(Market.class, new Annotation[0]).getConstructorFruit().getMetadata().getType(), TropicalFruit.class);
        Assert.assertTrue((boolean)MarketWrapper.isGetBaseTypeOfMarketConstructorParameterUsed());
        Assert.assertTrue((boolean)this.getContextualReference(Market.class, new Annotation[0]).getConstructorFruit().getMetadata().getQualifiers().contains(Any.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="hd")
    public void testGetBaseTypeUsedToDetermineTypeOfProducerInjectionPoint() {
        Assert.assertEquals((Object)this.getContextualReference(Bill.class, new ExpensiveLiteral()).getFruit().getMetadata().getType(), TropicalFruit.class);
        Assert.assertTrue((boolean)MarketWrapper.isGetBaseTypeOfBillProducerParameterUsed());
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="he")
    public void testGetBaseTypeUsedToDetermineTypeOfObserverInjectionPoint() {
        this.getCurrentManager().fireEvent((Object)new Milk(false), new Annotation[0]);
        Assert.assertEquals((Object)this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getObserverFruit().getMetadata().getType(), TropicalFruit.class);
        Assert.assertTrue((boolean)GroceryWrapper.isGetBaseTypeOfObserverInjectionPointUsed());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="alternative_metadata_sources", id="hf"), @SpecAssertion(section="alternative_metadata_sources", id="ad")})
    public void testGetBaseTypeUsedToDetermineTypeOfDisposerInjectionPoint() {
        Bean<Bill> bill = this.getBeans(Bill.class, new CheapLiteral()).iterator().next();
        CreationalContext context = this.getCurrentManager().createCreationalContext(bill);
        Bill instance = (Bill)this.getCurrentManager().getContext(bill.getScope()).get(bill);
        bill.destroy((Object)instance, context);
        Assert.assertEquals((Object)this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getDisposerFruit().getMetadata().getType(), TropicalFruit.class);
        Assert.assertTrue((boolean)GroceryWrapper.isGetBaseTypeOfBillDisposerParameterUsed());
        Assert.assertTrue((boolean)this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getDisposerFruit().getMetadata().getQualifiers().contains(Any.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="i")
    public void testGetBaseTypeUsedToDetermineTypeOfEventParameter() {
        this.getCurrentManager().fireEvent((Object)new Carrot(), new Annotation[0]);
        Assert.assertEquals(this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getWrappedEventParameter().getClass(), Carrot.class);
        Assert.assertTrue((boolean)GroceryWrapper.isGetBaseTypeOfObserverParameterUsed());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="alternative_metadata_sources", id="j"), @SpecAssertion(section="alternative_metadata_sources", id="ac")})
    public void testGetBaseTypeUsedToDetermineTypeOfDisposalParameter() throws NoSuchMethodException {
        Bean<Carrot> carrot = this.getBeans(Carrot.class, new CheapLiteral()).iterator().next();
        CreationalContext context = this.getCurrentManager().createCreationalContext(carrot);
        Carrot instance = (Carrot)this.getCurrentManager().getContext(carrot.getScope()).get(carrot, context);
        carrot.destroy((Object)instance, context);
        Assert.assertNotNull((Object)this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getWrappedDisposalParameter());
        Assert.assertEquals(this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getWrappedDisposalParameter().getClass(), Carrot.class);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="ka")
    public void testGetTypeClosureUsed() {
        Assert.assertTrue((boolean)GroceryWrapper.isGetTypeClosureUsed());
        Assert.assertEquals((int)this.getBeans(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).iterator().next().getTypes().size(), (int)2);
        Assert.assertEquals((int)this.getBeans(Shop.class, new Annotation[]{Any.Literal.INSTANCE}).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources_ee", id="kb")
    public void testGetTypeClosureUsedToDetermineTypeOfSessionBean() {
        Bean<Pasta> pasta = this.getBeans(Pasta.class, new Annotation[0]).iterator().next();
        Assert.assertEquals((int)pasta.getTypes().size(), (int)2);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="kc")
    public void testGetTypeClosureUsedToDetermineTypeOfProducerField() {
        Bean<Carrot> carrot = this.getBeans(Carrot.class, new ExpensiveLiteral()).iterator().next();
        Assert.assertEquals((int)carrot.getTypes().size(), (int)1);
        Assert.assertEquals(carrot.getTypes().iterator().next(), Carrot.class);
        Assert.assertTrue((boolean)MarketWrapper.isGetTypeCLosureOfProducerFieldUsed());
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="kd")
    public void testGetTypeClosureUsedToDetermineTypeOfProducerMethod() {
        Bean<Carrot> carrot = this.getBeans(Carrot.class, new CheapLiteral()).iterator().next();
        Assert.assertEquals((int)carrot.getTypes().size(), (int)2);
        Assert.assertFalse((boolean)carrot.getTypes().contains(Vegetables.class));
        Assert.assertTrue((boolean)GroceryWrapper.isGetTypeClosureOfProducerMethodUsed());
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="l")
    public void testGetAnnotationUsedForGettingScopeInformation() {
        Assert.assertEquals((Object)this.getBeans(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).iterator().next().getScope(), RequestScoped.class);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="m")
    public void testGetAnnotationUsedForGettingQualifierInformation() {
        Assert.assertEquals((int)this.getBeans(Grocery.class, new CheapLiteral()).size(), (int)1);
        Assert.assertEquals((int)this.getBeans(Grocery.class, new ExpensiveLiteral()).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="n")
    public void testGetAnnotationUsedForGettingStereotypeInformation() {
        Assert.assertNotNull((Object)this.getContextualReference("grocery", Grocery.class));
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="p")
    public void testGetAnnotationUsedForGettingInterceptorInformation() {
        Grocery grocery = this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE});
        Assert.assertEquals((String)grocery.foo(), (String)"foo");
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="r")
    public void testPreviouslyNonInjectAnnotatedConstructorIsUsed() {
        Assert.assertTrue((boolean)this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).isConstructorWithParameterUsed());
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="t")
    public void testPreviouslyNonInjectAnnotatedFieldIsInjected() {
        Assert.assertTrue((boolean)this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).isVegetablesInjected());
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="u")
    public void testExtraQualifierIsAppliedToInjectedField() {
        Assert.assertNotNull((Object)this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getFruit());
        Set qualifiers = this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getFruit().getMetadata().getQualifiers();
        Assert.assertEquals((int)qualifiers.size(), (int)1);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)qualifiers, Cheap.class));
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="v")
    public void testProducesCreatesProducerField() {
        Assert.assertEquals((int)this.getBeans(Bread.class, new Annotation[]{Any.Literal.INSTANCE}).size(), (int)1);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="w")
    public void testInjectCreatesInitializerMethod() {
        Assert.assertTrue((boolean)this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).isWaterInjected());
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="x")
    public void testQualifierAddedToInitializerParameter() {
        Set qualifiers = this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getInitializerFruit().getMetadata().getQualifiers();
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)qualifiers, Cheap.class));
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="y")
    public void testProducesCreatesProducerMethod() {
        Assert.assertEquals((int)this.getBeans(Milk.class, new Annotation[]{Any.Literal.INSTANCE}).size(), (int)1);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="z")
    public void testQualifierIsAppliedToProducerMethod() {
        Assert.assertEquals((int)this.getBeans(Yogurt.class, new ExpensiveLiteral()).size(), (int)1);
        Assert.assertEquals((int)this.getBeans(Yogurt.class, new CheapLiteral()).size(), (int)0);
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="aa")
    public void testQualifierIsAppliedToProducerMethodParameter() {
        Set qualifiers = this.getContextualReference(Yogurt.class, new Annotation[]{Any.Literal.INSTANCE}).getFruit().getMetadata().getQualifiers();
        Assert.assertEquals((int)qualifiers.size(), (int)1);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)qualifiers, Cheap.class));
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="ab")
    public void testDisposesIsAppliedToMethodParameter() {
        Bean<Yogurt> yogurt = this.getBeans(Yogurt.class, new ExpensiveLiteral()).iterator().next();
        CreationalContext context = this.getCurrentManager().createCreationalContext(yogurt);
        Yogurt instance = (Yogurt)this.getCurrentManager().getContext(yogurt.getScope()).get(yogurt, context);
        yogurt.destroy((Object)instance, context);
        Assert.assertTrue((boolean)Grocery.isDisposerMethodCalled());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="alternative_metadata_sources", id="ae"), @SpecAssertion(section="alternative_metadata_sources", id="ag")})
    public void testObserverMethod() {
        this.getCurrentManager().fireEvent((Object)new Milk(true), new Annotation[0]);
        Milk event = this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getObserverEvent();
        TropicalFruit parameter = this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).getObserverParameter();
        Assert.assertNotNull((Object)event);
        Assert.assertNotNull((Object)parameter);
        Assert.assertEquals((int)parameter.getMetadata().getQualifiers().size(), (int)1);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)parameter.getMetadata().getQualifiers(), Cheap.class));
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="af")
    public void testExtraQualifierAppliedToObservesMethodParameter() {
        this.getCurrentManager().fireEvent((Object)new Bread(true), new Annotation[0]);
        Assert.assertFalse((boolean)this.getContextualReference(Grocery.class, new Annotation[]{Any.Literal.INSTANCE}).isObserver2Used());
    }

    @Test
    @SpecAssertion(section="alternative_metadata_sources", id="h")
    public void testContainerUsesOperationsOfAnnotatedNotReflectionApi() {
        Assert.assertEquals((int)this.getBeans(Sausage.class, new Annotation[]{Any.Literal.INSTANCE}).size(), (int)1);
        Assert.assertTrue((boolean)this.getBeans(Sausage.class, new Annotation[]{new AnnotationLiteral<Expensive>(){}}).isEmpty());
        Assert.assertTrue((boolean)this.getBeans(Sausage.class, new Annotation[]{new AnnotationLiteral<Cheap>(){}}).isEmpty());
    }
}

