/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.admin;

import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.resource.ResourceException;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.concurrent.config.ManagedExecutorService;
import org.glassfish.concurrent.config.ManagedExecutorServiceBase;
import org.glassfish.concurrent.config.ManagedScheduledExecutorService;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.glassfish.resourcebase.resources.util.BindableResourcesHelper;
import org.glassfish.resources.admin.cli.ResourceManager;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

public abstract class ManagedExecutorServiceBaseManager
implements ResourceManager {
    protected static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(ManagedExecutorServiceBaseManager.class);
    protected String jndiName;
    protected String description;
    protected String threadPriority = Integer.toString(5);
    protected String contextInfoEnabled = Boolean.TRUE.toString();
    protected String contextInfo = "Classloader,JNDI,Security,WorkArea";
    protected String longRunningTasks = Boolean.FALSE.toString();
    protected String hungAfterSeconds = "0";
    protected String hungLoggerPrintOnce = Boolean.FALSE.toString();
    protected String hungLoggerInitialDelaySeconds = "60";
    protected String hungLoggerIntervalSeconds = "60";
    protected String corePoolSize = "0";
    protected String keepAliveSeconds = "60";
    protected String threadLifetimeSeconds = "0";
    protected String enabled = Boolean.TRUE.toString();
    protected String enabledValueForTarget = Boolean.TRUE.toString();
    @Inject
    protected ResourceUtil resourceUtil;
    @Inject
    protected ServerEnvironment environment;
    @Inject
    protected BindableResourcesHelper resourcesHelper;

    public abstract String getResourceType();

    public ResourceStatus create(Resources resources, HashMap attributes, Properties properties, String target) throws Exception {
        this.setAttributes(attributes, target);
        ResourceStatus validationStatus = this.isValid(resources, true, target);
        if (validationStatus.getStatus() == 1) {
            return validationStatus;
        }
        try {
            ConfigSupport.apply(param -> this.createResource((Resources)param, properties), resources);
            if (!"domain".equals(target)) {
                this.resourceUtil.createResourceRef(this.jndiName, this.enabledValueForTarget, target);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = I18N.getLocalString("create.managed.executor.service.failed", "Managed executor service {0} creation failed", new Object[]{this.jndiName}) + tfe.getLocalizedMessage();
            if ("managed-scheduled-executor-service".equals(this.getResourceType())) {
                msg = I18N.getLocalString("create.managed.scheduled.executor.service.failed", "Managed scheduled executor service {0} creation failed", new Object[]{this.jndiName}) + tfe.getLocalizedMessage();
            }
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = I18N.getLocalString("create.managed.executor.service.success", "Managed executor service {0} created successfully", new Object[]{this.jndiName});
        if ("managed-scheduled-executor-service".equals(this.getResourceType())) {
            msg = I18N.getLocalString("create.managed.scheduled.executor.service.success", "Managed scheduled executor service {0} created successfully", new Object[]{this.jndiName});
        }
        return new ResourceStatus(0, msg);
    }

    protected ResourceStatus isValid(Resources resources, boolean validateResourceRef, String target) {
        if (this.jndiName == null) {
            String msg = I18N.getLocalString("managed.executor.service.noJndiName", "No JNDI name defined for managed executor service.");
            if ("managed-scheduled-executor-service".equals(this.getResourceType())) {
                msg = I18N.getLocalString("managed.scheduled.executor.service.noJndiName", "No JNDI name defined for managed scheduled executor service.");
            }
            return new ResourceStatus(1, msg);
        }
        Class clazz = "managed-scheduled-executor-service".equals(this.getResourceType()) ? ManagedScheduledExecutorService.class : ManagedExecutorService.class;
        return this.resourcesHelper.validateBindableResourceForDuplicates(resources, this.jndiName, validateResourceRef, target, clazz);
    }

    protected void setAttributes(Map<String, String> attributes, String target) {
        this.jndiName = attributes.get("jndi-name");
        this.description = attributes.get("description");
        this.contextInfo = attributes.get("context-info");
        this.contextInfoEnabled = attributes.get("context-info-enabled");
        this.threadPriority = attributes.get("thread-priority");
        this.longRunningTasks = attributes.get("long-runnings-tasks");
        this.hungAfterSeconds = attributes.get("hung-after-seconds");
        this.hungLoggerPrintOnce = attributes.get("hung-logger-print-once");
        this.hungLoggerInitialDelaySeconds = attributes.get("hung-logger-initial-delay-seconds");
        this.hungLoggerIntervalSeconds = attributes.get("hung-logger-interval-seconds");
        this.corePoolSize = attributes.get("core-pool-size");
        this.keepAliveSeconds = attributes.get("keep-alive-seconds");
        this.threadLifetimeSeconds = attributes.get("thread-lifetime-seconds");
        this.enabled = target == null ? attributes.get("enabled") : this.resourceUtil.computeEnabledValueForResourceBasedOnTarget(attributes.get("enabled"), target);
        this.enabledValueForTarget = attributes.get("enabled");
    }

    protected ManagedExecutorServiceBase createResource(Resources param, Properties properties) throws PropertyVetoException, TransactionFailure {
        ManagedExecutorServiceBase newResource = this.createConfigBean(param, properties);
        param.getResources().add(newResource);
        return newResource;
    }

    protected abstract ManagedExecutorServiceBase createConfigBean(Resources var1, Properties var2) throws PropertyVetoException, TransactionFailure;

    protected void setAttributesOnConfigBean(ManagedExecutorServiceBase managedExecutorService, Properties properties) throws PropertyVetoException, TransactionFailure {
        managedExecutorService.setJndiName(this.jndiName);
        if (this.description != null) {
            managedExecutorService.setDescription(this.description);
        }
        managedExecutorService.setContextInfoEnabled(this.contextInfoEnabled);
        managedExecutorService.setContextInfo(this.contextInfo);
        managedExecutorService.setThreadPriority(this.threadPriority);
        managedExecutorService.setHungAfterSeconds(this.hungAfterSeconds);
        managedExecutorService.setHungLoggerPrintOnce(this.hungLoggerPrintOnce);
        managedExecutorService.setHungLoggerInitialDelaySeconds(this.hungLoggerInitialDelaySeconds);
        managedExecutorService.setHungLoggerIntervalSeconds(this.hungLoggerIntervalSeconds);
        managedExecutorService.setCorePoolSize(this.corePoolSize);
        managedExecutorService.setKeepAliveSeconds(this.keepAliveSeconds);
        managedExecutorService.setThreadLifetimeSeconds(this.threadLifetimeSeconds);
        managedExecutorService.setEnabled(this.enabled);
        managedExecutorService.setLongRunningTasks(this.longRunningTasks);
        if (properties != null) {
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                Property prop = managedExecutorService.createChild(Property.class);
                prop.setName((String)e.getKey());
                prop.setValue((String)e.getValue());
                managedExecutorService.getProperty().add(prop);
            }
        }
    }

    public Resource createConfigBean(Resources resources, HashMap attributes, Properties properties, boolean validate) throws Exception {
        this.setAttributes(attributes, null);
        ResourceStatus status = null;
        status = validate ? this.isValid(resources, false, null) : new ResourceStatus(0, "");
        if (status.getStatus() == 0) {
            return this.createConfigBean(resources, properties);
        }
        throw new ResourceException(status.getMessage());
    }

    public ResourceStatus delete(Resources resources, String jndiName, String target) throws Exception {
        if (jndiName == null) {
            String msg = I18N.getLocalString("managed.executor.service.noJndiName", "No JNDI name defined for managed executor service.");
            if ("managed-scheduled-executor-service".equals(this.getResourceType())) {
                msg = I18N.getLocalString("managed.scheduled.executor.service.noJndiName", "No JNDI name defined for managed scheduled executor service.");
            }
            return new ResourceStatus(1, msg);
        }
        SimpleJndiName simpleJndiName = new SimpleJndiName(jndiName);
        Object resource = "managed-executor-service".equals(this.getResourceType()) ? resources.getResourceByName(ManagedExecutorService.class, simpleJndiName) : ("managed-scheduled-executor-service".equals(this.getResourceType()) ? resources.getResourceByName(ManagedScheduledExecutorService.class, simpleJndiName) : null);
        if (resource == null) {
            String msg = I18N.getLocalString("delete.managed.executor.service.notfound", "A managed executor service named {0} does not exist.", new Object[]{jndiName});
            if ("managed-scheduled-executor-service".equals(this.getResourceType())) {
                msg = I18N.getLocalString("delete.managed.scheduled.executor.service.notfound", "A managed scheduled executor service named {0} does not exist.", new Object[]{jndiName});
            }
            return new ResourceStatus(1, msg);
        }
        if ("system-all-req".equals(resource.getObjectType())) {
            String msg = I18N.getLocalString("delete.concurrent.resource.notAllowed", "The {0} resource cannot be deleted as it is required to be configured in the system.", new Object[]{jndiName});
            return new ResourceStatus(1, msg);
        }
        if (this.environment.isDas()) {
            if ("domain".equals(target)) {
                if (!this.resourceUtil.getTargetsReferringResourceRef(simpleJndiName).isEmpty()) {
                    String msg = I18N.getLocalString("delete.managed.executor.service.resource-ref.exist", "This managed executor service [ {0} ] is referenced in an instance/cluster target, use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    if ("managed-scheduled-executor-service".equals(this.getResourceType())) {
                        msg = I18N.getLocalString("delete.managed.scheduled.executor.service.resource-ref.exist", "This managed scheduled executor service [ {0} ] is referenced in an instance/cluster target, use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    }
                    return new ResourceStatus(1, msg);
                }
            } else {
                if (!this.resourceUtil.isResourceRefInTarget(simpleJndiName, target)) {
                    String msg = I18N.getLocalString("delete.managed.executor.service.no.resource-ref", "This managed executor service [ {0} ] is not referenced in target [ {1} ]", new Object[]{jndiName, target});
                    if ("managed-scheduled-executor-service".equals(this.getResourceType())) {
                        msg = I18N.getLocalString("delete.managed.scheduled.executor.service.no.resource-ref", "This managed scheduled executor service [ {0} ] is not referenced in target [ {1} ]", new Object[]{jndiName, target});
                    }
                    return new ResourceStatus(1, msg);
                }
                if (this.resourceUtil.getTargetsReferringResourceRef(simpleJndiName).size() > 1) {
                    String msg = I18N.getLocalString("delete.managed.executor.service.multiple.resource-refs", "This managed executor service [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    if ("managed-scheduled-executor-service".equals(this.getResourceType())) {
                        msg = I18N.getLocalString("delete.managed.scheduled.executor.service.multiple.resource-refs", "This managed scheduled executor service [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", new Object[]{jndiName});
                    }
                    return new ResourceStatus(1, msg);
                }
            }
        }
        try {
            SingleConfigCode<Resources> configCode;
            if (!"domain".equals(target)) {
                this.resourceUtil.deleteResourceRef(simpleJndiName, target);
            }
            if (ConfigSupport.apply(configCode = param -> {
                ManagedExecutorServiceBase removedResource = null;
                removedResource = "managed-executor-service".equals(this.getResourceType()) ? (ManagedExecutorServiceBase)resources.getResourceByName(ManagedExecutorService.class, simpleJndiName) : (ManagedExecutorServiceBase)resources.getResourceByName(ManagedScheduledExecutorService.class, simpleJndiName);
                return param.getResources().remove(removedResource);
            }, resources) == null) {
                String msg = I18N.getLocalString("delete.managed.executor.service.failed", "Managed executor service {0} deletion failed", new Object[]{jndiName});
                if ("managed-scheduled-executor-service".equals(this.getResourceType())) {
                    msg = I18N.getLocalString("delete.managed.scheduled.executor.service.failed", "Managed scheduled executor service {0} deletion failed", new Object[]{jndiName});
                }
                return new ResourceStatus(1, msg);
            }
        }
        catch (TransactionFailure tfe) {
            String msg = I18N.getLocalString("delete.managed.executor.service.failed", "Managed executor service {0} deletion failed ", new Object[]{jndiName});
            if ("managed-scheduled-executor-service".equals(this.getResourceType())) {
                msg = I18N.getLocalString("delete.managed.scheduled.executor.service.failed", "Managed scheduled executor service {0} deletion failed ", new Object[]{jndiName});
            }
            ResourceStatus status = new ResourceStatus(1, msg);
            status.setException((Throwable)tfe);
            return status;
        }
        String msg = I18N.getLocalString("delete.managed.executor.service.success", "Managed executor service {0} deleted successfully", new Object[]{jndiName});
        if ("managed-scheduled-executor-service".equals(this.getResourceType())) {
            msg = I18N.getLocalString("delete.managed.scheduled.executor.service.success", "Managed scheduled executor service {0} deleted successfully", new Object[]{jndiName});
        }
        return new ResourceStatus(0, msg);
    }
}

