/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.BinaryDataMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.mappings.XMLConverterMapping;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecordImpl;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.xml.sax.SAXException;

public class XMLInlineBinaryHandler
extends UnmarshalRecordImpl {
    NodeValue nodeValue;
    Mapping mapping;
    boolean isCollection = false;
    XMLConverterMapping converter;
    UnmarshalRecord parent;
    CharSequence characters;

    public XMLInlineBinaryHandler(UnmarshalRecord parent, NodeValue nodeValue, Mapping mapping, XMLConverterMapping converter, boolean isCollection) {
        super(null);
        this.nodeValue = nodeValue;
        this.isCollection = isCollection;
        this.mapping = mapping;
        this.parent = parent;
        this.converter = converter;
        this.setUnmarshaller((Unmarshaller)parent.getUnmarshaller());
    }

    @Override
    public CharSequence getCharacters() {
        if (null != this.characters) {
            return this.characters;
        }
        return super.getCharacters();
    }

    @Override
    public void characters(char[] ch, int offset, int length) throws SAXException {
        this.getStringBuffer().append(ch, offset, length);
    }

    @Override
    public void characters(CharSequence characters) throws SAXException {
        this.characters = characters;
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        AbstractNullPolicy nullPolicy;
        Field field = null;
        Object value = this.getCharacters();
        boolean isHex = Constants.HEX_BINARY_QNAME.equals(((XMLField)this.mapping.getField()).getSchemaType());
        Class<?> attributeClassification = null;
        boolean isSwaRef = false;
        CoreContainerPolicy cp = null;
        if (this.isCollection) {
            isSwaRef = ((BinaryDataCollectionMapping)this.mapping).isSwaRef();
            field = (Field)this.mapping.getField();
            attributeClassification = ((BinaryDataCollectionMapping)this.mapping).getAttributeElementClass();
            nullPolicy = ((BinaryDataCollectionMapping)this.mapping).getNullPolicy();
            cp = (CoreContainerPolicy)this.mapping.getContainerPolicy();
        } else {
            isSwaRef = ((BinaryDataMapping)this.mapping).isSwaRef();
            field = (Field)this.mapping.getField();
            attributeClassification = this.mapping.getAttributeClassification();
            nullPolicy = ((BinaryDataMapping)this.mapping).getNullPolicy();
        }
        if (isSwaRef && ((Unmarshaller)this.parent.getUnmarshaller()).getAttachmentUnmarshaller() != null) {
            value = attributeClassification != null && attributeClassification == XMLBinaryDataHelper.getXMLBinaryDataHelper().DATA_HANDLER ? ((Unmarshaller)this.parent.getUnmarshaller()).getAttachmentUnmarshaller().getAttachmentAsDataHandler(value.toString()) : (Object)((Unmarshaller)this.parent.getUnmarshaller()).getAttachmentUnmarshaller().getAttachmentAsByteArray(value.toString());
        } else {
            Object valueFromReader = this.parent.getXMLReader().getValue(this.getCharacters(), attributeClassification);
            if (this.parent.isNil() && this.parent.getXMLReader().isNullRepresentedByXsiNil(nullPolicy)) {
                value = null;
                this.isCollection = this.isCollection && this.parent.getXMLReader().isInCollection();
            } else {
                String valueString;
                value = null != valueFromReader ? valueFromReader : ((valueString = value.toString()).length() == 0 && nullPolicy.isNullRepresentedByEmptyNode() ? null : (field.usesSingleNode() ? (isHex ? this.parent.getConversionManager().convertHexBinaryListToByteArrayList(valueString, cp, (CoreAbstractSession)this.parent.getSession()) : this.parent.getConversionManager().convertSchemaBase64ListToByteArrayList(valueString, cp, (CoreAbstractSession)this.parent.getSession())) : (isHex ? this.parent.getConversionManager().convertObject(valueString, ClassConstants.APBYTE, Constants.HEX_BINARY_QNAME) : (Object)this.parent.getConversionManager().convertSchemaBase64ToByteArray(valueString))));
                value = XMLBinaryDataHelper.getXMLBinaryDataHelper().convertObject(value, attributeClassification, (CoreAbstractSession)this.parent.getSession(), cp);
            }
        }
        value = this.converter.convertDataValueToObjectValue(value, this.parent.getSession(), this.parent.getUnmarshaller());
        if (this.isCollection) {
            this.parent.addAttributeValue((ContainerValue)((Object)this.nodeValue), value);
        } else {
            this.parent.setAttributeValue(value, this.mapping);
        }
        if (!field.isSelfField()) {
            this.parent.getXMLReader().setContentHandler(this.parent);
            this.parent.endElement(namespaceURI, localName, qName);
        }
        this.resetStringBuffer();
    }

    @Override
    public void resetStringBuffer() {
        super.resetStringBuffer();
        this.characters = null;
    }
}

