/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;

public class ThreadCursoredList<E>
extends Vector<E> {
    protected boolean isComplete = false;
    protected RuntimeException exception;

    public ThreadCursoredList() {
        this(10);
    }

    public ThreadCursoredList(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public ThreadCursoredList(int initialCapacity, int capacityIncrement) {
        super(0);
    }

    @Override
    public synchronized void add(int index, E element) {
        super.add(index, element);
        this.notifyAll();
    }

    @Override
    public synchronized boolean add(E element) {
        boolean result = super.add(element);
        this.notifyAll();
        return result;
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> collection) {
        boolean result = super.addAll(index, collection);
        this.notifyAll();
        return result;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        boolean result = super.addAll(collection);
        this.notifyAll();
        return result;
    }

    @Override
    public synchronized void addElement(E object) {
        super.addElement(object);
        this.notifyAll();
    }

    @Override
    public synchronized void clear() {
        this.waitUntilComplete();
        super.clear();
    }

    @Override
    public synchronized Object clone() {
        this.waitUntilComplete();
        return super.clone();
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public synchronized void throwException(RuntimeException exception) {
        this.exception = exception;
        this.setIsComplete(true);
    }

    public synchronized boolean isComplete() {
        if (this.exception != null) {
            RuntimeException thrownException = this.exception;
            this.exception = null;
            throw thrownException;
        }
        return this.isComplete;
    }

    public synchronized void setIsComplete(boolean isComplete) {
        this.isComplete = isComplete;
        this.notifyAll();
    }

    public synchronized void waitUntilComplete() {
        while (!this.isComplete()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void waitUntilAdd() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized boolean contains(Object element) {
        boolean result = super.contains(element);
        if (!result && !this.isComplete()) {
            this.waitUntilComplete();
            result = super.contains(element);
        }
        return result;
    }

    @Override
    public synchronized boolean containsAll(Collection<?> collection) {
        boolean result = super.containsAll(collection);
        if (!result && !this.isComplete()) {
            this.waitUntilComplete();
            result = super.containsAll(collection);
        }
        return result;
    }

    @Override
    public synchronized void copyInto(Object[] array) {
        this.waitUntilComplete();
        super.copyInto(array);
    }

    @Override
    public synchronized E elementAt(int index) {
        Object result = super.elementAt(index);
        if (result == null && !this.isComplete()) {
            this.waitUntilComplete();
            result = super.elementAt(index);
        }
        return result;
    }

    protected int getSize() {
        return super.size();
    }

    @Override
    public Enumeration<E> elements() {
        return new Enumeration<E>(){
            int count = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasMoreElements() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean result;
                    boolean bl = result = this.count < ThreadCursoredList.this.getSize();
                    while (!result && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        result = this.count < ThreadCursoredList.this.getSize();
                    }
                    return result;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E nextElement() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean result;
                    boolean bl = result = this.count < ThreadCursoredList.this.getSize();
                    while (!result && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        result = this.count < ThreadCursoredList.this.getSize();
                    }
                    if (result) {
                        return ThreadCursoredList.this.get(this.count++);
                    }
                }
                throw new NoSuchElementException("Vector Enumeration");
            }
        };
    }

    @Override
    public synchronized boolean equals(Object object) {
        this.waitUntilComplete();
        return super.equals(object);
    }

    @Override
    public synchronized E firstElement() {
        while (!this.isComplete() && super.isEmpty()) {
            this.waitUntilAdd();
        }
        return super.firstElement();
    }

    @Override
    public synchronized E get(int index) {
        while (!this.isComplete() && super.size() < index) {
            this.waitUntilAdd();
        }
        return super.get(index);
    }

    @Override
    public synchronized int hashCode() {
        this.waitUntilComplete();
        return super.hashCode();
    }

    @Override
    public int indexOf(Object element) {
        int result = super.indexOf(element);
        if (result == -1 && !this.isComplete()) {
            this.waitUntilComplete();
            result = super.indexOf(element);
        }
        return result;
    }

    @Override
    public synchronized int indexOf(Object element, int index) {
        int result = super.indexOf(element, index);
        if (result == -1 && !this.isComplete()) {
            this.waitUntilComplete();
            result = super.indexOf(element, index);
        }
        return result;
    }

    @Override
    public synchronized void insertElementAt(E element, int index) {
        super.insertElementAt(element, index);
        this.notify();
    }

    @Override
    public boolean isEmpty() {
        boolean result = super.isEmpty();
        if (result && !this.isComplete()) {
            this.waitUntilAdd();
            result = super.isEmpty();
        }
        return result;
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public synchronized E lastElement() {
        this.waitUntilComplete();
        return super.lastElement();
    }

    @Override
    public int lastIndexOf(Object element) {
        this.waitUntilComplete();
        return super.lastIndexOf(element);
    }

    @Override
    public synchronized int lastIndexOf(Object element, int index) {
        this.waitUntilComplete();
        return super.lastIndexOf(element, index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        return new ListIterator<E>(){
            int count;
            {
                this.count = index;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean result;
                    boolean bl = result = this.count < ThreadCursoredList.this.getSize();
                    while (!result && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        result = this.count < ThreadCursoredList.this.getSize();
                    }
                    return result;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E next() {
                ThreadCursoredList threadCursoredList = ThreadCursoredList.this;
                synchronized (threadCursoredList) {
                    boolean result;
                    boolean bl = result = this.count < ThreadCursoredList.this.getSize();
                    while (!result && !ThreadCursoredList.this.isComplete()) {
                        ThreadCursoredList.this.waitUntilAdd();
                        result = this.count < ThreadCursoredList.this.getSize();
                    }
                    if (result) {
                        return ThreadCursoredList.this.get(this.count++);
                    }
                }
                throw new NoSuchElementException("Vector Iterator");
            }

            @Override
            public void remove() {
                throw ValidationException.operationNotSupported("remove");
            }

            @Override
            public void set(Object object) {
                throw ValidationException.operationNotSupported("set");
            }

            @Override
            public void add(Object object) {
                throw ValidationException.operationNotSupported("add");
            }

            @Override
            public int previousIndex() {
                return this.count - 1;
            }

            @Override
            public int nextIndex() {
                return this.count;
            }

            @Override
            public E previous() {
                --this.count;
                return ThreadCursoredList.this.get(this.count);
            }

            @Override
            public boolean hasPrevious() {
                return this.count > 0;
            }
        };
    }

    @Override
    public synchronized E remove(int index) {
        while (!this.isComplete() && super.size() < index) {
            this.waitUntilAdd();
        }
        return super.remove(index);
    }

    @Override
    public boolean remove(Object element) {
        boolean result = super.remove(element);
        if (!result && !this.isComplete()) {
            this.waitUntilAdd();
            result = super.remove(element);
        }
        return result;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        this.waitUntilComplete();
        return super.removeAll(collection);
    }

    @Override
    public synchronized void removeAllElements() {
        this.waitUntilComplete();
        super.removeAllElements();
    }

    @Override
    public synchronized boolean removeElement(Object element) {
        boolean result = super.removeElement(element);
        if (!result && !this.isComplete()) {
            this.waitUntilAdd();
            result = super.removeElement(element);
        }
        return result;
    }

    @Override
    public synchronized void removeElementAt(int index) {
        while (!this.isComplete() && super.size() < index) {
            this.waitUntilAdd();
        }
        super.removeElementAt(index);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        this.waitUntilComplete();
        return super.retainAll(collection);
    }

    @Override
    public synchronized E set(int index, E element) {
        while (!this.isComplete() && super.size() < index) {
            this.waitUntilAdd();
        }
        return super.set(index, element);
    }

    @Override
    public synchronized void setElementAt(E element, int index) {
        while (!this.isComplete() && super.size() < index) {
            this.waitUntilAdd();
        }
        super.setElementAt(element, index);
    }

    @Override
    public int size() {
        this.waitUntilComplete();
        return super.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        while (!this.isComplete() && super.size() < toIndex) {
            this.waitUntilAdd();
        }
        return super.subList(fromIndex, toIndex);
    }

    @Override
    public synchronized Object[] toArray() {
        this.waitUntilComplete();
        return super.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] array) {
        this.waitUntilComplete();
        return super.toArray(array);
    }

    @Override
    public synchronized String toString() {
        this.waitUntilComplete();
        return super.toString();
    }

    @Override
    public synchronized void trimToSize() {
        this.waitUntilComplete();
        super.trimToSize();
    }
}

