/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server;

import jakarta.inject.Provider;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.ConnectionCallback;
import jakarta.ws.rs.core.GenericType;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.jersey.process.internal.RequestContext;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.server.AsyncContext;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.process.MappableException;

public class ChunkedOutput<T>
extends GenericType<T>
implements Closeable {
    private static final byte[] ZERO_LENGTH_DELIMITER = new byte[0];
    private final BlockingDeque<T> queue;
    private final byte[] chunkDelimiter;
    private final AtomicBoolean resumed = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();
    private boolean flushing = false;
    private boolean touchingEntityStream = false;
    private volatile boolean closed = false;
    private volatile AsyncContext asyncContext;
    private volatile RequestScope requestScope;
    private volatile RequestContext requestScopeContext;
    private volatile ContainerRequest requestContext;
    private volatile ContainerResponse responseContext;
    private volatile ConnectionCallback connectionCallback;

    protected ChunkedOutput() {
        this.chunkDelimiter = ZERO_LENGTH_DELIMITER;
        this.queue = new LinkedBlockingDeque<T>();
    }

    protected ChunkedOutput(Builder<T> builder) {
        this.queue = builder.queueCapacity > 0 ? new LinkedBlockingDeque<T>(builder.queueCapacity) : new LinkedBlockingDeque<T>();
        if (builder.chunkDelimiter != null) {
            this.chunkDelimiter = new byte[builder.chunkDelimiter.length];
            System.arraycopy(builder.chunkDelimiter, 0, this.chunkDelimiter, 0, builder.chunkDelimiter.length);
        } else {
            this.chunkDelimiter = ZERO_LENGTH_DELIMITER;
        }
        if (builder.asyncContextProvider != null) {
            this.asyncContext = (AsyncContext)builder.asyncContextProvider.get();
        }
    }

    private ChunkedOutput(TypedBuilder<T> builder) {
        super(builder.chunkType);
        this.queue = builder.queueCapacity > 0 ? new LinkedBlockingDeque<T>(builder.queueCapacity) : new LinkedBlockingDeque<T>();
        if (builder.chunkDelimiter != null) {
            this.chunkDelimiter = new byte[builder.chunkDelimiter.length];
            System.arraycopy(builder.chunkDelimiter, 0, this.chunkDelimiter, 0, builder.chunkDelimiter.length);
        } else {
            this.chunkDelimiter = ZERO_LENGTH_DELIMITER;
        }
        if (builder.asyncContextProvider != null) {
            this.asyncContext = (AsyncContext)builder.asyncContextProvider.get();
        }
    }

    public ChunkedOutput(Type chunkType) {
        super(chunkType);
        this.chunkDelimiter = ZERO_LENGTH_DELIMITER;
        this.queue = new LinkedBlockingDeque<T>();
    }

    protected ChunkedOutput(byte[] chunkDelimiter) {
        if (chunkDelimiter.length > 0) {
            this.chunkDelimiter = new byte[chunkDelimiter.length];
            System.arraycopy(chunkDelimiter, 0, this.chunkDelimiter, 0, chunkDelimiter.length);
        } else {
            this.chunkDelimiter = ZERO_LENGTH_DELIMITER;
        }
        this.queue = new LinkedBlockingDeque<T>();
    }

    protected ChunkedOutput(byte[] chunkDelimiter, Provider<AsyncContext> asyncContextProvider) {
        if (chunkDelimiter.length > 0) {
            this.chunkDelimiter = new byte[chunkDelimiter.length];
            System.arraycopy(chunkDelimiter, 0, this.chunkDelimiter, 0, chunkDelimiter.length);
        } else {
            this.chunkDelimiter = ZERO_LENGTH_DELIMITER;
        }
        this.asyncContext = asyncContextProvider == null ? null : (AsyncContext)asyncContextProvider.get();
        this.queue = new LinkedBlockingDeque<T>();
    }

    public ChunkedOutput(Type chunkType, byte[] chunkDelimiter) {
        super(chunkType);
        if (chunkDelimiter.length > 0) {
            this.chunkDelimiter = new byte[chunkDelimiter.length];
            System.arraycopy(chunkDelimiter, 0, this.chunkDelimiter, 0, chunkDelimiter.length);
        } else {
            this.chunkDelimiter = ZERO_LENGTH_DELIMITER;
        }
        this.queue = new LinkedBlockingDeque<T>();
    }

    protected ChunkedOutput(String chunkDelimiter) {
        this.chunkDelimiter = chunkDelimiter.isEmpty() ? ZERO_LENGTH_DELIMITER : chunkDelimiter.getBytes();
        this.queue = new LinkedBlockingDeque<T>();
    }

    public ChunkedOutput(Type chunkType, String chunkDelimiter) {
        super(chunkType);
        this.chunkDelimiter = chunkDelimiter.isEmpty() ? ZERO_LENGTH_DELIMITER : chunkDelimiter.getBytes();
        this.queue = new LinkedBlockingDeque<T>();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> TypedBuilder<T> builder(Type chunkType) {
        return new TypedBuilder(chunkType);
    }

    public void write(T chunk) throws IOException {
        if (this.closed) {
            throw new IOException(LocalizationMessages.CHUNKED_OUTPUT_CLOSED());
        }
        if (chunk != null) {
            try {
                this.queue.put(chunk);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
        }
        this.flushQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void flushQueue() throws IOException {
        block31: {
            if (this.resumed.compareAndSet(false, true) && this.asyncContext != null) {
                this.asyncContext.resume(this);
            }
            if (this.requestScopeContext == null || this.requestContext == null || this.responseContext == null) {
                return;
            }
            Exception ex = null;
            this.requestScope.runInScope(this.requestScopeContext, (Callable)new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws IOException {
                    Object t;
                    boolean shouldClose;
                    ChunkedOutput.this.lock.lock();
                    try {
                        if (ChunkedOutput.this.flushing) {
                            Void void_ = null;
                            return void_;
                        }
                        shouldClose = ChunkedOutput.this.closed;
                        t = ChunkedOutput.this.queue.poll();
                        if (t != null || shouldClose) {
                            ChunkedOutput.this.flushing = true;
                        }
                    }
                    finally {
                        ChunkedOutput.this.lock.unlock();
                    }
                    while (t != null) {
                        try {
                            ChunkedOutput.this.lock.lock();
                            ChunkedOutput.this.touchingEntityStream = true;
                            ChunkedOutput.this.lock.unlock();
                            OutputStream origStream = ChunkedOutput.this.responseContext.getEntityStream();
                            OutputStream writtenStream = ChunkedOutput.this.requestContext.getWorkers().writeTo(t, t.getClass(), ChunkedOutput.this.getType(), ChunkedOutput.this.responseContext.getEntityAnnotations(), ChunkedOutput.this.responseContext.getMediaType(), ChunkedOutput.this.responseContext.getHeaders(), ChunkedOutput.this.requestContext.getPropertiesDelegate(), origStream, Collections.emptyList());
                            if (ChunkedOutput.this.chunkDelimiter != ZERO_LENGTH_DELIMITER) {
                                writtenStream.write(ChunkedOutput.this.chunkDelimiter);
                            }
                            writtenStream.flush();
                            if (origStream != writtenStream) {
                                ChunkedOutput.this.responseContext.setEntityStream(writtenStream);
                            }
                        }
                        catch (IOException | UncheckedIOException ioe) {
                            ChunkedOutput.this.connectionCallback.onDisconnect((AsyncResponse)ChunkedOutput.this.asyncContext);
                            throw ioe;
                        }
                        catch (MappableException mpe) {
                            if (mpe.getCause() instanceof IOException || mpe.getCause() instanceof UncheckedIOException) {
                                ChunkedOutput.this.connectionCallback.onDisconnect((AsyncResponse)ChunkedOutput.this.asyncContext);
                            }
                            throw mpe;
                        }
                        finally {
                            ChunkedOutput.this.lock.lock();
                            ChunkedOutput.this.touchingEntityStream = false;
                            ChunkedOutput.this.lock.unlock();
                        }
                        t = ChunkedOutput.this.queue.poll();
                        if (t != null) continue;
                        ChunkedOutput.this.lock.lock();
                        try {
                            shouldClose = ChunkedOutput.this.closed;
                            t = ChunkedOutput.this.queue.poll();
                            if (t != null) continue;
                            ChunkedOutput.this.responseContext.commitStream();
                            ChunkedOutput.this.flushing = shouldClose;
                            break;
                        }
                        finally {
                            ChunkedOutput.this.lock.unlock();
                        }
                    }
                    return null;
                }
            });
            if (!this.closed) break block31;
            this.lock.lock();
            try {
                if (!this.touchingEntityStream) {
                    this.responseContext.close();
                }
            }
            catch (Exception e) {
                ex = ex == null ? e : ex;
            }
            finally {
                this.lock.unlock();
            }
            this.requestScopeContext.release();
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            break block31;
            catch (Exception e) {
                try {
                    this.closed = true;
                    ex = e;
                    this.onClose(e);
                    if (!this.closed) break block31;
                    this.lock.lock();
                }
                catch (Throwable throwable) {
                    if (this.closed) {
                        this.lock.lock();
                        try {
                            if (!this.touchingEntityStream) {
                                this.responseContext.close();
                            }
                        }
                        catch (Exception e2) {
                            ex = ex == null ? e2 : ex;
                        }
                        finally {
                            this.lock.unlock();
                        }
                        this.requestScopeContext.release();
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        if (ex instanceof RuntimeException) {
                            throw (RuntimeException)ex;
                        }
                    }
                    throw throwable;
                }
                try {
                    if (!this.touchingEntityStream) {
                        this.responseContext.close();
                    }
                }
                catch (Exception e3) {
                    ex = ex == null ? e3 : ex;
                }
                finally {
                    this.lock.unlock();
                }
                this.requestScopeContext.release();
                if (ex instanceof IOException) {
                    throw (IOException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.flushQueue();
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void onClose(Exception e) {
        this.queue.clear();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.queue.hashCode();
        return result;
    }

    public String toString() {
        return "ChunkedOutput<" + this.getType() + ">";
    }

    void setContext(RequestScope requestScope, RequestContext requestScopeContext, ContainerRequest requestContext, ContainerResponse responseContext, ConnectionCallback connectionCallbackRunner) throws IOException {
        this.requestScope = requestScope;
        this.requestScopeContext = requestScopeContext;
        this.requestContext = requestContext;
        this.responseContext = responseContext;
        this.connectionCallback = connectionCallbackRunner;
        this.flushQueue();
    }

    public static class Builder<Y> {
        byte[] chunkDelimiter;
        int queueCapacity = -1;
        Provider<AsyncContext> asyncContextProvider;

        private Builder() {
        }

        public Builder<Y> chunkDelimiter(byte[] chunkDelimiter) {
            this.chunkDelimiter = chunkDelimiter;
            return this;
        }

        public Builder<Y> queueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
            return this;
        }

        public Builder<Y> asyncContextProvider(Provider<AsyncContext> asyncContextProvider) {
            this.asyncContextProvider = asyncContextProvider;
            return this;
        }

        public ChunkedOutput<Y> build() {
            return new ChunkedOutput(this);
        }
    }

    public static class TypedBuilder<Y>
    extends Builder<Y> {
        private Type chunkType;

        private TypedBuilder(Type chunkType) {
            this.chunkType = chunkType;
        }

        @Override
        public ChunkedOutput<Y> build() {
            return new ChunkedOutput(this);
        }
    }
}

