/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources;

import com.sun.enterprise.config.serverbeans.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.glassfish.resourcebase.resources.ResourceTypeOrder;
import org.jvnet.hk2.annotations.Service;

@Service
public class ResourceTypeOrderProcessor {
    public Collection<Resource> getOrderedResources(Collection<Resource> resources) {
        ArrayList<Resource> resourceList = new ArrayList<Resource>(resources);
        Collections.sort(resourceList, new ResourceComparator(this));
        return resourceList;
    }

    private class ResourceComparator
    implements Comparator<Resource> {
        private ResourceComparator(ResourceTypeOrderProcessor resourceTypeOrderProcessor) {
        }

        @Override
        public int compare(Resource o1, Resource o2) {
            ResourceTypeOrder resourceTypeOrder;
            Class<?>[] allInterfaces;
            Class<?> o1Class = null;
            Class<?> o2Class = null;
            Class<?>[] interfaces = o1.getClass().getInterfaces();
            if (interfaces != null) {
                for (Class<?> clz : interfaces) {
                    if (!Resource.class.isAssignableFrom(clz)) continue;
                    o1Class = clz;
                }
            }
            if ((interfaces = o2.getClass().getInterfaces()) != null) {
                for (Class<?> clz : interfaces) {
                    if (!Resource.class.isAssignableFrom(clz)) continue;
                    o2Class = clz;
                }
            }
            if (o1Class == null && o2Class == null) {
                return 0;
            }
            if (o1Class == null && o2Class != null) {
                return -1;
            }
            if (o1Class != null && o2Class == null) {
                return 1;
            }
            if (o1Class.equals(o2Class)) {
                int i1 = Integer.parseInt(o1.getDeploymentOrder());
                int i2 = Integer.parseInt(o2.getDeploymentOrder());
                return i2 > i1 ? -1 : (i1 == i2 ? 0 : 1);
            }
            int o1deploymentOrder = 100;
            int o2deploymentOrder = 100;
            for (Class<?> resourceInterface : allInterfaces = o1.getClass().getInterfaces()) {
                resourceTypeOrder = resourceInterface.getAnnotation(ResourceTypeOrder.class);
                if (resourceTypeOrder == null) continue;
                o1deploymentOrder = resourceTypeOrder.deploymentOrder().getResourceDeploymentOrder();
            }
            for (Class<?> resourceInterface : allInterfaces = o2.getClass().getInterfaces()) {
                resourceTypeOrder = resourceInterface.getAnnotation(ResourceTypeOrder.class);
                if (resourceTypeOrder == null) continue;
                o2deploymentOrder = resourceTypeOrder.deploymentOrder().getResourceDeploymentOrder();
            }
            return o2deploymentOrder > o1deploymentOrder ? -1 : (o2deploymentOrder == o1deploymentOrder ? 0 : 1);
        }
    }
}

